//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RST_MONITOR_SV
`define RST_MONITOR_SV


class rst_monitor extends uvm_monitor;

  virtual rst_if vif;
  rst_config     cfg;
  uvm_analysis_port #(rst_seq_item) ap;

  `uvm_component_utils(rst_monitor)

  function new(string name = "rst_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual rst_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      observe_reset();
      /* add some task calls here */
    join_none;
  endtask : run_phase


  task observe_reset();
    wait (vif.rst_sig == cfg.rst_polarity);
    `uvm_info(get_type_name(), "Transaction recording interrupted by reset assertion.", UVM_LOW);
  endtask : observe_reset


  task collect_transaction();
    rst_seq_item item = rst_seq_item::type_id::create("item");

    forever begin
      if (cfg.rst_polarity)
        @(posedge vif.rst_sig);
      else
        @(negedge vif.rst_sig);

      item.rst = vif.rst_sig;

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end// forever
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : rst_monitor

`endif //RST_MONITOR_SV
