//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RST_SEQ_ITEM_SV
`define RST_SEQ_ITEM_SV


class rst_seq_item extends uvm_sequence_item;

  rand bit rst;             // reset level
  rand int unsigned hold_time;       // duration of active reset signal [us] (hold time)
  rand int unsigned removal_time;    // duration of inactive reset signal [us] (removal time)
  rand bit idle;            // idle state active
  rand int unsigned idle_cycles_cnt; // counter for idle cycles in wait state

  `uvm_object_utils_begin(rst_seq_item)
    `uvm_field_int(rst, UVM_DEFAULT)
    `uvm_field_int(hold_time, UVM_DEFAULT)
    `uvm_field_int(removal_time, UVM_DEFAULT)
    `uvm_field_int(idle, UVM_DEFAULT)
    `uvm_field_int(idle_cycles_cnt, UVM_DEFAULT)
  `uvm_object_utils_end

  constraint c_hold_time { hold_time >= 1; hold_time <= 100; }
  constraint c_removal_time { removal_time >= 1; removal_time <= 10; }
  constraint c_idle_off { idle == 0; }
  constraint c_idle_cnt { idle_cycles_cnt > 0; }

  function new (string name = "rst_seq_item");
    super.new(name);
  endfunction : new

endclass : rst_seq_item

`endif //RST_SEQ_ITEM_SV
