//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_GET_NEXT_RHD_SEQ_SV
`define SRAM_GET_NEXT_RHD_SEQ_SV

class sram_get_next_rhd_seq extends sram_seq_base;

  bit [31:0]            addr;
  bit [31:0]            next_rhd_ptr;
  bit                   payload_zero;

  `uvm_object_utils(sram_get_next_rhd_seq)


  function new(string name = "sram_get_next_rhd_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd == GET_NEXT_RHD_PTR;
        req.rhd_head_addr == addr;
      });
      finish_item(req);
      // fetch response from driver
      get_response(rsp, req.get_transaction_id());
      next_rhd_ptr = rsp.get_last_read_ptr;
      payload_zero = rsp.payload_zero;
    end
  endtask : body

endclass : sram_get_next_rhd_seq


`endif //SRAM_GET_NEXT_RHD_SEQ_SV
