//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_PREPARE_RX_DESCR_SEQ_SV
`define SRAM_PREPARE_RX_DESCR_SEQ_SV

class sram_prepare_rx_descr_seq extends sram_seq_base;

  int unsigned rhd;
  int unsigned rpd;
  bit          smaller_rx_segment; //in Tx tests use smaller Rx segnemt for storing frames

  `uvm_object_utils(sram_prepare_rx_descr_seq)


  function new(string name = "sram_prepare_rx_descr_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), $sformatf("sram_prepare_rx_descr_seq: num_of_rhd %0d, num_of_rpd %0d",rhd,rpd), UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd == PREPARE_RD_BUFF;
        req.num_of_rhd == rhd;
        req.num_of_rpd == rpd;
        req.smaller_rx_segment == local::smaller_rx_segment;
      });
      finish_item(req);
    end
  endtask : body

endclass : sram_prepare_rx_descr_seq


`endif //SRAM_PREPARE_RX_DESCR_SEQ_SV
