//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_READ_TX_STATUS_SEQ_SV
`define SRAM_READ_TX_STATUS_SEQ_SV

class sram_rd_tx_status_seq extends sram_seq_base;

  bit [31:0]      addr;
  bit             skip;

  `uvm_object_utils(sram_rd_tx_status_seq)


  function new(string name = "sram_rd_tx_status_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), $sformatf("Starting sram_rd_tx_status_seq..."), UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd == RD_TX_STATUS;
        req.thd_head_addr == addr;
        req.skip_athd == skip;
      });
      finish_item(req);
    end
  endtask : body

endclass : sram_rd_tx_status_seq


`endif //SRAM_READ_TX_STATUS_SEQ_SV
