//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_RD_WORD_SEQ_SV
`define SRAM_RD_WORD_SEQ_SV

class sram_rd_word_seq extends sram_seq_base;

  bit [31:0]            addr;
  bit [31:0]            data;

  `uvm_object_utils(sram_rd_word_seq)


  function new(string name = "sram_rd_word_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd == READ_MEM;
        req.rd_wr_addr == addr;
      });
      finish_item(req);
      // fetch response from driver
      get_response(rsp, req.get_transaction_id());
      data = rsp.rd_wr_data;
    end
  endtask : body

endclass : sram_rd_word_seq


`endif //SRAM_RD_WORD_SEQ_SV

