//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_WR_SEQ_SV
`define SRAM_WR_SEQ_SV

class sram_wr_seq extends sram_seq_base;

  PPDU_frame            frame;
  mac_ctrl_info_1_s     mac_ctrl_info_1;
  mac_ctrl_info_2_s     mac_ctrl_info_2;
  pt_mac_ctrl_info_2_s  pt_mac_ctrl_info_2;
  nav_prot_frm_e        prot;
  bit [31:0]            addr;
  bit [9:0]             pt_ksr_index[4];

  `uvm_object_utils(sram_wr_seq)


  function new(string name = "sram_wr_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      req.frame              = frame; // push down handle
      req.mac_ctrl_info_1    = mac_ctrl_info_1;
      req.mac_ctrl_info_2    = mac_ctrl_info_2;
      req.pt_mac_ctrl_info_2 = pt_mac_ctrl_info_2;
      foreach (req.pt_ksr_index[i])
        req.pt_ksr_index[i] = pt_ksr_index[i];

      assert(req.randomize() with {
        req.cmd == WRITE_TX_FRAME;
        // randomize THD head address only if needed
        if (addr != 0) {
          req.thd_head_addr == addr;
        }
        foreach (req.pt_rate_ctrl[i]) {
          req.pt_rate_ctrl[i].nav_prot_frm_f == prot;
        }
      });
      finish_item(req);
    end
  endtask : body

endclass : sram_wr_seq


`endif //SRAM_WR_SEQ_SV
