//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_WR_WORD_SEQ_SV
`define SRAM_WR_WORD_SEQ_SV

class sram_wr_word_seq extends sram_seq_base;

  bit [31:0]            addr;
  bit [31:0]            data;

  `uvm_object_utils(sram_wr_word_seq)


  function new(string name = "sram_wr_word_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = sram_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd == WRITE_MEM;
        req.rd_wr_addr == addr;
        req.rd_wr_data == data;
      });
      finish_item(req);
    end
  endtask : body

endclass : sram_wr_word_seq


`endif //SRAM_WR_WORD_SEQ_SV
