//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_COMMON_SV
`define SRAM_COMMON_SV

  `define    MAX_ADDR_SIZE             (2**17-1)
  `define    MEM_TX_SEGMENT            (4)
  `define    MEM_RX_SEGMENT_START      (4)
  `define    MEM_RX_SEGMENT            ((`MAX_ADDR_SIZE * 8/10) & 32'hFFFF_FFFC)
  `define    MEM_PT_SEGMENT            ((`MAX_ADDR_SIZE-200) & 32'hFFFF_FFFC)

  `define    BUFF_MAX_SIZE              512
  `define    SRAM_DELAY_TICK            1ps
  `define    FIRST_USER_OFFSET          12
  `define    SECOND_USER_OFFSET         16
  `define    THIRD_USER_OFFSET          20
  `define    PT_OFFSET                  36
  `define    NEXT_ATOMIC_FRAME_OFFSET   4
  `define    NEXT_MPDU_OFFSET           8
  `define    FIRST_PLD_BUFF_PTR_OFFSET  12
  `define    USER1_AMPDU_THD_PTR        12
  `define    USER2_AMPDU_THD_PTR        16
  `define    USER3_AMPDU_THD_PTR        20
  `define    NEXT_RHD_OFFSET            4
  `define    NEXT_RPD_OFFSET            4

  typedef enum {
    WRITE_TX_FRAME,    /* command stores PPDU frame in memory */
    READ_RX_FRAME,     /* command reads PPDU from memory      */
    PREPARE_RD_BUFF,   /* command prepares RHD and RPD buffers for reception */
    RD_TX_STATUS,      /* command reads THD status information fields */
    GET_NEXT_RHD_PTR,  /* command reads address of next RHD pointers  */
    WRITE_MEM,         /* command writes data at given address        */
    READ_MEM           /* command read data from given address        */
  } mem_access_e;

`endif// SRAM_COMMON_SV
