//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_CONFIG_SV
`define SRAM_CONFIG_SV

class sram_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;
  // curent pointers in to free mememory location
  bit [31:0]                     thd_head_ptr;
  bit [31:0]                     thd_curr_ptr;
  bit [31:0]                     rhd_head_ptr;
  bit [31:0]                     rpd_head_ptr;
  bit [31:0]                     rhd_curr_ptr;
  bit [31:0]                     rpd_curr_ptr;
  bit [31:0]                     pt_curr_ptr;
  bit [3:0]                      pti; // Packet Traffic Information
  bit                            use_cfg_pt_ptr; // prevent using policy table generated in seq item
  bit                            trigger_based_frame; // frame is trigger based and stored in AC TB

  `uvm_object_utils_begin(sram_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(thd_head_ptr, UVM_DEFAULT)
    `uvm_field_int(thd_curr_ptr, UVM_DEFAULT)
    `uvm_field_int(rhd_head_ptr, UVM_DEFAULT)
    `uvm_field_int(rpd_head_ptr, UVM_DEFAULT)
    `uvm_field_int(rhd_curr_ptr, UVM_DEFAULT)
    `uvm_field_int(rpd_curr_ptr, UVM_DEFAULT)
    `uvm_field_int(pt_curr_ptr,  UVM_DEFAULT)
    `uvm_field_int(pti,  UVM_DEFAULT)
    `uvm_field_int(use_cfg_pt_ptr,  UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "sram_config");
    super.new(name);

    // init current policy table pointer because of usage of
    // sram_wr_seq with THD address set, in that case current
    // pointer on policy table would be 0 so we initialize it
    pt_curr_ptr = `MEM_PT_SEGMENT;
    pti = 0;
    use_cfg_pt_ptr = 0;
    trigger_based_frame = 0;
  endfunction

endclass : sram_config

`endif
