//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_BUS_AGENT_SV
`define SRAM_BUS_AGENT_SV

//-----------------------------------

class sram_bus_agent extends uvm_agent;

  sram_bus_config         cfg;
  sram_bus_monitor        monitor;

  `uvm_component_utils_begin(sram_bus_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "sram_bus_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(sram_bus_config)::get(this, "", "cfg", cfg))
      `uvm_fatal(get_type_name(), "Config not set for agent")

    // Create components
    monitor = sram_bus_monitor::type_id::create("monitor",this);

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    monitor.cfg = cfg;
  endfunction : connect_phase

endclass : sram_bus_agent

`endif // SRAM_BUS_AGENT_SV
