//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef SRAM_BUS_CONFIG_SV
`define SRAM_BUS_CONFIG_SV

class sram_bus_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            has_coverage      = 1;
  bit                            has_checks        = 1;
  bit[14:0]                      sram_lli_boundary = 15'h0100/8; // DWORD address
 
  `uvm_object_utils_begin(sram_bus_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage,      UVM_DEFAULT)
    `uvm_field_int(has_checks,        UVM_DEFAULT)
    `uvm_field_int(sram_lli_boundary, UVM_DEFAULT)    
  `uvm_object_utils_end

  function new (string name = "sram_bus_config");
    super.new(name);
  endfunction

endclass : sram_bus_config

`endif // SRAM_BUS_CONFIG_SV
