//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company      : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies   : None
// Description    :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator    :
// Parameters     :
// Terms & concepts :
// Bugs       :
// Open issues and future enhancements :
// References     :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef SRAM_BUS_MONITOR_SV
`define SRAM_BUS_MONITOR_SV

class sram_bus_monitor extends uvm_monitor;

  virtual sram_bus_if  vif;
  sram_bus_config    cfg;
  uvm_analysis_port #(sram_bus_seq_item) ap;

  `uvm_component_utils(sram_bus_monitor)
  extern function new(string name = "sram_bus_monitor", uvm_component parent = null);
  extern virtual function void build_phase(uvm_phase phase);
  extern virtual function void connect_phase(uvm_phase phase);
  extern virtual task run_phase(uvm_phase phase);
  extern virtual task observe_reset();
  extern virtual task collect_transaction();
  extern virtual function void perform_checks();
  extern virtual function void report_phase(uvm_phase phase);

endclass : sram_bus_monitor

  function sram_bus_monitor::new(string name = "sram_bus_monitor", uvm_component parent = null);
   super.new(name, parent);
  endfunction : new

  function void sram_bus_monitor::build_phase(uvm_phase phase);
    super.build_phase(phase);

    if (!uvm_config_db#(virtual sram_bus_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  function void sram_bus_monitor::connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  task sram_bus_monitor::run_phase(uvm_phase phase);
    super.run_phase(phase);
    fork
      collect_transaction();
      observe_reset();
    join_none;
  endtask : run_phase

  task sram_bus_monitor::observe_reset();
    wait(vif.nrst === 1'b0);  // Reset assertion
    `uvm_info(get_type_name(), "Transaction recording interrupted by reset assertion.", UVM_DEBUG);
    wait(vif.nrst === 1'b1);  // Reset deassertion
  endtask : observe_reset

  task sram_bus_monitor::collect_transaction();
    sram_bus_seq_item  item;
    bit[14:0]          read_addr;
    bit                read_is_active;
    forever begin
      @(posedge vif.clk);
       if(read_is_active) begin : READ_REQUEST_WAS_ACTIVE
        // READ request was active during the previous cycle
        item = sram_bus_seq_item ::type_id::create("item");
        item.data  = vif.douta;
        item.addra = read_addr;
        item.rnw   = 1'b1; // Indicate READ
        read_is_active = 1'b0; // Clear flag
        `uvm_info(get_type_name(), $sformatf("Collected SRAM bus transfer = \n %s", item.convert2string), UVM_DEBUG)
        ap.write(item);
       end // READ_REQUEST_WAS_ACTIVE
      if(vif.ena === 1'b1) begin
       if((|vif.wea) == 1'b1) begin : WRITE_ACCESS
        item = sram_bus_seq_item ::type_id::create("item");
        item.data  = vif.dina;
        item.wea   = vif.wea;
        item.addra = vif.addra;
        item.rnw   = 1'b0;
        `uvm_info(get_type_name(), $sformatf("Collected SRAM bus transfer = \n %s", item.convert2string), UVM_DEBUG)
        ap.write(item);
       end // WRITE_ACCESS
       else begin : READ_ACCESS
        read_addr = vif.addra; // Save READ address
        read_is_active = 1'b1; // READ is active
       end  // READ_ACCESS
      end


    end
  endtask : collect_transaction


  function void sram_bus_monitor::perform_checks();
   // Empty for the moment
  endfunction : perform_checks

  function void sram_bus_monitor::report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

`endif // SRAM_BUS_MONITOR_SV
