//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef SRAM_BUS_SEQ_ITEM_SV
`define SRAM_BUS_SEQ_ITEM_SV

class sram_bus_seq_item extends uvm_sequence_item;
  bit rnw;
  bit[63:0] data;
  bit[14:0] addra;
  bit[7:0] wea;

  `uvm_object_utils_begin(sram_bus_seq_item)
  `uvm_field_int(rnw,               UVM_DEFAULT)
  `uvm_field_int(data,              UVM_DEFAULT)
  `uvm_field_int(addra,             UVM_DEFAULT)
  `uvm_field_int(wea,               UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "sram_bus_seq_item");
    super.new(name);
  endfunction : new

  virtual function string convert2string();
    string res = "";
    res = "-------------------------------------------------------------\n"; // Delimiter
    // Procede address part
    res = {res, $sformatf("addra    %4X\n", addra)};
    res = {res, $sformatf("rnw      %1b\n", rnw)};
    res = {res, $sformatf("data     %8X\n", data)};     
    res = {res, $sformatf("wea      %2X\n", wea)};               
    res = {res, "-------------------------------------------------------------\n"}; // Delimiter
    return res;
  endfunction : convert2string  

endclass : sram_bus_seq_item

`endif // SRAM_BUS_SEQ_ITEM_SV
