//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Trasmit Header Descriptor
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef RHD_SV
`define RHD_SV

class RHD extends uvm_object;

  bit [31:0]          next_hader_descr_ptr;
  bit [31:0]          first_payload_buff_ptr;
  bit [31:0]          sw_descr_ptr;
  bit [31:0]          data_start_ptr;
  bit [31:0]          data_end_ptr;
  header_ctrl_info_s  header_ctrl_info;
  ampdu_status_info_s ampdu_status_info;
  bit [15:0]          payload_len;
  bit [31:0]          tsf_lo;
  bit [31:0]          tsf_hi;
  bit [31:0]          received_vector_1a;
  bit [31:0]          received_vector_1b;
  bit [31:0]          received_vector_1c;
  bit [31:0]          received_vector_1d;
  bit [31:0]          received_vector_2a;
  bit [31:0]          received_vector_2b;
  mpdu_statu_info_s   mpdu_statu_info;
  // MAC header raw data
  bit [7:0]           mac_header[];

  `uvm_object_utils_begin(RHD)
    `uvm_field_int(next_hader_descr_ptr  , UVM_DEFAULT)
    `uvm_field_int(first_payload_buff_ptr, UVM_DEFAULT)
    `uvm_field_int(sw_descr_ptr          , UVM_DEFAULT)
    `uvm_field_int(data_start_ptr        , UVM_DEFAULT)
    `uvm_field_int(data_end_ptr          , UVM_DEFAULT)
    `uvm_field_int(header_ctrl_info      , UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_int(payload_len           , UVM_DEFAULT)
    `uvm_field_int(ampdu_status_info     , UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_int(tsf_lo                , UVM_DEFAULT)
    `uvm_field_int(tsf_hi                , UVM_DEFAULT)
    `uvm_field_int(received_vector_1a    , UVM_DEFAULT)
    `uvm_field_int(received_vector_1b    , UVM_DEFAULT)
    `uvm_field_int(received_vector_1c    , UVM_DEFAULT)
    `uvm_field_int(received_vector_1d    , UVM_DEFAULT)
    `uvm_field_int(received_vector_2a    , UVM_DEFAULT)
    `uvm_field_int(received_vector_2b    , UVM_DEFAULT)
    `uvm_field_int(mpdu_statu_info       , UVM_DEFAULT | UVM_NOPRINT)
  `uvm_object_utils_end

  function new (string name = "RHD");
    super.new(name);
  endfunction

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  function void do_copy(uvm_object rhs);
    RHD rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    mac_header = new[rhs_.mac_header.size()](rhs_.mac_header);
  endfunction : do_copy

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("header ctrl info", $sformatf("%p",header_ctrl_info));
    printer.print_string("ampdu status info", $sformatf("%p",ampdu_status_info));
    printer.print_string("mpdu status info", $sformatf("%p",mpdu_statu_info));
    printer.print_string("MAC header", $sformatf("%p",mac_header));
  endfunction : do_print

endclass : RHD

`endif//RHD_SV

