//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Trasmit Header Descriptor
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef RPD_SV
`define RPD_SV

class RPD extends uvm_object;

  bit [31:0]          next_payload_buff_ptr;
  bit [31:0]          data_start_ptr;
  bit [31:0]          data_end_ptr;
  buff_status_info_s  buff_status_info;
  // data that RPD points to
  bit [7:0]           payload[];

  `uvm_object_utils_begin(RPD)
    `uvm_field_int(next_payload_buff_ptr, UVM_DEFAULT)
    `uvm_field_int(data_start_ptr       , UVM_DEFAULT)
    `uvm_field_int(data_end_ptr         , UVM_DEFAULT)
    `uvm_field_int(buff_status_info     , UVM_DEFAULT | UVM_NOPRINT)
  `uvm_object_utils_end

  function new (string name = "RPD");
    super.new(name);
  endfunction

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  function void do_copy(uvm_object rhs);
    RPD rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    payload = new[rhs_.payload.size()](rhs_.payload);
  endfunction : do_copy

  //------------------------------------------------------------
  // custom print function
  //------------------------------------------------------------
  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("buff status info", $sformatf("%p",buff_status_info));
    foreach (payload[i]) printer.print_string($sformatf("Payload[%0d] ",i), $sformatf("%0h",payload[i]));
  endfunction : do_print

endclass : RPD

`endif//RPD_SV
