//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Trasmit Header Descriptor
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef TBD_SV
`define TBD_SV

class TBD extends uvm_object;

  bit [31:0]          next_payload_buff_ptr;
  bit [31:0]          data_start_ptr;
  bit [31:0]          data_end_ptr;
  buff_ctrl_info_s    buff_ctrl_info;

  `uvm_object_utils_begin(TBD)
    `uvm_field_int(next_payload_buff_ptr, UVM_DEFAULT)
    `uvm_field_int(data_start_ptr       , UVM_DEFAULT)
    `uvm_field_int(data_end_ptr         , UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "TBD");
    super.new(name);
  endfunction

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("buff ctrl info", $sformatf("%p",buff_ctrl_info));
  endfunction : do_print

endclass : TBD

`endif//TBD_SV

