//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Trasmit Header Descriptor
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef THD_SV
`define THD_SV

class THD extends uvm_object;

  bit [31:0]          next_atomic_frm_ptr;
  bit [31:0]          next_mpdu_descr_ptr;
  bit [31:0]          first_tbd_ptr_user1_thd_ptr;
  bit [31:0]          data_start_ptr_user2_thd_ptr;
  bit [31:0]          data_end_ptr_user3_thd_ptr;
  bit [19:0]          frm_length;
  bit [31:0]          frm_lifetime;
  phy_ctrl_info_s     phy_ctrl_info;
  bit [31:0]          policy_table_addr;
  bit [19:0]          optional_frm_len_20mhz;
  bit [19:0]          optional_frm_len_40mhz;
  bit [19:0]          optional_frm_len_80mhz;
  mac_ctrl_info_1_s   mac_ctrl_info_1;
  mac_ctrl_info_2_s   mac_ctrl_info_2;
  status_info_s       status_info;
  bit [31:0]          medium_time_used;

  `uvm_object_utils_begin(THD)
    `uvm_field_int(next_atomic_frm_ptr         , UVM_DEFAULT)
    `uvm_field_int(next_mpdu_descr_ptr         , UVM_DEFAULT)
    `uvm_field_int(first_tbd_ptr_user1_thd_ptr , UVM_DEFAULT)
    `uvm_field_int(data_start_ptr_user2_thd_ptr, UVM_DEFAULT)
    `uvm_field_int(data_end_ptr_user3_thd_ptr  , UVM_DEFAULT)
    `uvm_field_int(frm_length                  , UVM_DEFAULT)
    `uvm_field_int(frm_lifetime                , UVM_DEFAULT)
    `uvm_field_int(policy_table_addr           , UVM_DEFAULT)
    `uvm_field_int(optional_frm_len_20mhz      , UVM_DEFAULT)
    `uvm_field_int(optional_frm_len_40mhz      , UVM_DEFAULT)
    `uvm_field_int(optional_frm_len_80mhz      , UVM_DEFAULT)
    `uvm_field_int(medium_time_used            , UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "THD");
    super.new(name);
  endfunction

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("phy ctrl info", $sformatf("%p",phy_ctrl_info));
    printer.print_string("mac ctrl info 1", $sformatf("%p",mac_ctrl_info_1));
    printer.print_string("mac ctrl info 2", $sformatf("%p",mac_ctrl_info_2));
    printer.print_string("status info", $sformatf("%p",status_info));
  endfunction : do_print

endclass : THD

`endif//THD_SV
