//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef DESCRIPTORS_COMMON_SV
`define DESCRIPTORS_COMMON_SV

  `define THD_UNIQUE_PATTERN        32'hCAFEBABE
  `define TBD_UNIQUE_PATTERN        32'hCAFEFADE
  `define THD_LEN                   17
  `define TBD_LEN                   5

  `define RHD_UNIQUE_PATTERN        32'hBAADF00D
  `define RPD_UNIQUE_PATTERN        32'hC0DEDBAD
  `define RHD_LEN                   17
  `define RPD_LEN                   5

  // Policy table
  `define PT_UNIQUE_PATTERN         32'hBADCAB1E
  `define PT_LEN                    13

  //-----------------------------------------------
  // Trasmit Header Descriptor
  //-----------------------------------------------

  typedef struct packed {
    bit           reserved1_f;
    bit [8:0]     partial_aid_f;
    bit [5:0]     group_id_f;
    bit           mu_mimo_f;
    bit           reserved2_f;
    bit [1:0]     user_position_f;
    bit [3:0]     ptit_f;     /* Packet trafic information */
    bit           reserved3_f;
    bit           continous_tx_f;
    bit           doze_not_allowed_f;
    bit           dyn_bw_f;
    bit           use_bw_signaling_f;
    bit [2:0]     reserved4_f;
  } phy_ctrl_info_s;

  typedef struct packed {
    bit [15:0]    prot_frm_dur_f;
    bit           reserved1_f;
    bit           write_ack_f;
    bit           low_rate_retry_f;
    bit           lstp_prot_f;
    bit           lstp_f;
    bit [1:0]     expect_ack_f;
    bit [8:0]     reserved2_f;
  } mac_ctrl_info_1_s;

  typedef struct packed {
    bit           dont_generate_mh_f;
    bit           dont_encrypt_f;
    bit           dont_touch_fc_f;
    bit           dont_touch_dur_f;
    bit           dont_touch_qos_f;
    bit           dont_touch_htc_f;
    bit           dont_touch_tsf_f;
    bit           dont_touch_dtim_f;
    bit           dont_touch_fcs_f;
    bit           under_ba_setup_f;
    bit           ampdu_f;
    bit [1:0]     which_descr_f;
    bit [9:0]     num_blank_delimit_f;
    bit           int_en_f;
    bit           reserved_f;
    bit [3:0]     subtype_f;
    bit [1:0]     type_f;
    bit           ts_valid_f;
  } mac_ctrl_info_2_s;

  typedef struct packed {
    bit           descr_done_hw_f;
    bit           descr_done_sw_f;
    bit [3:0]     which_descr_sw_f;
    bit [1:0]     trans_bw_f;
    bit           frm_successful_f;
    bit [3:0]     reserved_f;
    bit           ba_frm_rcvd_f;
    bit           lifetime_expired_f;
    bit           retry_limit_reached_f;
    bit [7:0]     num_mpdu_retries_f;
    bit [7:0]     num_rts_retries_f;
  } status_info_s;

  typedef enum bit [1:0] {
    NO_ACK        = 2'b00,
    NORMAL_ACK    = 2'b01,
    BA            = 2'b10,
    COMPRESSED_BA = 2'b11
  } expect_ack_e;

  //-----------------------------------------------
  // Trasmit Buffer Descriptor
  //-----------------------------------------------

  typedef struct packed {
    bit           buff_done_hw_f;
    bit           buff_done_sw_f;
    bit [28:0]    reserved_f;
    bit           buff_int_en_f;
  } buff_ctrl_info_s;

  //-----------------------------------------------
  // Receive Header Descriptor
  //-----------------------------------------------

  typedef struct packed {
    bit [30:0]    reserved_f;
    bit           int_en_f;
  } header_ctrl_info_s;

  typedef struct packed {
    bit [1:0]     ampdu_cnt_f;
    bit [5:0]     mpdu_cnt_f;
    bit [7:0]     reserved_f;
    bit [15:0]    payloadlengthrx_f;
  } ampdu_status_info_s;

  typedef struct packed {
    bit [3:0]     subtype_f;
    bit [1:0]     type_f;
    bit           key_sram_valid_idx_f;
    bit [9:0]     key_sram_idx_f;
    bit           descr_done_f;
    bit           frm_successful_f;
    bit [1:0]     current_ac_f;
    bit           ga_frm_f;
    bit           addr_mismatch_f;
    bit           fcs_err_f;
    bit           undef_err_f;
    bit           decry_err_f;
    bit [3:0]     decry_type_f;        // 4’b0000: Frame was not encrypted
                                       // 4’b0001: WEP
                                       // 4’b0010: TKIP
                                       // 4’b0011: CCMP-128
                                       // 4’b0100: CCMP-256
                                       // 4’b0101: GCMP-128
                                       // 4’b0110: GCMP-256
                                       // 4’b0111: WAPI
                                       // 4’b1111: Null Key Found
    bit           resp_frm_f;
    bit           rx_vector2_valid_f;
  } mpdu_statu_info_s;

  //-----------------------------------------------
  // Receive Payload Descriptor
  //-----------------------------------------------

  typedef struct packed {
    bit [29:0]    reserved_f;
    bit           descr_done_f;
    bit           last_buff_f;
  } buff_status_info_s;

  //-----------------------------------------------
  // Policy table
  //-----------------------------------------------

  typedef struct packed {
    bit [3:0]     reserved1_f;
    bit [3:0]     spatial_reuse_f;
    bit [1:0]     reserved2_f;
    bit           midamble_f;
    bit           doppler_f;
    bit [2:0]     num_tx_prot_f;
    bit [2:0]     num_tx_f;
    bit [4:0]     reserved3_f;
    bit [1:0]     stbc_f;
    bit           fec_coding_f;
    bit [1:0]     num_extn_ss_f;
    bit           beamforming_f;
    bit           smoothing_prot_f;
    bit           smoothing_f;
    bit           sounding_f;
  } pt_phy_ctrl_info_1_s;

  typedef struct packed {
    bit [3:0]     reserved1_f;
    bit [2:0]     packet_extension_f;
    bit [5:0]     bss_color_f;
    bit           reserved2_f;
    bit           uplink_flag_f;
    bit           beamchange_f;
    bit           beamformed_f;
    bit [7:0]     smm_index_f;
    bit [7:0]     antenna_set_f;
  } pt_phy_ctrl_info_2_s;

  typedef struct packed {
    bit [11:0]    reserved_f;
    bit [9:0]     key_sram_idx_rcv_addr_f;
    bit [9:0]     key_sram_idx_f;
  } pt_mac_ctrl_info_1_s;

  typedef struct packed {
    bit [3:0]     reserved_f;
    bit [11:0]    rts_threshold_f;
    bit [7:0]     short_retry_limit_f;
    bit [7:0]     long_retry_limit_f;
  } pt_mac_ctrl_info_2_s;

  typedef struct packed {
    bit [2:0]     num_retry_rc_f;
    bit [2:0]     format_mode_prot_f;
    bit [1:0]     bw_prot_f;
    bit [6:0]     mcs_idx_prot_f;
    bit [2:0]     nav_prot_frm_f;
    bit [2:0]     format_mode_f;
    bit [1:0]     gi_type_f;
    bit [1:0]     bw_f;
    bit [6:0]     mcs_idx_f;
  } pt_rate_ctrl_s;

  typedef struct packed {
    bit [12:0]    reserved_f;
    bit           dcm_f;
    bit [1:0]     he_ltf_type_f;
    bit [7:0]     tx_pwr_level_prot_f;
    bit [7:0]     tx_pwr_level_f;
  } pt_pwr_ctrl_info_s;

  typedef struct packed {
    bit [5:0]     reserved_f;
    bit [9:0]     key_sram_idx_f;
    bit [7:0]     smm_index_f;
    bit           fec_coding_f;
    bit [6:0]     mcs_idx_f;
  } pt_mumimo_ctrl_info_s;

  typedef enum bit [2:0] {
    NO_PROT     = 3'b000,
    SELF_CTS    = 3'b001,
    RTS_CTS     = 3'b010,
    RTS_CTS_QAP = 3'b011,
    STBC        = 3'b100
  } nav_prot_frm_e;

`endif// DESCRIPTORS_COMMON_SV
