//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef POLICY_TABLE_SV
`define POLICY_TABLE_SV

class policy_table extends uvm_object;

  pt_phy_ctrl_info_1_s    pt_phy_ctrl_info_1;
  pt_phy_ctrl_info_2_s    pt_phy_ctrl_info_2;
  pt_mac_ctrl_info_1_s    pt_mac_ctrl_info_1;
  pt_mac_ctrl_info_2_s    pt_mac_ctrl_info_2;
  pt_rate_ctrl_s          pt_rate_ctrl[4];
  pt_pwr_ctrl_info_s      pt_pwr_ctrl_info[4];

  `uvm_object_utils(policy_table)

  function new (string name = "policy_table");
    super.new(name);
  endfunction

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("pt_phy_ctrl_info_1", $sformatf("%p",pt_phy_ctrl_info_1));
    printer.print_string("pt_phy_ctrl_info_2", $sformatf("%p",pt_phy_ctrl_info_2));
    printer.print_string("pt_mac_ctrl_info_1", $sformatf("%p",pt_mac_ctrl_info_1));
    printer.print_string("pt_mac_ctrl_info_2", $sformatf("%p",pt_mac_ctrl_info_2));
    printer.print_string("pt_rate_ctrl[0]", $sformatf("%p",pt_rate_ctrl[0]));
    printer.print_string("pt_rate_ctrl[1]", $sformatf("%p",pt_rate_ctrl[1]));
    printer.print_string("pt_rate_ctrl[2]", $sformatf("%p",pt_rate_ctrl[2]));
    printer.print_string("pt_rate_ctrl[3]", $sformatf("%p",pt_rate_ctrl[3]));
    printer.print_string("pt_pwr_ctrl_info[0]", $sformatf("%p",pt_pwr_ctrl_info[0]));
    printer.print_string("pt_pwr_ctrl_info[1]", $sformatf("%p",pt_pwr_ctrl_info[1]));
    printer.print_string("pt_pwr_ctrl_info[2]", $sformatf("%p",pt_pwr_ctrl_info[2]));
    printer.print_string("pt_pwr_ctrl_info[3]", $sformatf("%p",pt_pwr_ctrl_info[3]));
  endfunction : do_print

endclass : policy_table

`endif//POLICY_TABLE_SV

