//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef BLANK_DELIMITER_SV
`define BLANK_DELIMITER_SV

class blank_delimiter extends delimiter;

  int          blank_delimiter_num;

  `uvm_object_utils_begin(blank_delimiter)
    `uvm_field_int(blank_delimiter_num, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "blank_delimiter");
    super.new(name);

    mpdu_length = 14'h0; // length of MPDU is set to 0
    crc = delimiter_crc_func({mpdu_length, reserved});
    blank_delimiter_num = 0;
  endfunction

  //------------------------------------------------------------
  // return size of delimiter in bytes
  //------------------------------------------------------------
  virtual function int size();
    return (4 * blank_delimiter_num);
  endfunction : size

endclass : blank_delimiter

`endif //BLANK_DELIMITER_SV
