//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BEAMFORMING_REPORT_POLL_FRAME_SV
`define BEAMFORMING_REPORT_POLL_FRAME_SV

class BEAMFORMING_REPORT_POLL_frame extends control_MPDU_frame;

  rand octet_t    feedback_segment_retransmission_bitmap;

  `uvm_object_utils_begin(BEAMFORMING_REPORT_POLL_frame)
    `uvm_field_int(feedback_segment_retransmission_bitmap, UVM_DEFAULT)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_frame_body_size {
    frame_body.size() == 1;
  }

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `BEAMFORMING_REPORT_POLL;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void custom_post_randomize();
    // Sounding dialog token number field
    frame_body[0] = feedback_segment_retransmission_bitmap;
  endfunction : custom_post_randomize

  function new (string name = "BEAMFORMING_REPORT_POLL_frame");
    super.new(name);
  endfunction

  function void post_monitor();
    super.post_monitor();

    feedback_segment_retransmission_bitmap = frame_body[0];
  endfunction : post_monitor

endclass : BEAMFORMING_REPORT_POLL_frame

`endif// BEAMFORMING_REPORT_POLL_FRAME_SV
