//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BLOCK_ACK_REQ_FRAME_SV
`define BLOCK_ACK_REQ_FRAME_SV

class BLOCK_ACK_REQUEST_frame extends control_MPDU_frame;

  rand bar_control_s        bar_ctrl;
  rand bar_variant_e        bar_variant;
  rand bit [11:0]           starting_seq_num;

  `uvm_object_utils_begin(BLOCK_ACK_REQUEST_frame)
    `uvm_field_int(bar_ctrl, UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_enum(bar_variant_e, bar_variant, UVM_DEFAULT)
    `uvm_field_int(starting_seq_num, UVM_DEFAULT)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `BLOCK_ACK_REQUEST;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }

  constraint c_solve_order {
    solve bar_variant before frame_body;
    solve bar_ctrl before frame_body;
  }

  constraint c_frame_body_size {

    if (bar_variant == BASIC_BAR){
      frame_body.size() == 4;
    } else if (bar_variant inside {EXT_COMPRESSED_BAR,COMPRESSED_BAR}){
      frame_body.size() == 4;
    } else if (bar_variant == MULTI_TID_BAR){
      frame_body.size() == 6;
    } else if (bar_variant == GCR_BAR) {
      frame_body.size() == 10;
    }
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void custom_post_randomize();
    // store BAR control
    bar_ctrl.bar_type_f = bar_variant;
    bar_ctrl.reserved_f = 0;

    // store BAR information in relative to BAR variant
    case (bar_variant)
      BASIC_BAR: begin
        {frame_body[3],frame_body[2]} = {starting_seq_num, 4'b0000};
      end
      COMPRESSED_BAR, EXT_COMPRESSED_BAR: begin
        {frame_body[3],frame_body[2]} = {starting_seq_num, 4'b0000};
      end
      MULTI_TID_BAR: begin
        {frame_body[3],frame_body[2]} = {$urandom_range(0,15),12'h0};
        {frame_body[5],frame_body[4]} = {4'b0000,starting_seq_num};
        bar_ctrl.tid_info_f = 4'h1; // one TID
      end
      GCR_BAR: begin
        bar_ctrl.tid_info_f = 0;
        {frame_body[3],frame_body[2]} = {4'b0000,starting_seq_num};
      end
    endcase

    frame_body[1] = bar_ctrl[15:8];
    frame_body[0] = bar_ctrl[ 7:0];

  endfunction : custom_post_randomize

  function new (string name = "BLOCK_ACK_REQUEST_frame");
    super.new(name);
  endfunction

  function void post_monitor();
    super.post_monitor();

     bar_ctrl[15:8] = frame_body[1];
     bar_ctrl[ 7:0] = frame_body[0];
     bar_variant = bar_variant_e'(bar_ctrl.bar_type_f);

     // store BAR information in relative to BAR variant
    case (bar_variant)
      BASIC_BAR: begin
        starting_seq_num = {frame_body[3],frame_body[2][7:4]};
      end
      COMPRESSED_BAR, EXT_COMPRESSED_BAR: begin
        starting_seq_num = {frame_body[3],frame_body[2][7:4]};
      end
      MULTI_TID_BAR: begin
        starting_seq_num = {frame_body[5][7:4],frame_body[4]};
      end
      GCR_BAR: begin
        starting_seq_num = {frame_body[3][7:4],frame_body[2]};
      end
    endcase
  endfunction : post_monitor

  //------------------------------------------------------------
  // custom print function
  //------------------------------------------------------------
  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("bar_ctrl", $sformatf("%p",bar_ctrl));
  endfunction : do_print

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  virtual function void do_copy(uvm_object rhs);
    BLOCK_ACK_REQUEST_frame rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    bar_ctrl = rhs_.bar_ctrl;
    bar_variant = rhs_.bar_variant;
    starting_seq_num = rhs_.starting_seq_num;
  endfunction : do_copy

endclass : BLOCK_ACK_REQUEST_frame

`endif// BLOCK_ACK_REQ_FRAME_SV
