//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BLOCK_ACK_FRAME_SV
`define BLOCK_ACK_FRAME_SV

class BLOCK_ACK_frame extends control_MPDU_frame;

  rand ba_control_s         ba_ctrl;
  rand ba_variant_e         ba_variant;
  rand bit [11:0]           starting_seq_num;
  rand bit [3:0]            fragment_num;
  rand aid_tid_info_s       aid_tid;
  rand octet_t              ba_starting_seq_ctrl[];
  rand octet_t              bitmap[];
  rand bit [47:0]           RA;

  `uvm_object_utils_begin(BLOCK_ACK_frame)
    `uvm_field_int(ba_ctrl, UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_enum(ba_variant_e, ba_variant, UVM_DEFAULT)
    `uvm_field_int(aid_tid, UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_int(starting_seq_num, UVM_DEFAULT)
    `uvm_field_int(RA, UVM_DEFAULT)
    `uvm_field_int(fragment_num, UVM_DEFAULT)
    `uvm_field_array_int(bitmap, UVM_DEFAULT)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `BLOCK_ACK;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }

  constraint c_solve_order {
    solve ba_variant before frame_body;
    solve ba_ctrl before frame_body;
    solve bitmap before frame_body;
    solve starting_seq_num before frame_body;
    solve aid_tid before frame_body;
  }

  constraint c_tid_frag_num_f {
    // For now it's constrained for BA context
    aid_tid.TID_f inside {[0:7]};
    aid_tid.ack_type_f == 0;
    fragment_num[3] == 0;
  }

  constraint c_frame_body_size {

    if (ba_variant == BASIC_BA){
      frame_body.size() == 132;
      bitmap.size() == 128;
    } else if (ba_variant == COMP_BA){
      frame_body.size() == 12;
      bitmap.size() == 8;
    } else if (ba_variant == MULTI_TID_BA){
      frame_body.size() == 14;
      bitmap.size() == 0;
    } else if (ba_variant == EXT_COMP_BA) {
      frame_body.size() == 13;
      bitmap.size() == 8;
    } else if (ba_variant == GCR_BA) {
      frame_body.size() == 18;
      bitmap.size() == 8;
    } else if (ba_variant == GLK_GCR_BA) {
      frame_body.size() == 12;
      bitmap.size() == 0;
    } else if (ba_variant == MULTI_STA_BA) {
      if (aid_tid.aid11_f == 2045) {
        aid_tid.ack_type_f == 0;
        aid_tid.TID_f == 15;
        frame_body.size() == 14;
        bitmap.size() == 0;
      } else {
        if (aid_tid.TID_f inside {[0:7]}) {
          if (aid_tid.ack_type_f == 0) {
            if (fragment_num[2:1] == 0) {
              frame_body.size() == 14;
              bitmap.size() == 8;
            } else if (fragment_num[2:1] == 1) {
              frame_body.size() == 22;
              bitmap.size() == 16;
            } else if (fragment_num[2:1] == 2) {
              frame_body.size() == 38;
              bitmap.size() == 32;
            } else if (fragment_num[2:1] == 3) {
              frame_body.size() == 10;
              bitmap.size() == 4;
            }
          } else {
            frame_body.size() == 4;
            bitmap.size() == 0;
          }
        } else {
          frame_body.size() == 4;
          bitmap.size() == 0;
        }
      }
    }
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void custom_post_randomize();
    // store BAR control
    ba_ctrl.ba_type_f = ba_variant;
    ba_ctrl.reserved_f = 0;

    // store BAR information in relative to BAR variant
    case (ba_variant)
      BASIC_BA: begin
        {frame_body[3],frame_body[2]} = {starting_seq_num, 4'b0000};
        foreach (bitmap[i]) frame_body[i+4] = bitmap[i];
      end
      COMP_BA: begin
        {frame_body[3],frame_body[2]} = {starting_seq_num, 4'b0000};
        foreach (bitmap[i]) frame_body[i+4] = bitmap[i];
      end
      MULTI_TID_BA: begin
        {frame_body[3],frame_body[2]} = {$urandom_range(0,15),12'h0};
        {frame_body[5],frame_body[4]} = {4'b0000,starting_seq_num};
      end
      EXT_COMP_BA: begin
        {frame_body[3],frame_body[2]} = {starting_seq_num, 4'b0000};
        foreach (bitmap[i]) frame_body[i+4] = bitmap[i];
      end
      GCR_BA: begin
      end
      GLK_GCR_BA: begin
      end
      MULTI_STA_BA: begin
        {frame_body[3],frame_body[2]}   = aid_tid;
        if (aid_tid.aid11_f == 2045) begin          
          {frame_body[7],frame_body[6],
           frame_body[5], frame_body[4]}  = 32'h0; // Reserved 4 bytes
          {frame_body[13],frame_body[12],
           frame_body[11],frame_body[10],
           frame_body[9], frame_body[8]}  = RA;
        end 
        else begin
          if (aid_tid.TID_f inside {[0:7]}) begin
            if (aid_tid.ack_type_f == 0) begin
              {frame_body[5],frame_body[4]} = {starting_seq_num, fragment_num};
              foreach (bitmap[i]) frame_body[i+6] = bitmap[i];
            end
          end
        end
      end
    endcase

    frame_body[1] = ba_ctrl[15:8];
    frame_body[0] = ba_ctrl[ 7:0];

  endfunction : custom_post_randomize

  function void post_monitor();
    super.post_monitor();

     ba_ctrl[15:8] = frame_body[1];
     ba_ctrl[ 7:0] = frame_body[0];
     ba_variant = ba_variant_e'(ba_ctrl.ba_type_f);
     aid_tid = {frame_body[3], frame_body[2]};

    // store BAR information in relative to BAR variant
    case (ba_variant)
      BASIC_BA: begin
        starting_seq_num = {frame_body[3],frame_body[2][7:4]};
        bitmap = new[128];
        foreach (bitmap[i]) bitmap[i] = frame_body[i+4];
      end
      COMP_BA: begin
        starting_seq_num = {frame_body[3],frame_body[2][7:4]};
        bitmap = new[8];
        foreach (bitmap[i]) bitmap[i] = frame_body[i+4];
      end
      MULTI_TID_BA: begin
        starting_seq_num = {frame_body[5][7:4],frame_body[4]};
        if (bitmap.size() != 0) bitmap.delete();
      end
      EXT_COMP_BA: begin
        starting_seq_num = {frame_body[3],frame_body[2][7:4]};
        bitmap = new[8];
        foreach (bitmap[i]) bitmap[i] = frame_body[i+4];
      end
      GCR_BA: begin
        starting_seq_num = {frame_body[3][3:0],frame_body[2]};
        bitmap = new[8];
        foreach (bitmap[i]) bitmap[i] = frame_body[i+10];
      end
      GLK_GCR_BA: begin
      end
      MULTI_STA_BA: begin
        if (aid_tid.aid11_f == 2045) begin
          RA = {frame_body[13], frame_body[12],
                frame_body[11], frame_body[10],
                frame_body[9],  frame_body[8]};
        end
        else begin
          if (aid_tid.TID_f inside {[0:7]}) begin
            starting_seq_num = {frame_body[5],frame_body[4][7:4]};
            fragment_num = frame_body[4][3:0];
            case(fragment_num[2:1])
              0 : bitmap = new[8];
              1 : bitmap = new[16];
              2 : bitmap = new[32];
              3 : bitmap = new[4];
            endcase
            foreach (bitmap[i]) bitmap[i] = frame_body[i+6];
          end
        end
      end
    endcase
  endfunction : post_monitor

  //------------------------------------------------------------
  // custom print function
  //------------------------------------------------------------
  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_string("ba_ctrl", $sformatf("%p",ba_ctrl));
    printer.print_string("aid_tid", $sformatf("%p",aid_tid));
  endfunction : do_print

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  virtual function void do_copy(uvm_object rhs);
    BLOCK_ACK_frame rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    ba_ctrl = rhs_.ba_ctrl;
    ba_variant = rhs_.ba_variant;
    starting_seq_num = rhs_.starting_seq_num;
    bitmap = new[rhs_.bitmap.size()];
    foreach (bitmap[i]) bitmap[i] = rhs_.bitmap[i];
  endfunction : do_copy

  function new (string name = "BLOCK_ACK_frame");
    super.new(name);
  endfunction

endclass : BLOCK_ACK_frame

`endif// BLOCK_ACK_FRAME_SV
