//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef CONTROL_WRAPPER_FRAME_SV
`define CONTROL_WRAPPER_FRAME_SV

class CONTROL_WRAPPER_frame extends control_MPDU_frame;

  rand mpdu_frame_type_e         ctrl_frame_type;
       control_MPDU_frame        carried_frame;

  `uvm_object_utils_begin(CONTROL_WRAPPER_frame)
    `uvm_field_enum(mpdu_frame_type_e, ctrl_frame_type, UVM_DEFAULT | UVM_NOCOMPARE)
    `uvm_field_object(carried_frame, UVM_DEFAULT| UVM_NOCOMPARE)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `CONTROL_WRAPPER;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 1;
  }

  constraint c_ht_ctrl_present {
    MAC_header.ht_ctrl.size() == 1;
  }

  // sequence control header filed is reused to carry
  // information for carried frame control structure
  constraint c_seq_ctrl_present {
    MAC_header.seq_ctrl.size() == 1;
  }

  constraint c_carried_frame_type {
    ctrl_frame_type[5:4] == `CONTROL_MPDU;
`ifdef RW_SUPPORT_AX
    ctrl_frame_type inside {BLOCK_ACK_REQUEST,
                            BLOCK_ACK        ,
                            PS_POLL          ,
                            RTS              ,
                            CTS              ,
                            ACK              ,
                            CF_END           ,
                            CF_END_CF_ACK    };
`else
    ctrl_frame_type inside {BLOCK_ACK_REQUEST,
                            BLOCK_ACK        ,
                            RTS              ,
                            CTS              ,
                            ACK              };
`endif
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void create_carried_frame();
    case (ctrl_frame_type)
      BLOCK_ACK_REQUEST : carried_frame = BLOCK_ACK_REQUEST_frame::type_id::create("carried_frame");
      BLOCK_ACK         : carried_frame = BLOCK_ACK_frame::type_id::create("carried_frame");
      PS_POLL           : carried_frame = PS_POLL_frame::type_id::create("carried_frame");
      RTS               : carried_frame = RTS_frame::type_id::create("carried_frame");
      CTS               : carried_frame = CTS_frame::type_id::create("carried_frame");
      ACK               : carried_frame = ACK_frame::type_id::create("carried_frame");
      CF_END            : carried_frame = CF_END_frame::type_id::create("carried_frame");
      CF_END_CF_ACK     : carried_frame = CF_END_CF_ACK_frame::type_id::create("carried_frame");
    endcase

    // randomize created frame
    assert (carried_frame.randomize());
  endfunction : create_carried_frame

  function void custom_post_randomize();
    create_carried_frame();

    MAC_header.duration_id = carried_frame.MAC_header.duration_id;
    MAC_header.addr[0] = carried_frame.MAC_header.addr[0];
    // overwrite sequence control with carried frame control
    // they are both 16 bits wide
    MAC_header.seq_ctrl[0] = carried_frame.MAC_header.frame_ctrl;

    // frame body should contain fields that follow Address 1 of control frame
    // excluding FCS field, bytes for frame control+duration+address1+FCS are
    // removed (14 bytes)
    frame_body = new[carried_frame.size()-14];
    foreach (frame_body[i]) frame_body[i] = carried_frame.frame[i+10];
  endfunction : custom_post_randomize

  function void post_monitor();
    super.post_monitor();

    // from carried frame control create carried frame
    ctrl_frame_type = mpdu_frame_type_e'({MAC_header.seq_ctrl[0][3:2],
                                          MAC_header.seq_ctrl[0][7:4]});
    create_carried_frame();
    // duration stays the same in carried frame
    carried_frame.MAC_header.duration_id = MAC_header.duration_id;
    // address 1 is same as one in control wrapper
    carried_frame.MAC_header.addr[0] = MAC_header.addr[0];
    // all other bytes of carried frame are inside control wrapper frame body
    if (carried_frame.MAC_header.addr.size() == 2) begin
      carried_frame.MAC_header.addr[1] = {
        frame_body[5],
        frame_body[4],
        frame_body[3],
        frame_body[2],
        frame_body[1],
        frame_body[0]
      };
      // if there are more fields than address 2
      if (frame_body.size() > 6) begin
        carried_frame.frame_body.delete();
        carried_frame.frame_body = new[frame_body.size()-6];
        foreach (carried_frame.frame_body[i])
          carried_frame.frame_body[i] = frame_body[i+6];
      end
     end// address 2

     // recompute FCS of carried frame
     carried_frame.recalculate_fcs();
     carried_frame.post_monitor();
  endfunction : post_monitor

  virtual function void set_MAC_addr(mac_address_t RA = 0, mac_address_t TA = 0,
                                     mac_address_t DA = 0, mac_address_t SA = 0,
                                     mac_address_t BSSID = 0, bit amsdu = 0);

     MAC_header.addr[0] = (RA == 0) ? MAC_header.addr[0] : RA;
     // for conrol frames set addresses
     if (carried_frame.MAC_header.frame_ctrl.type_f == `CONTROL_MPDU) begin
       case (carried_frame.MAC_header.frame_ctrl.subtype_f)
         `CTS,`ACK: begin
           carried_frame.MAC_header.addr[0] = (RA == 0) ? MAC_header.addr[0] : RA;
         end
         default: begin
           carried_frame.MAC_header.addr[0] = (RA == 0) ? MAC_header.addr[0] : RA;
           carried_frame.MAC_header.addr[1] = (TA == 0) ? MAC_header.addr[1] : TA;
         end
       endcase
     end

     // recompute FCS of carried frame
     carried_frame.recalculate_fcs();
     // frame body should contain fields that follow Address 1 of control frame
     // excluding FCS field, bytes for frame control+duration+address1+FCS are
     // removed (14 bytes)
     frame_body = new[carried_frame.size()-14];
     foreach (frame_body[i]) frame_body[i] = carried_frame.frame[i+10];
  endfunction : set_MAC_addr

  virtual function void set_MAC_duration(duration_t dur);
    MAC_header.duration_id = dur;
    carried_frame.MAC_header.duration_id = dur;
    // recompute FCS of carried frame
    carried_frame.recalculate_fcs();
  endfunction : set_MAC_duration

  function new (string name = "CONTROL_WRAPPER_frame");
    super.new(name);
  endfunction

endclass : CONTROL_WRAPPER_frame

`endif// CONTROL_WRAPPER_FRAME_SV
