//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef HE_NDP_ANNOUNCEMENT_FRAME_SV
`define HE_NDP_ANNOUNCEMENT_FRAME_SV

class HE_NDP_ANNOUNCEMENT_frame extends VHT_NDP_ANNOUNCEMENT_frame;

  rand sta_info_he_s   sta_info[];
  rand bit [2:0]       ch_bw;

  `uvm_object_utils_begin(HE_NDP_ANNOUNCEMENT_frame)
    `uvm_field_array_int(sta_info, UVM_DEFAULT | UVM_NOPRINT | UVM_NOCOMPARE)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_solve_order {
    solve sta_info before frame_body;
    solve ch_bw before sta_info;
  }

  // there should be at least 1 station
  constraint c_sta_info_num {
    sta_info.size() inside {[1:4]};
    ch_bw inside {3'b000, 3'b001, 3'b010};// 20/40/80MHz
    // constraint partial BW values
    foreach (sta_info[i]) {
      if (ch_bw == 3'b000) {
        sta_info[i].ru_start_index_f inside {[0:8]}; // RU start index
        sta_info[i].ru_end_index_f   inside {[0:8]}; // RU end index
      } else if (ch_bw == 3'b001) {
        sta_info[i].ru_start_index_f inside {[0:17]}; // RU start index
        sta_info[i].ru_end_index_f   inside {[0:17]}; // RU end index
      } else {
        sta_info[i].ru_start_index_f inside {[0:36]}; // RU start index
        sta_info[i].ru_end_index_f   inside {[0:36]}; // RU end index
      }
      // RU start index must be less or equal to RU end index
      sta_info[i].ru_start_index_f <= sta_info[i].ru_end_index_f;
    }
  }

  constraint c_frame_body_size {
    frame_body.size() == (4*sta_info.size()+1);
  }

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `VHT_NDP_ANNOUNCEMENT;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  virtual function void custom_post_randomize();
    // Sounding dialog token number field
    frame_body[0] = {sounding_dialog_token_num, 1'b1, 1'b0}; // 1bit - HE, 0bit - reserved
    // store STA infos
    for (int i=0;i<sta_info.size();i++) begin
      {frame_body[4*i+4],frame_body[4*i+3],frame_body[4*i+2],frame_body[4*i+1]} = sta_info[i];
    end
  endfunction : custom_post_randomize

  function new (string name = "HE_NDP_ANNOUNCEMENT_frame");
    super.new(name);
  endfunction

  virtual function void post_monitor();
    int sta_size;

    super.post_monitor();

    // Sounding dialog token number field
    sounding_dialog_token_num = frame_body[0][7:2];

    // store STA infos
    sta_size = (frame_body.size()-1)/4;
    sta_info = new[sta_size];
    for (int i=0;i<sta_size;i++) begin
      sta_info[i] = {frame_body[4*i+4],frame_body[4*i+3],frame_body[4*i+2],frame_body[4*i+1]};
    end
  endfunction : post_monitor

  function void do_print(uvm_printer printer);
    foreach (sta_info[i])
      printer.print_string("station info", $sformatf("%p",sta_info[i]));
  endfunction : do_print

endclass : HE_NDP_ANNOUNCEMENT_frame

`endif// HE_NDP_ANNOUNCEMENT_FRAME_SV
