//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PS_POLL_FRAME_SV
`define PS_POLL_FRAME_SV

class PS_POLL_frame extends control_MPDU_frame;

  `uvm_object_utils(PS_POLL_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `PS_POLL;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }

  constraint c_duration_id {
    // AID
    MAC_header.duration_id[15:14] == 2'b11;
    MAC_header.duration_id[13:0] inside {[1:2007]};
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function new (string name = "PS_POLL_frame");
    super.new(name);
  endfunction

endclass : PS_POLL_frame

`endif// PS_POLL_FRAME_SV
