//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef VHT_NDP_ANNOUNCEMENT_FRAME_SV
`define VHT_NDP_ANNOUNCEMENT_FRAME_SV

class VHT_NDP_ANNOUNCEMENT_frame extends control_MPDU_frame;

  rand bit [5:0]    sounding_dialog_token_num;
  rand sta_info_s   sta_info[];

  `uvm_object_utils_begin(VHT_NDP_ANNOUNCEMENT_frame)
    `uvm_field_int      (sounding_dialog_token_num, UVM_DEFAULT)
    `uvm_field_array_int(sta_info, UVM_DEFAULT | UVM_NOPRINT | UVM_NOCOMPARE)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_solve_order {
    solve sta_info before frame_body;
  }

  // there should be at least 1 station
  constraint c_sta_info_num {
    sta_info.size() > 0;
    sta_info.size() < 5;
  }

  constraint c_frame_body_size {
    frame_body.size() == (2*sta_info.size()+1);
  }

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f == `VHT_NDP_ANNOUNCEMENT;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 2;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  virtual function void custom_post_randomize();
    // Sounding dialog token number field
    frame_body[0] = {sounding_dialog_token_num, 2'b00}; // bits 0 and 1 are reserved
    // store STA infos
    for (int i=0;i<sta_info.size();i++) begin
      {frame_body[2*i+2],frame_body[2*i+1]} = sta_info[i];
    end
  endfunction : custom_post_randomize

  function new (string name = "VHT_NDP_ANNOUNCEMENT_frame");
    super.new(name);
  endfunction

  virtual function void post_monitor();
    int sta_size;

    super.post_monitor();

    // Sounding dialog token number field
    sounding_dialog_token_num = frame_body[0][7:2];

    // store STA infos
    sta_size = (frame_body.size()-1)/2;
    sta_info = new[sta_size];
    for (int i=0;i<sta_size;i++) begin
      sta_info[i] = {frame_body[2*i+2],frame_body[2*i+1]};
    end
  endfunction : post_monitor

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    foreach (sta_info[i])
      printer.print_string("station info", $sformatf("%p",sta_info[i]));
  endfunction : do_print

endclass : VHT_NDP_ANNOUNCEMENT_frame

`endif// VHT_NDP_ANNOUNCEMENT_FRAME_SV
