//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef CONTROL_MPDU_FRAME_SV
`define CONTROL_MPDU_FRAME_SV

class control_MPDU_frame extends MPDU_frame;

  `uvm_object_utils(control_MPDU_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_frame_body_size {
    frame_body.size() == 0;
  }

  constraint c_MAC_header_frame_ctrl {
    MAC_header.frame_ctrl.type_f              == `CONTROL_MPDU;
    MAC_header.frame_ctrl.to_DS_f             == 1'b0;
    MAC_header.frame_ctrl.from_DS_f           == 1'b0;
    MAC_header.frame_ctrl.more_fragments_f    == 1'b0;
    MAC_header.frame_ctrl.retry_f             == 1'b0;
    MAC_header.frame_ctrl.more_data_f         == 1'b0;
    MAC_header.frame_ctrl.protected_frame_f   == 1'b0;
    MAC_header.frame_ctrl.order_f             == 1'b0;
  }

  constraint c_qos_ctrl_present {
    MAC_header.qos_ctrl.size() == 0;
  }

  constraint c_ht_ctrl_present {
    MAC_header.ht_ctrl.size() == 0;
  }

  constraint c_seq_ctrl_present {
    MAC_header.seq_ctrl.size() == 0;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function new (string name = "control_MPDU_frame");
    super.new(name);
  endfunction

endclass : control_MPDU_frame

`endif// CONTROL_MPDU_FRAME_SV
