//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef QOS_NULL_FRAME_SV
`define QOS_NULL_FRAME_SV

class QOS_NULL_frame extends data_MPDU_frame;

  `uvm_object_utils(QOS_NULL_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f         == `QOS_NULL;
  }

  constraint c_qos_ctrl_present {
    MAC_header.qos_ctrl.size() == 1;
    if (MAC_header.addr[0][0] == 1'b0) {
      MAC_header.qos_ctrl[0].ack_policy_f == 2'b00; // individual address
    } else {
      MAC_header.qos_ctrl[0].ack_policy_f == 2'b01; // group address
    }
  }

  constraint c_frame_body_size {
    frame_body.size() == 0;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void custom_post_randomize();

  endfunction : custom_post_randomize

  function new (string name = "QOS_NULL_frame");
    super.new(name);
  endfunction

endclass : QOS_NULL_frame

`endif// QOS_NULL_FRAME_SV

