//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef DATA_MPDU_FRAME_SV
`define DATA_MPDU_FRAME_SV

class data_MPDU_frame extends MPDU_frame;

  `uvm_object_utils(data_MPDU_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_solve_order {
    solve MAC_header.frame_ctrl before MAC_header.addr;
    solve MAC_header.frame_ctrl before MAC_header.ht_ctrl;
    solve frame_body before MAC_header.frame_ctrl;
  }

  constraint c_frame_body_size {
    soft frame_body.size() > 0;
    soft frame_body.size() <= `MAX_MPDU_SIZE-`MAX_MAC_HEADER_SIZE;
  }

  constraint c_MAC_address {
    if ({MAC_header.frame_ctrl.to_DS_f,MAC_header.frame_ctrl.from_DS_f} == 2'b11){
      MAC_header.addr.size() == 4;
    } else {
      MAC_header.addr.size() == 3;
    }
  }

  constraint c_MAC_header_frame_ctrl {
    MAC_header.frame_ctrl.type_f              == `DATA_MPDU;
    MAC_header.frame_ctrl.more_fragments_f    == 1'b0;
    MAC_header.frame_ctrl.retry_f             == 1'b0;
    MAC_header.frame_ctrl.more_data_f         == 1'b0;
    if (frame_body.size() == 0) {
      MAC_header.frame_ctrl.protected_frame_f == 1'b0;
    } else {
      MAC_header.frame_ctrl.protected_frame_f dist {1'b0:=20, 1'b1:=80};
    }
  }

  constraint c_qos_ctrl_present {
    MAC_header.qos_ctrl.size() == 0;
  }

  constraint c_ht_ctrl_present {
    if (MAC_header.frame_ctrl.order_f == 1'b1){
      MAC_header.ht_ctrl.size() == 1;
    } else {
      MAC_header.ht_ctrl.size() == 0;
    }
  }

  constraint c_seq_ctrl_present {
    MAC_header.seq_ctrl.size() == 1;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function new (string name = "data_MPDU_frame");
    super.new(name);
  endfunction

endclass : data_MPDU_frame

`endif// DATA_MPDU_FRAME_SV
