//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef DELIMITER_SV
`define DELIMITER_SV

class delimiter extends uvm_object;

  bit [7:0]       signature = 8'h4E; // unique pattern
  bit [7:0]       crc;               // CRC of preceding 16 bits
  bit [13:0]      mpdu_length;       // length of MPDU in octets
  bit             reserved  = 1'b0;
  bit             eof;               // end of frame indication in VHT

  `uvm_object_utils_begin(delimiter)
    `uvm_field_int(signature, UVM_DEFAULT | UVM_NOCOPY)
    `uvm_field_int(crc,  UVM_DEFAULT | UVM_NOCOPY)
    `uvm_field_int(mpdu_length,  UVM_DEFAULT | UVM_NOCOPY)
    `uvm_field_int(reserved,  UVM_DEFAULT | UVM_NOCOPY)
    `uvm_field_int(eof,  UVM_DEFAULT | UVM_NOCOPY)
  `uvm_object_utils_end

  function new (string name = "delimiter");
    super.new(name);
  endfunction

  //------------------------------------------------------------
  // return delimiter bit stream
  //------------------------------------------------------------
  virtual function bit [31:0] get_data();
    return ({signature,crc,mpdu_length[11:0],mpdu_length[13:12],reserved, eof});
  endfunction : get_data

  //------------------------------------------------------------
  // set delimiter fields in relative to 32bit data
  //------------------------------------------------------------
  virtual function void set_data(bit [31:0] data);
    signature   = data[31:24];
    crc         = data[23:16];
    mpdu_length[11:0]  = data[15:4];
    mpdu_length[13:12] = data[3:2];
    reserved    = data[1];
    eof         = data[0];
  endfunction : set_data

  //------------------------------------------------------------
  // return size of delimiter in bytes
  //------------------------------------------------------------
  virtual function int size();
    return 4;
  endfunction : size

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  function void do_copy(uvm_object rhs);
    delimiter rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    crc = rhs_.crc;
    mpdu_length = rhs_.mpdu_length;
    eof = rhs_.eof;
  endfunction : do_copy

endclass : delimiter

`endif //DELIMITER_SV
