//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef ERROR_MPDU_FRAME_SV
`define ERROR_MPDU_FRAME_SV

class error_MPDU_frame extends data_MPDU_frame;

  `uvm_object_utils(error_MPDU_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_create_with_payload {
    // DATA* and QOS_DATA*
    soft MAC_header.frame_ctrl.subtype_f[2] == 0;
    soft MAC_header.frame_ctrl.protected_frame_f == 0;
  }

  function new (string name = "error_MPDU_frame");
    super.new(name);
  endfunction

  function void post_randomize();
    super.post_randomize();

    // change FCS to a wrong value
    FCS = $urandom();
    fcs_error = 1;
    // put FCS data to frame array, extend frame size by 4 bytes
    // for FCS and append rest of frame bytes to it
    frame[frame_size-4] = FCS[ 7: 0];
    frame[frame_size-3] = FCS[15: 8];
    frame[frame_size-2] = FCS[23:16];
    frame[frame_size-1] = FCS[31:24];
  endfunction : post_randomize

  function void post_monitor();
    fcs_error = 1;
    frame_size = frame.size();
    FCS[ 7: 0] = frame[frame_size-4];
    FCS[15: 8] = frame[frame_size-3];
    FCS[23:16] = frame[frame_size-2];
    FCS[31:24] = frame[frame_size-1];
  endfunction : post_monitor

  //------------------------------------------------------------
  // encrypt frame
  //------------------------------------------------------------
  virtual function void encrypt(bit ra);
    super.encrypt(ra);

    if (MAC_header.frame_ctrl.protected_frame_f) begin
      // change FCS to a wrong value
      eFCS = $urandom();
      // put FCS data to frame array, extend frame size by 4 bytes
      // for FCS and append rest of frame bytes to it
      frame[frame_size-4] = eFCS[ 7: 0];
      frame[frame_size-3] = eFCS[15: 8];
      frame[frame_size-2] = eFCS[23:16];
      frame[frame_size-1] = eFCS[31:24];
    end
    else begin
      // change FCS to a wrong value
      FCS = $urandom();
      fcs_error = 1;
      // put FCS data to frame array, extend frame size by 4 bytes
      // for FCS and append rest of frame bytes to it
      frame[frame_size-4] = FCS[ 7: 0];
      frame[frame_size-3] = FCS[15: 8];
      frame[frame_size-2] = FCS[23:16];
      frame[frame_size-1] = FCS[31:24];
    end
  endfunction : encrypt

  virtual function void setup_rx_encrypted_data();
    super.setup_rx_encrypted_data();

    if (MAC_header.frame_ctrl.protected_frame_f) begin
      // change FCS to a wrong value
      eFCS = $urandom();
      // put FCS data to frame array, extend frame size by 4 bytes
      // for FCS and append rest of frame bytes to it
      frame[frame_size-4] = eFCS[ 7: 0];
      frame[frame_size-3] = eFCS[15: 8];
      frame[frame_size-2] = eFCS[23:16];
      frame[frame_size-1] = eFCS[31:24];
    end
    else begin
      // change FCS to a wrong value
      FCS = $urandom();
      fcs_error = 1;
      // put FCS data to frame array, extend frame size by 4 bytes
      // for FCS and append rest of frame bytes to it
      frame[frame_size-4] = FCS[ 7: 0];
      frame[frame_size-3] = FCS[15: 8];
      frame[frame_size-2] = FCS[23:16];
      frame[frame_size-1] = FCS[31:24];
    end
  endfunction : setup_rx_encrypted_data

  //------------------------------------------------------------
  // custom print function
  //------------------------------------------------------------
  function void do_print(uvm_printer printer);
    super.do_print(printer);

    printer.print_int("fcs_error", fcs_error, $bits(fcs_error), UVM_DEC);
  endfunction : do_print

endclass : error_MPDU_frame

`endif//ERROR_MPDU_FRAME_SV
