//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef FRAME_MODEL_COMMON_SV
`define FRAME_MODEL_COMMON_SV

//***********************************************
// DEFINES
//***********************************************
 // frame defines
  `define MAX_USER_NUM               4

`ifndef MAX_NUM_MPDU_FRAMES
  `define MAX_NUM_MPDU_FRAMES       15
`endif//MAX_NUM_MPDU_FRAMES
  `define MAX_MPDU_SIZE_DSSS      2047

`ifndef STANDALONE_MAC

  `ifndef MAX_MPDU_SIZE
    `define MAX_MPDU_SIZE           2047
  `endif// MAX_MPDU_SIZE
  `ifndef MAX_AMPDU_PAYLOAD_SIZE
    `define MAX_AMPDU_PAYLOAD_SIZE  10000
  `endif// MAX_AMPDU_PAYLOAD_SIZE

`else//MAC STANDALONE

  `ifndef MAX_MPDU_SIZE
    `define MAX_MPDU_SIZE           4095
  `endif// MAX_MPDU_SIZE
  `ifndef MAX_AMPDU_PAYLOAD_SIZE
    `define MAX_AMPDU_PAYLOAD_SIZE  200000
  `endif// MAX_AMPDU_PAYLOAD_SIZE

`endif

  // including FCS 4 bytes
  `define MAX_MAC_HEADER_SIZE       40
  `define MAX_MAC_HEADER_SIZE_DSSS  36

  // determine how many address can be before sequence control
  `define MAC_ADDR_SIZE(size) ((size == 4)?3:size)

  // FRAME TYPES
  `define MANAGEMENT_MPDU         2'b00
  `define CONTROL_MPDU            2'b01
  `define DATA_MPDU               2'b10
  `define MISC_MPDU               2'b11
  // ---------------------
  // MANAGEMENT SUBTYPES
  // ---------------------
  `define ASSOCIATION_REQUEST     4'b0000
  `define ASSOCIATION_RESPONSE    4'b0001
  `define REASSOCIATION_REQUEST   4'b0010
  `define REASSOCIATION_RESPONSE  4'b0011
  `define PROBE_REQUEST           4'b0100
  `define PROBE_RESPONSE          4'b0101
  `define TIMING_ADVERTISEMENT    4'b0110
  `define BEACON                  4'b1000
  `define ATIM                    4'b1001
  `define DISASSOCIATION          4'b1010
  `define AUTHENTICATION          4'b1011
  `define DEAUTHENTICATION        4'b1100
  `define ACTION                  4'b1101
  `define ACTION_NOACK            4'b1110
  // ---------------------
  // CONTROL SUBTYPES
  // ---------------------
  `define TRIGGER                 4'b0010
  `define BEAMFORMING_REPORT_POLL 4'b0100
  `define VHT_NDP_ANNOUNCEMENT    4'b0101
  `define CONTROL_WRAPPER         4'b0111
  `define BLOCK_ACK_REQUEST       4'b1000
  `define BLOCK_ACK               4'b1001
  `define PS_POLL                 4'b1010
  `define RTS                     4'b1011
  `define CTS                     4'b1100
  `define ACK                     4'b1101
  `define CF_END                  4'b1110
  `define CF_END_CF_ACK           4'b1111
  // ---------------------
  // DATA SUBTYPES
  // ---------------------
  `define DATA                    4'b0000
  `define DATA_CF_ACK             4'b0001
  `define DATA_CF_POLL            4'b0010
  `define DATA_CF_ACK_CF_POLL     4'b0011
  `define NULL                    4'b0100
  `define CF_ACK                  4'b0101
  `define CF_POLL                 4'b0110
  `define CF_ACK_CF_POLL          4'b0111
  `define QOS_DATA                4'b1000
  `define QOS_DATA_CF_ACK         4'b1001
  `define QOS_DATA_CF_POLL        4'b1010
  `define QOS_DATA_CF_ACK_CF_POLL 4'b1011
  `define QOS_NULL                4'b1100
  `define QOS_CF_POLL             4'b1110
  `define QOS_CF_ACK_CF_POLL      4'b1111
  // ---------------------
  // USER DEFINED SUBTYPES
  // ---------------------
  `define BFR_FRAME               4'b0000
  `define ERROR_FRAME             4'b1111

  `define DELIMITER_CRC_LENGTH    16

  // HE Preamble durations in us
  `define HE_SU_PRE_DUR           16
  `define HE_MU_PRE_DUR           16
  `define HE_ER_SU_PRE_DUR        24
  `define HE_TB_PRE_DUR           20

//***********************************************
// TYPEDEFs
//***********************************************
  //---------------------------------------------
  // define queue of strings
  //---------------------------------------------
  typedef string string_queue_t[$];

  //---------------------------------------------
  // define octet for frame fields
  //---------------------------------------------
  typedef bit [7:0]  octet_t;

  //---------------------------------------------
  // define duration filed - 2 octets
  //---------------------------------------------
  typedef bit [15:0] duration_t;

  //---------------------------------------------
  // FCS - frame check sum is 4 bytes long (4 octets)
  //---------------------------------------------
  typedef bit [31:0] FCS_t;

  //---------------------------------------------
  // MAC frame control field type
  // NOTE: _f stands for field
  //---------------------------------------------
  typedef struct packed {
    bit              order_f;
    bit              protected_frame_f;
    bit              more_data_f;
    bit              power_management_f;
    bit              retry_f;
    bit              more_fragments_f;
    bit              from_DS_f;
    bit              to_DS_f;
    bit [3:0]        subtype_f;
    bit [1:0]        type_f;
    bit [1:0]        protocol_version_f;
  } frame_control_s;

  //---------------------------------------------
  // Sequence control filed type
  //---------------------------------------------
  typedef struct packed {
    bit [11:0]       sequence_number_f;
    bit [3:0]        fragment_number_f;
  } sequence_control_s;

  //---------------------------------------------
  // QoS control field type
  //---------------------------------------------
  typedef struct packed {
    bit [7:0]       qos_control_f;
    bit             amsdu_present_f;
    bit [1:0]       ack_policy_f;
    bit             eosp_f;
    bit [3:0]       tid_f;
  } qos_control_s;

  //---------------------------------------------
  // HT control field type
  //---------------------------------------------
  typedef struct packed {
    bit              rdg_more_ppdu_f;
    bit              ac_constraint_f;
    bit [3:0]        reserved2_f;
    bit              ndp_announcement_f;
    bit [1:0]        csi_steering_f;
    bit [1:0]        reserved1_f;
    bit [1:0]        calibration_sequence_f;
    bit [1:0]        calibration_position_f;
    bit [15:0]       link_adaptation_ctrl_f;
    bit              vht_f;
  } ht_control_s;

  typedef struct packed {
    bit              rdg_more_ppdu_f;
    bit              ac_constraint_f;
    bit              unsolicited_mfb_f;
    bit              fb_tx_type_f;
    bit              coding_type_f;
    bit [2:0]        gid_h_f;
    bit [14:0]       mfb_f;
    bit [2:0]        mfsi_gid_l_f;
    bit [2:0]        msi_stbc_f;
    bit              mrq_f;
    bit              he_f;
    bit              vht_f;
  } vht_control_s;

  typedef struct packed {
    bit              reserved_f;
    bit [1:0]        ul_mcs_f;
    bit [4:0]        ul_target_rssi_f;
    bit [4:0]        dl_tx_power_f;
    bit [7:0]        ru_allocation_f;
    bit [4:0]        ul_data_symbols_f;
  } trs_control_s;

  typedef struct packed {
    trs_control_s    ctrl_info_f;
    bit [3:0]        ctrl_id_f;
    bit              he_f;
    bit              vht_f;
  } he_control_s;

  // link adaptation control subfield bits allocation
  `define            TRQ     0
  `define            MAI     4:1
  `define            MFSI    7:5
  `define            ASELC   14:8

  //---------------------------------------------
  // MAC address type
  //---------------------------------------------
  typedef bit [47:0] mac_address_t;

  //---------------------------------------------
  // BAR (Block Acknowledge Request) control type
  //---------------------------------------------
  typedef struct packed {
    bit [3:0]        tid_info_f;
    bit [6:0]        reserved_f;
    bit [3:0]        bar_type_f;
    bit              bar_ack_policy_f;
  } bar_control_s;

  //---------------------------------------------
  // BAR (Block Acknowledge) control type
  //---------------------------------------------
  typedef struct packed {
    bit [3:0]        tid_info_f;
    bit [6:0]        reserved_f;
    bit [3:0]        ba_type_f;
    bit              ba_ack_policy_f;
  } ba_control_s;

  //---------------------------------------------
  // Block Ack Request variants
  //---------------------------------------------
  typedef enum bit [3:0] {
    BASIC_BAR          = 4'd0,
    EXT_COMPRESSED_BAR = 4'd1,
    COMPRESSED_BAR     = 4'd2,
    MULTI_TID_BAR      = 4'd3,
    GCR_BAR            = 4'd6
    //GLK_GCR_BAR        = 4'd10
  } bar_variant_e;

  //---------------------------------------------
  // Block Ack variants
  //---------------------------------------------
  typedef enum bit [3:0] {
    BASIC_BA     = 4'd0,
    EXT_COMP_BA  = 4'd1,
    COMP_BA      = 4'd2,
    MULTI_TID_BA = 4'd3,
    GCR_BA       = 4'd6,
    GLK_GCR_BA   = 4'd10,
    MULTI_STA_BA = 4'd11
  } ba_variant_e;

  //---------------------------------------------
  // timestamp field
  //---------------------------------------------
  typedef bit [63:0] timestamp_t;

  //---------------------------------------------
  // MPDU frame kind
  //---------------------------------------------
  typedef enum bit [1:0] {
    MANAGEMENT_MPDU      = 2'b00,
    CONTROL_MPDU         = 2'b01,
    DATA_MPDU            = 2'b10
  } mpdu_frame_kind_e;

  //---------------------------------------------
  // MPDU frame type
  //---------------------------------------------
  typedef enum bit [5:0] {
    // ---------------------
    // MANAGEMENT SUBTYPES
    // ---------------------
    ASSOCIATION_REQUEST     = {`MANAGEMENT_MPDU , 4'b0000},
    ASSOCIATION_RESPONSE    = {`MANAGEMENT_MPDU , 4'b0001},
    REASSOCIATION_REQUEST   = {`MANAGEMENT_MPDU , 4'b0010},
    REASSOCIATION_RESPONSE  = {`MANAGEMENT_MPDU , 4'b0011},
    PROBE_REQUEST           = {`MANAGEMENT_MPDU , 4'b0100},
    PROBE_RESPONSE          = {`MANAGEMENT_MPDU , 4'b0101},
    TIMING_ADVERTISEMENT    = {`MANAGEMENT_MPDU , 4'b0110},
    BEACON                  = {`MANAGEMENT_MPDU , 4'b1000},
    ATIM                    = {`MANAGEMENT_MPDU , 4'b1001},
    DISASSOCIATION          = {`MANAGEMENT_MPDU , 4'b1010},
    AUTHENTICATION          = {`MANAGEMENT_MPDU , 4'b1011},
    DEAUTHENTICATION        = {`MANAGEMENT_MPDU , 4'b1100},
    ACTION                  = {`MANAGEMENT_MPDU , 4'b1101},
    ACTION_NOACK            = {`MANAGEMENT_MPDU , 4'b1110},
    // --------------------
    // CONTROL SUBTYPES
    // --------------------
    TRIGGER                 = {`CONTROL_MPDU    , 4'b0010},
    BEAMFORMING_REPORT_POLL = {`CONTROL_MPDU    , 4'b0100},
    VHT_NDP_ANNOUNCEMENT    = {`CONTROL_MPDU    , 4'b0101},
    CONTROL_WRAPPER         = {`CONTROL_MPDU    , 4'b0111},
    BLOCK_ACK_REQUEST       = {`CONTROL_MPDU    , 4'b1000},
    BLOCK_ACK               = {`CONTROL_MPDU    , 4'b1001},
    PS_POLL                 = {`CONTROL_MPDU    , 4'b1010},
    RTS                     = {`CONTROL_MPDU    , 4'b1011},
    CTS                     = {`CONTROL_MPDU    , 4'b1100},
    ACK                     = {`CONTROL_MPDU    , 4'b1101},
    CF_END                  = {`CONTROL_MPDU    , 4'b1110},
    CF_END_CF_ACK           = {`CONTROL_MPDU    , 4'b1111},
    // --------------------
    // DATA SUBTYPES
    // --------------------
    DATA                    = {`DATA_MPDU       , 4'b0000},
    DATA_CF_ACK             = {`DATA_MPDU       , 4'b0001},
    DATA_CF_POLL            = {`DATA_MPDU       , 4'b0010},
    DATA_CF_ACK_CF_POLL     = {`DATA_MPDU       , 4'b0011},
    NULL                    = {`DATA_MPDU       , 4'b0100},
    CF_ACK                  = {`DATA_MPDU       , 4'b0101},
    CF_POLL                 = {`DATA_MPDU       , 4'b0110},
    CF_ACK_CF_POLL          = {`DATA_MPDU       , 4'b0111},
    QOS_DATA                = {`DATA_MPDU       , 4'b1000},
    QOS_DATA_CF_ACK         = {`DATA_MPDU       , 4'b1001},
    QOS_DATA_CF_POLL        = {`DATA_MPDU       , 4'b1010},
    QOS_DATA_CF_ACK_CF_POLL = {`DATA_MPDU       , 4'b1011},
    QOS_NULL                = {`DATA_MPDU       , 4'b1100},
    QOS_CF_POLL             = {`DATA_MPDU       , 4'b1110},
    QOS_CF_ACK_CF_POLL      = {`DATA_MPDU       , 4'b1111},
    // ---------------------
    // USER DEFINED SUBTYPES
    // ---------------------
    BEAMFORMING_REPORT      = {`MISC_MPDU       ,`BFR_FRAME},
    ERROR_FRAME             = {`MISC_MPDU       ,`ERROR_FRAME},
    HE_NDP_ANNOUNCEMENT     = {`MISC_MPDU       ,`VHT_NDP_ANNOUNCEMENT}
  } mpdu_frame_type_e;

  //---------------------------------------------
  // PPDU frame kind
  //---------------------------------------------
  typedef enum {
    SINGLETON  = 0,
    AGGREGATED = 1,
    MU_MIMO    = 2,
    NDP        = 3 /* Null Data Packet */
  } ppdu_frame_kind_e;

  //---------------------------------------------
  // padding type for A-MPDU frames
  //---------------------------------------------
  const octet_t    padding_c = 8'h00; // padding value is constant

  //---------------------------------------------
  // PPDU frame types
  //---------------------------------------------

  // format and modulation of PPDU
  typedef enum bit [3:0] {
    NON_HT          = 4'b0000,
    NON_HT_DUP_OFDM = 4'b0001, // 40MHz and 80MHz
    HT_MF           = 4'b0010,
    HT_GF           = 4'b0011,
    VHT             = 4'b0100,
    HE_SU           = 4'b0101,
    HE_MU           = 4'b0110,
    HE_EXT_SU       = 4'b0111,
    HE_TB           = 4'b1000
  } format_mod_e;

  //----------------------------------------------------------
  // user header in PPDU frame, structure with common fields
  // when MU MIMO is transmitted so we have up to 4 different
  // user specific configuration
  //----------------------------------------------------------
  typedef struct packed {
    bit             fec_coding_f;      /* Forward error corection */
    bit [6:0]       mcs_f;             /* Modulation and coding scheme */
    bit [19:0]      ht_length_f;       /* HT length of frame */
    bit [1:0]       user_position_f;   /* Postion of user in MU-MIMO and beamforming */
    bit [2:0]       num_sts_f;         /* Space time streams */
    bit [7:0]       smm_index_f;       /* Spetial Map Matrix (SMM) */
  } user_header_s;

  //---------------------------------------------
  // Common header part for all HE frames
  //---------------------------------------------
  typedef struct packed {
    bit             fec_coding_f;      /* Forward error corection */
    bit [3:0]       mcs_f;             /* Modulation and coding scheme */
    bit [19:0]      he_length_f;       /* HE length of frame */
    bit [3:0]       user_position_f;   /* Postion of user in MU-MIMO and beamforming */
    bit [2:0]       nss_f;             /* Number of Spatial streams */
    bit [7:0]       smm_index_f;       /* Spetial Map Matrix (SMM) */
    bit [2:0]       pkt_ext_f;         /* Packet Extension */
    bit [10:0]      staid_f;           /* STA ID*/
    bit [3:0]       dut_location_f;    /* Used only for RU mapping*/
  } user_header_he_s;

  //---------------------------------------------
  // 802.11a/b/g/n/ac mode
  //---------------------------------------------
  typedef enum bit [2:0] {
    MODE_802_11B         = 3'b000,
    MODE_802_11A         = 3'b001,
    MODE_802_11G         = 3'b010,
    MODE_802_11N_2_4GHZ  = 3'b011,
    MODE_802_11N_5GHZ    = 3'b100,
    MODE_802_11AC        = 3'b110,
    MODE_802_11AX        = 3'b101
  } abgn_mode_e;

  //---------------------------------------------
  // MAC-PHY interface transaction types
  //---------------------------------------------
  typedef enum {
    TX,
    RX,
    RX_RIFS
  } transaction_e;

  //---------------------------------------------
  // Access categories
  //---------------------------------------------
  typedef enum bit [2:0] {
    AC_BK       = 3'd0,
    AC_BE       = 3'd1,
    AC_VI       = 3'd2,
    AC_VO       = 3'd3,
    AC_BEACON   = 3'd4,
    AC_TB       = 3'd5
  } access_category_e;

  //--------------------------------------------
  // Trigger Type of the Trigger frame
  //--------------------------------------------
  typedef enum bit [3:0] {
    BASIC_TRIGGER               = 4'd0,
    BMF_REPORT_POLL             = 4'd1,
    MU_BAR                      = 4'd2,
    MU_RTS                      = 4'd3,
    BUFFER_STATUS_REPORT_POLL   = 4'd4,
    GCR_MU_BAR                  = 4'd5,
    BANDWIDTH_QUERY_REPORT_POLL = 4'd6,
    NDP_FEEDBACK_REPORT_POLL    = 4'd7
  } trigger_type_e;

  //---------------------------------------------
  // AID TID info in the Multi-STA BA
  //---------------------------------------------
  typedef struct packed {
    bit [11:0]    aid11_f;
    bit           ack_type_f;
    bit [3:0]     TID_f;
  } aid_tid_info_s;

  //---------------------------------------------
  // STA info field type for
  // VHT NDP Announcement frame
  //---------------------------------------------
  typedef struct packed {
    bit [2:0]        nc_index_f;
    bit              feedback_type_f;
    bit [11:0]       aid12_f;
  } sta_info_s;

  //---------------------------------------------
  // STA info field type for
  // HE NDP Announcement frame
  //---------------------------------------------
  typedef struct packed {
    bit [2:0]       nc_index_f;
    bit             codebook_size_f;
    bit             disambiguation_f;
    bit [1:0]       feedback_type_ng_f;
    bit [6:0]       ru_end_index_f;  //Partial BW info
    bit [6:0]       ru_start_index_f;//Partial BW info
    bit [10:0]      aid11_f;
  } sta_info_he_s;

  //---------------------------------------------
  // VHT MIMO control filed used in beamforming report
  //---------------------------------------------
  typedef struct packed {
    bit [5:0]   sounding_dialog_token_num_f;
    bit [1:0]   reserved_f;
    bit         first_feedback_sgmt_f;
    bit [2:0]   rem_feedback_sgmt_f;
    bit         feedback_type_f;
    bit         codebook_info_f;
    bit [1:0]   grouping_f;
    bit [1:0]   channel_width_f;
    bit [2:0]   nr_index_f;
    bit [2:0]   nc_index_f;
  } vht_mimo_ctrl_s;

  //---------------------------------------------
  // HE MIMO control filed used in beamforming report
  //---------------------------------------------
  typedef struct packed {
    bit [7:0]   reserved2_f;
    bit [7:0]   disallow_subch_bitmap_f;
    bit [2:0]   reserved1_f;
    bit         disallow_subch_bitmap_present_f;
    bit [5:0]   sounding_dialog_token_num_f;
    bit [6:0]   ru_end_index_f;
    bit [6:0]   ru_start_index_f;
    bit         first_feedback_sgmt_f;
    bit [2:0]   rem_feedback_sgmt_f;
    bit [1:0]   feedback_type_f;
    bit         codebook_info_f;
    bit         grouping_f;
    bit [1:0]   channel_width_f;
    bit [2:0]   nr_index_f;
    bit [2:0]   nc_index_f;
  } he_mimo_ctrl_s;

  //--------------------------------------------
  // Common Info subfield of the Trigger frame
  //--------------------------------------------
  typedef struct packed {
    bit             reserved_f;
    bit [8:0]       he_sig_a_reserved_f;
    bit             doppler_f;
    bit [15:0]      spatial_reuse_f;
    bit             pe_disambiguity_f;
    bit [1:0]       pre_fec_padding_f;
    bit [5:0]       ap_tx_power_f;
    bit             ldpc_extra_symbol_segment_f;
    bit             stbc_f;
    bit [2:0]       num_of_he_ltf_symbols_f;
    bit             mumimo_ltf_mode_f;
    bit [1:0]       gi_and_ltf_type_f;
    bit [1:0]       bw_f;
    bit             cs_required_f;
    bit             more_tf_f;
    bit [11:0]      length_f;
    trigger_type_e  trigger_type_f;
  } common_info_s;

  //--------------------------------------------
  // User Info subfield of the Trigger frame
  //--------------------------------------------
  typedef struct packed {
    bit             reserved;
    bit [6:0]       target_rssi_f;
    bit [5:0]       ss_allocation_f;
    bit             dcm_f;
    bit [3:0]       mcs_f;
    bit             coding_type_f;
    bit [7:0]       ru_allocation_f;
    bit [11:0]      aid12_f;
  } user_info_s;

  //--------------------------------------------
  // User Info subfield in case of NDP Feedback
  //--------------------------------------------
  typedef struct packed {
    bit [11:0]      starting_aid_f;
    bit [8:0]       reserved_f;
    bit [3:0]       feedback_type_f;
    bit [6:0]       reserved2_f;
    bit [6:0]       target_rssi_f;
    bit             multiplexing_flag_f;
  } user_info_ndp_feedback_s;

  //--------------------------------------------
  // Trigger Dependent User Info subfield
  //--------------------------------------------
  typedef struct packed {
    bit [1:0]       mpdu_mu_spc_fact_f;
    bit [2:0]       tid_agg_limit_f;
    bit             reserved;
    bit [1:0]       preferred_ac_f;
  } trigger_dependent_user_info_s;
  //--------------------------------------------
  // OFDMA RU types
  //--------------------------------------------
  typedef enum int {
    RU26    = 0,
    RU52    = 1,
    RU106   = 2,
    RU242   = 3,
    RU484   = 4,
    RU996   = 5,
    RU2X996 = 6
  } ru_type_e;

  //--------------------------------------------
  // SPATIAL REUSE types
  //--------------------------------------------
  typedef enum bit [3:0] {
    SRP_DISALLOW   = 0,
    SRP_80DBM      = 1,
    SRP_74DBM      = 2,
    SRP_68DBM      = 3,
    SRP_62DBM      = 4,
    SRP_56DBM      = 5,
    SRP_50DBM      = 6,
    SRP_47DBM      = 7,
    SRP_44DBM      = 8,
    SRP_41DBM      = 9,
    SRP_38DBM      = 10,
    SRP_35DBM      = 11,
    SRP_32DBM      = 12,
    SR_RESTRICTED  = 13, // in case of HE_TB: SRP = -29dBm
    SR_DELAY       = 14, // in case of HE_TB: SRP = -26dBm
    SRP_AND_NON_SRG_OBSS_PD_PROHIBITED = 15
  } spatial_reuse_e;

  //--------------------------------------------
  // define a dimanic array for creating a STA_ID list
  //--------------------------------------------
  typedef int sta_list_t[];

  //--------------------------------------------
  // structure for HESIGB field, used in C code for
  // compute time on air
  //--------------------------------------------
  typedef struct {
    int compressed_mode;
    int dcm;
    int mcs;
    int ru_allocation;
  } HESIGB_s;

  //--------------------------------------------
  // define which parameter will function return
  // when called
  //--------------------------------------------
  typedef enum {
    RET_TXTIME,
    RET_L_LENGTH,
    RET_PSDU_LENGTH,
    RET_NSYM
  } funcParamRet_e;

//***********************************************
// FUNCTIONS
//***********************************************

  //*****************************************************************************
  // This function will calculate FCS and return the calculated FCS.
  // Since multidimensional arrays could not be passed to the function. This
  // assumes that the source array is frame of length
  //*****************************************************************************
  function FCS_t fcs_calc_func (
                           // Number of bytes over which FCS is to be
                           // calculated. This does not include the FCS fields
                           input int length,
                           octet_t frame[]
                          );
  FCS_t X;
  FCS_t Q;
  begin
    // If length is less than minimum flag fatal error]
    if (length < 5) begin
      `uvm_error("FCS calculation",$sformatf(
           "Minimum length of packet should be 5. Current length is %0d",
           length))
    end

    X = 32'h04C1_1DB7;
    Q = 32'hFFFFFFFF;

    for (int i = 0; i < length; i = i + 1) begin
      for (int j = 0;j < $bits(octet_t); j = j + 1) begin
        Q = ((Q[30:0] * 2) ^
             (X[31:0] &
              ({32{
                   (frame[i][j] ^ Q[31])}}
              ))
            );
      end
    end
    for (int i = 0; i < 32 ; i = i + 1) begin
      fcs_calc_func[i] = ~Q [(32 - 1) - i];
    end
  end
  endfunction : fcs_calc_func

  //*****************************************************************************
  // This function calculates the 8 bit CRC (for AMPDU delimiter)
  //
  // @param[in] datain - of type bit [`DELIMITER_CRC_LENGTH-1:0]
  //
  // @return  type is bit [7:0] carries CRC
  //
  //*****************************************************************************
  function bit [7:0] delimiter_crc_func(bit [`DELIMITER_CRC_LENGTH-1:0] datain);

    bit [7:0] CRCreg;
    bit [7:0] calculatedCRC;
    bit       feedbackLine;
    CRCreg = 8'd255;

    for (int i=0; i<`DELIMITER_CRC_LENGTH; i++) begin
      feedbackLine = datain[i] ^ CRCreg[7];
      CRCreg[7] = CRCreg[6];
      CRCreg[6] = CRCreg[5];
      CRCreg[5] = CRCreg[4];
      CRCreg[4] = CRCreg[3];
      CRCreg[3] = CRCreg[2];
      CRCreg[2] = CRCreg[1] ^ feedbackLine;
      CRCreg[1] = CRCreg[0] ^ feedbackLine;
      CRCreg[0] = feedbackLine;
    end

    for (int i=0; i<8; i++) begin
      calculatedCRC[i] = ~CRCreg[7];

      CRCreg[7] = CRCreg[6];
      CRCreg[6] = CRCreg[5];
      CRCreg[5] = CRCreg[4];
      CRCreg[4] = CRCreg[3];
      CRCreg[3] = CRCreg[2];
      CRCreg[2] = CRCreg[1] ^ 0; //feedback element is zero when getting result
      CRCreg[1] = CRCreg[0] ^ 0; //feedback element is zero when getting result
      CRCreg[0] =  0; //feedback element is zero when getting result
    end

    return(calculatedCRC);

  endfunction : delimiter_crc_func

  //*****************************************************************************
  // This function calculates the 8 bit CRC (for HTSIG/VHTSIGA/HESIGA)
  //
  // @param[in] datain - of type bit [41:0]
  // @param[in] length - lenght of SIG vector
  //
  // @return  type is bit [7:0] carries CRC
  //
  //*****************************************************************************
  function bit [7:0] sig_crc_func(bit [41:0] datain, int length);

    bit [7:0] CRCreg;
    bit [7:0] calculatedCRC;
    bit       feedbackLine;
    CRCreg = 8'd255;

    for (int i=0; i<length; i++) begin
      feedbackLine = datain[i] ^ CRCreg[7];
      CRCreg[7] = CRCreg[6];
      CRCreg[6] = CRCreg[5];
      CRCreg[5] = CRCreg[4];
      CRCreg[4] = CRCreg[3];
      CRCreg[3] = CRCreg[2];
      CRCreg[2] = CRCreg[1] ^ feedbackLine;
      CRCreg[1] = CRCreg[0] ^ feedbackLine;
      CRCreg[0] = feedbackLine;
    end

    for (int i=0; i<8; i++) begin
      calculatedCRC[i] = ~CRCreg[7];

      CRCreg[7] = CRCreg[6];
      CRCreg[6] = CRCreg[5];
      CRCreg[5] = CRCreg[4];
      CRCreg[4] = CRCreg[3];
      CRCreg[3] = CRCreg[2];
      CRCreg[2] = CRCreg[1] ^ 0; //feedback element is zero when getting result
      CRCreg[1] = CRCreg[0] ^ 0; //feedback element is zero when getting result
      CRCreg[0] =  0; //feedback element is zero when getting result
    end

    return(calculatedCRC);

  endfunction : sig_crc_func

  //*****************************************************************************
  // function that returns channel bandwidth of frame in relative to global
  // setting of maximum speed
  //*****************************************************************************
  function bit [2:0] channel_bw_func(format_mod_e frm);
    case (frm)
      NON_HT:

        return 3'b000;

      NON_HT_DUP_OFDM:

        return 3'b001;

      HT_MF, HT_GF:

      `ifdef RW_NX_CHBW20
        return 3'b000;
      `else
        return $urandom_range(0,1);
      `endif

      VHT:

      `ifdef RW_NX_CHBW20
        return 3'b000;
      `elsif RW_NX_CHBW4020
        return $urandom_range(0,1);
      `elsif RW_NX_CHBW804020
        return $urandom_range(0,2);
      `else // 160 MHz
        return $urandom_range(0,3);
      `endif
      HE_SU, HE_MU, HE_EXT_SU, HE_TB:

      `ifdef RW_NX_CHBW20
        return 3'b000;
      `elsif RW_NX_CHBW4020
        return $urandom_range(0,1);
      `elsif RW_NX_CHBW804020
        return $urandom_range(0,2);
      `else // 160 MHz
        return $urandom_range(0,3);
      `endif
    endcase
  endfunction : channel_bw_func

  //*****************************************************************************
  // function calculates number of transmit chains
  //*****************************************************************************
  function bit [2:0] tx_num_func();
  `ifdef RW_TXRX_1X1
    return 3'b000;
  `elsif RW_TXRX_2X2
    return 3'b001;
  `endif
  endfunction : tx_num_func

    /*****************************************************************************
    * Function to get the number of bits in one symbol
    *
    * The function get_bits_in_one_symbol_func is a look up table to obtain the number of
    * bits in one symbol.
    * @param [in] txNumSSFn  - The number of Spatial streams in case of HT packet
    * @param [in] txFormatFn - The format of the frame:HT,NON-HT,NON-HT-DUP-OFDM
    * @param [in] txLRateFn  - The rate of the frame
    * @param [in] txChBWFn   - The channel bandwidth
    * @param [in] txMCSFn    - The mcs index of the packet
    * @param [in] txDCMFn    - The DCCM of the packet
    *
    *****************************************************************************/
    function int get_bits_in_one_symbol_func(bit [2:0] txNumSSFn,
                                             bit [4:0] txFormatFn,
                                             bit [3:0] txLRateFn,
                                             bit [2:0] txChBWFn,
                                             bit [6:0] txMCSFn,
                                             bit       txDCMFn = 0,
                                             ru_type_e txRUType = RU242);

      int       bitsInOneSymbFn;
      // The modulo8 of txMCS used in the look up table for MCS
      bit [2:0] txMCSmod;

      // Default Value
      bitsInOneSymbFn = 0;

      // HE Format
      if (txFormatFn >= 5)
      begin
        txNumSSFn = txNumSSFn + 1;
        if (txRUType == RU26 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 6   : 12;
          1:  bitsInOneSymbFn = (txDCMFn) ? 12  : 24;
          2:  bitsInOneSymbFn = 36;
          3:  bitsInOneSymbFn = (txDCMFn) ? 24  : 48;
          4:  bitsInOneSymbFn = (txDCMFn) ? 36 :  72;
          5:  bitsInOneSymbFn = 96;
          6:  bitsInOneSymbFn = 108;
          7:  bitsInOneSymbFn = 120;
          8:  bitsInOneSymbFn = 144;
          9:  bitsInOneSymbFn = 160;
          10: bitsInOneSymbFn = 180;
          11: bitsInOneSymbFn = 200;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU26 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 12  : 24;
          1:  bitsInOneSymbFn = (txDCMFn) ? 24  : 48;
          2:  bitsInOneSymbFn = 72;
          3:  bitsInOneSymbFn = (txDCMFn) ? 48  : 96;
          4:  bitsInOneSymbFn = (txDCMFn) ? 72  : 144;
          5:  bitsInOneSymbFn = 192;
          6:  bitsInOneSymbFn = 216;
          7:  bitsInOneSymbFn = 240;
          8:  bitsInOneSymbFn = 288;
          9:  bitsInOneSymbFn = 320;
          10: bitsInOneSymbFn = 360;
          11: bitsInOneSymbFn = 400;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU52 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 12  : 24;
          1:  bitsInOneSymbFn = (txDCMFn) ? 24  : 48;
          2:  bitsInOneSymbFn = 72;
          3:  bitsInOneSymbFn = (txDCMFn) ? 48  : 96;
          4:  bitsInOneSymbFn = (txDCMFn) ? 72  : 144;
          5:  bitsInOneSymbFn = 192;
          6:  bitsInOneSymbFn = 216;
          7:  bitsInOneSymbFn = 240;
          8:  bitsInOneSymbFn = 288;
          9:  bitsInOneSymbFn = 320;
          10: bitsInOneSymbFn = 360;
          11: bitsInOneSymbFn = 400;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU52 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 24  : 48;
          1:  bitsInOneSymbFn = (txDCMFn) ? 48  : 96;
          2:  bitsInOneSymbFn = 144;
          3:  bitsInOneSymbFn = (txDCMFn) ? 96  : 192;
          4:  bitsInOneSymbFn = (txDCMFn) ? 144 : 288;
          5:  bitsInOneSymbFn = 384;
          6:  bitsInOneSymbFn = 432;
          7:  bitsInOneSymbFn = 480;
          8:  bitsInOneSymbFn = 576;
          9:  bitsInOneSymbFn = 640;
          10: bitsInOneSymbFn = 720;
          11: bitsInOneSymbFn = 800;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU106 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 25  : 51;
          1:  bitsInOneSymbFn = (txDCMFn) ? 51  : 102;
          2:  bitsInOneSymbFn = 153;
          3:  bitsInOneSymbFn = (txDCMFn) ? 102 : 204;
          4:  bitsInOneSymbFn = (txDCMFn) ? 153 : 306;
          5:  bitsInOneSymbFn = 408;
          6:  bitsInOneSymbFn = 459;
          7:  bitsInOneSymbFn = 510;
          8:  bitsInOneSymbFn = 612;
          9:  bitsInOneSymbFn = 680;
          10: bitsInOneSymbFn = 765;
          11: bitsInOneSymbFn = 850;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU106 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 51  : 102;
          1:  bitsInOneSymbFn = (txDCMFn) ? 102 : 204;
          2:  bitsInOneSymbFn = 306;
          3:  bitsInOneSymbFn = (txDCMFn) ? 204 : 408;
          4:  bitsInOneSymbFn = (txDCMFn) ? 306 : 612;
          5:  bitsInOneSymbFn = 816;
          6:  bitsInOneSymbFn = 918;
          7:  bitsInOneSymbFn = 1020;
          8:  bitsInOneSymbFn = 1224;
          9:  bitsInOneSymbFn = 1360;
          10: bitsInOneSymbFn = 1530;
          11: bitsInOneSymbFn = 1700;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU242 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 58  : 117;
          1:  bitsInOneSymbFn = (txDCMFn) ? 117 : 234;
          2:  bitsInOneSymbFn = 351;
          3:  bitsInOneSymbFn = (txDCMFn) ? 234 : 468;
          4:  bitsInOneSymbFn = (txDCMFn) ? 351 : 702;
          5:  bitsInOneSymbFn = 936;
          6:  bitsInOneSymbFn = 1053;
          7:  bitsInOneSymbFn = 1170;
          8:  bitsInOneSymbFn = 1404;
          9:  bitsInOneSymbFn = 1560;
          10: bitsInOneSymbFn = 1755;
          11: bitsInOneSymbFn = 1950;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU242 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 117 : 234;
          1:  bitsInOneSymbFn = (txDCMFn) ? 234 : 468;
          2:  bitsInOneSymbFn = 702;
          3:  bitsInOneSymbFn = (txDCMFn) ? 468 : 936;
          4:  bitsInOneSymbFn = (txDCMFn) ? 702 : 1404;
          5:  bitsInOneSymbFn = 1872;
          6:  bitsInOneSymbFn = 2106;
          7:  bitsInOneSymbFn = 2340;
          8:  bitsInOneSymbFn = 2808;
          9:  bitsInOneSymbFn = 3120;
          10: bitsInOneSymbFn = 3510;
          11: bitsInOneSymbFn = 3900;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU242 && txNumSSFn == 3) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 351;
          1:  bitsInOneSymbFn = 702;
          2:  bitsInOneSymbFn = 1053;
          3:  bitsInOneSymbFn = 1404;
          4:  bitsInOneSymbFn = 2106;
          5:  bitsInOneSymbFn = 2808;
          6:  bitsInOneSymbFn = 3159;
          7:  bitsInOneSymbFn = 3510;
          8:  bitsInOneSymbFn = 4212;
          9:  bitsInOneSymbFn = 4680;
          10: bitsInOneSymbFn = 5265;
          11: bitsInOneSymbFn = 5850;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU242 && txNumSSFn == 4) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 468;
          1:  bitsInOneSymbFn = 936;
          2:  bitsInOneSymbFn = 1404;
          3:  bitsInOneSymbFn = 1872;
          4:  bitsInOneSymbFn = 2808;
          5:  bitsInOneSymbFn = 3744;
          6:  bitsInOneSymbFn = 4212;
          7:  bitsInOneSymbFn = 4680;
          8:  bitsInOneSymbFn = 5616;
          9:  bitsInOneSymbFn = 6240;
          10: bitsInOneSymbFn = 7020;
          11: bitsInOneSymbFn = 7800;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU484 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 117 : 234;
          1:  bitsInOneSymbFn = (txDCMFn) ? 234 : 468;
          2:  bitsInOneSymbFn = 702;
          3:  bitsInOneSymbFn = (txDCMFn) ? 468 : 936;
          4:  bitsInOneSymbFn = (txDCMFn) ? 702 : 1404;
          5:  bitsInOneSymbFn = 1872;
          6:  bitsInOneSymbFn = 2106;
          7:  bitsInOneSymbFn = 2340;
          8:  bitsInOneSymbFn = 2808;
          9:  bitsInOneSymbFn = 3120;
          10: bitsInOneSymbFn = 3510;
          11: bitsInOneSymbFn = 3900;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU484 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 234 : 468;
          1:  bitsInOneSymbFn = (txDCMFn) ? 468 : 936;
          2:  bitsInOneSymbFn = 1404;
          3:  bitsInOneSymbFn = (txDCMFn) ? 936 : 1872;
          4:  bitsInOneSymbFn = (txDCMFn) ? 1404: 2808;
          5:  bitsInOneSymbFn = 3744;
          6:  bitsInOneSymbFn = 4212;
          7:  bitsInOneSymbFn = 4680;
          8:  bitsInOneSymbFn = 5616;
          9:  bitsInOneSymbFn = 6240;
          10: bitsInOneSymbFn = 7020;
          11: bitsInOneSymbFn = 7800;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU484 && txNumSSFn == 3) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 702;
          1:  bitsInOneSymbFn = 1404;
          2:  bitsInOneSymbFn = 2106;
          3:  bitsInOneSymbFn = 2808;
          4:  bitsInOneSymbFn = 4212;
          5:  bitsInOneSymbFn = 5616;
          6:  bitsInOneSymbFn = 6318;
          7:  bitsInOneSymbFn = 7020;
          8:  bitsInOneSymbFn = 8424;
          9:  bitsInOneSymbFn = 9360;
          10: bitsInOneSymbFn = 10530;
          11: bitsInOneSymbFn = 11700;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU484 && txNumSSFn == 4) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 936;
          1:  bitsInOneSymbFn = 1872;
          2:  bitsInOneSymbFn = 2808;
          3:  bitsInOneSymbFn = 3744;
          4:  bitsInOneSymbFn = 5616;
          5:  bitsInOneSymbFn = 7488;
          6:  bitsInOneSymbFn = 8424;
          7:  bitsInOneSymbFn = 9360;
          8:  bitsInOneSymbFn = 11232;
          9:  bitsInOneSymbFn = 12480;
          10: bitsInOneSymbFn = 14040;
          11: bitsInOneSymbFn = 15600;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU996 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 245 : 490;
          1:  bitsInOneSymbFn = (txDCMFn) ? 490 : 980;
          2:  bitsInOneSymbFn = 1470;
          3:  bitsInOneSymbFn = (txDCMFn) ? 980 : 1960;
          4:  bitsInOneSymbFn = (txDCMFn) ? 1470: 2940;
          5:  bitsInOneSymbFn = 3920;
          6:  bitsInOneSymbFn = 4410;
          7:  bitsInOneSymbFn = 4900;
          8:  bitsInOneSymbFn = 5880;
          9:  bitsInOneSymbFn = 6533;
          10: bitsInOneSymbFn = 7350;
          11: bitsInOneSymbFn = 8166;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU996 && txNumSSFn == 2) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 490 : 980;
          1:  bitsInOneSymbFn = (txDCMFn) ? 980 : 1960;
          2:  bitsInOneSymbFn = 2940;
          3:  bitsInOneSymbFn = (txDCMFn) ? 1960: 3920;
          4:  bitsInOneSymbFn = (txDCMFn) ? 2940: 5880;
          5:  bitsInOneSymbFn = 7840;
          6:  bitsInOneSymbFn = 8820;
          7:  bitsInOneSymbFn = 9800;
          8:  bitsInOneSymbFn = 11760;
          9:  bitsInOneSymbFn = 13066;
          10: bitsInOneSymbFn = 14700;
          11: bitsInOneSymbFn = 16333;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU996 && txNumSSFn == 3) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 1470;
          1:  bitsInOneSymbFn = 2940;
          2:  bitsInOneSymbFn = 4410;
          3:  bitsInOneSymbFn = 5880;
          4:  bitsInOneSymbFn = 8820;
          5:  bitsInOneSymbFn = 11760;
          6:  bitsInOneSymbFn = 13230;
          7:  bitsInOneSymbFn = 14700;
          8:  bitsInOneSymbFn = 17640;
          9:  bitsInOneSymbFn = 19600;
          10: bitsInOneSymbFn = 22050;
          11: bitsInOneSymbFn = 24500;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU996 && txNumSSFn == 4) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = 1960;
          1:  bitsInOneSymbFn = 3920;
          2:  bitsInOneSymbFn = 5880;
          3:  bitsInOneSymbFn = 7840;
          4:  bitsInOneSymbFn = 11760;
          5:  bitsInOneSymbFn = 15680;
          6:  bitsInOneSymbFn = 17640;
          7:  bitsInOneSymbFn = 19600;
          8:  bitsInOneSymbFn = 23520;
          9:  bitsInOneSymbFn = 26133;
          10: bitsInOneSymbFn = 29400;
          11: bitsInOneSymbFn = 32666;
          default : bitsInOneSymbFn = 0;
          endcase
        end
        else if (txRUType == RU2X996 && txNumSSFn == 1) begin
          case (txMCSFn)
          0:  bitsInOneSymbFn = (txDCMFn) ? 490 : 980;
          1:  bitsInOneSymbFn = (txDCMFn) ? 490 : 980;
          2:  bitsInOneSymbFn = 2940;
          3:  bitsInOneSymbFn = (txDCMFn) ? 1960: 3920;
          4:  bitsInOneSymbFn = (txDCMFn) ? 2940: 5880;
          5:  bitsInOneSymbFn = 7840;
          6:  bitsInOneSymbFn = 8820;
          7:  bitsInOneSymbFn = 9800;
          8:  bitsInOneSymbFn = 11760;
          9:  bitsInOneSymbFn = 13066;
          10: bitsInOneSymbFn = 14700;
          11: bitsInOneSymbFn = 16333;
          default : bitsInOneSymbFn = 0;
          endcase
        end
      end
      // VHT Format
      else if (txFormatFn == 4)
      begin
        if ((txChBWFn==0) && (txNumSSFn==1))
        begin
          //Table 22-30—VHT-MCSs for mandatory 20 MHz, NSS = 1
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 26;
          1: bitsInOneSymbFn = 52;
          2: bitsInOneSymbFn = 78;
          3: bitsInOneSymbFn = 104;
          4: bitsInOneSymbFn = 156;
          5: bitsInOneSymbFn = 208;
          6: bitsInOneSymbFn = 234;
          7: bitsInOneSymbFn = 260;
          8: bitsInOneSymbFn = 312;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==2))
        begin
          //Table 22-31—VHT-MCSs for optional 20 MHz, NSS = 2
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 52;
          1: bitsInOneSymbFn = 104;
          2: bitsInOneSymbFn = 156;
          3: bitsInOneSymbFn = 208;
          4: bitsInOneSymbFn = 312;
          5: bitsInOneSymbFn = 416;
          6: bitsInOneSymbFn = 468;
          7: bitsInOneSymbFn = 520;
          8: bitsInOneSymbFn = 624;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==3))
        begin
          //Table 22-32—VHT-MCSs for optional 20 MHz, NSS = 3
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 78;
          1: bitsInOneSymbFn = 156;
          2: bitsInOneSymbFn = 234;
          3: bitsInOneSymbFn = 312;
          4: bitsInOneSymbFn = 468;
          5: bitsInOneSymbFn = 624;
          6: bitsInOneSymbFn = 702;
          7: bitsInOneSymbFn = 780;
          8: bitsInOneSymbFn = 936;
          9: bitsInOneSymbFn = 1040;
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==4))
        begin
          //Table 22-33—VHT-MCSs for optional 20 MHz, NSS = 4
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 104;
          1: bitsInOneSymbFn = 208;
          2: bitsInOneSymbFn = 312;
          3: bitsInOneSymbFn = 416;
          4: bitsInOneSymbFn = 624;
          5: bitsInOneSymbFn = 832;
          6: bitsInOneSymbFn = 936;
          7: bitsInOneSymbFn = 1040;
          8: bitsInOneSymbFn = 1248;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==5))
        begin
          //Table 22-34—VHT-MCSs for optional 20 MHz, NSS = 5
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 130;
          1: bitsInOneSymbFn = 260;
          2: bitsInOneSymbFn = 390;
          3: bitsInOneSymbFn = 520;
          4: bitsInOneSymbFn = 780;
          5: bitsInOneSymbFn = 1040;
          6: bitsInOneSymbFn = 1170;
          7: bitsInOneSymbFn = 1300;
          8: bitsInOneSymbFn = 1560;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==6))
        begin
          //Table 22-35—VHT-MCSs for optional 20 MHz, NSS = 6
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 156;
          1: bitsInOneSymbFn = 312;
          2: bitsInOneSymbFn = 468;
          3: bitsInOneSymbFn = 624;
          4: bitsInOneSymbFn = 936;
          5: bitsInOneSymbFn = 1248;
          6: bitsInOneSymbFn = 1404;
          7: bitsInOneSymbFn = 1560;
          8: bitsInOneSymbFn = 1872;
          9: bitsInOneSymbFn = 2080;
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==7))
        begin
          //Table 22-36—VHT-MCSs for optional 20 MHz, NSS = 7
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 182;
          1: bitsInOneSymbFn = 364;
          2: bitsInOneSymbFn = 546;
          3: bitsInOneSymbFn = 728;
          4: bitsInOneSymbFn = 1092;
          5: bitsInOneSymbFn = 1456;
          6: bitsInOneSymbFn = 1638;
          7: bitsInOneSymbFn = 1820;
          8: bitsInOneSymbFn = 2184;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==0) && (txNumSSFn==8))
        begin
          //Table 22-37—VHT-MCSs for optional 20 MHz, NSS = 8
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 208;
          1: bitsInOneSymbFn = 416;
          2: bitsInOneSymbFn = 624;
          3: bitsInOneSymbFn = 832;
          4: bitsInOneSymbFn = 1248;
          5: bitsInOneSymbFn = 1664;
          6: bitsInOneSymbFn = 1872;
          7: bitsInOneSymbFn = 2080;
          8: bitsInOneSymbFn = 2496;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==1))
        begin
          //Table 22-38—VHT-MCSs for mandatory 40 MHz, NSS = 1
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 54;
          1: bitsInOneSymbFn = 108;
          2: bitsInOneSymbFn = 162;
          3: bitsInOneSymbFn = 216;
          4: bitsInOneSymbFn = 324;
          5: bitsInOneSymbFn = 432;
          6: bitsInOneSymbFn = 486;
          7: bitsInOneSymbFn = 540;
          8: bitsInOneSymbFn = 648;
          9: bitsInOneSymbFn = 720;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==2))
        begin
          //Table 22-39—VHT-MCSs for optional 40 MHz, NSS = 2
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 108;
          1: bitsInOneSymbFn = 216;
          2: bitsInOneSymbFn = 324;
          3: bitsInOneSymbFn = 432;
          4: bitsInOneSymbFn = 648;
          5: bitsInOneSymbFn = 864;
          6: bitsInOneSymbFn = 972;
          7: bitsInOneSymbFn = 1080;
          8: bitsInOneSymbFn = 1296;
          9: bitsInOneSymbFn = 1440;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==3))
        begin
          //Table 22-40—VHT-MCSs for optional 40 MHz, NSS = 3
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 162;
          1: bitsInOneSymbFn = 324;
          2: bitsInOneSymbFn = 486;
          3: bitsInOneSymbFn = 648;
          4: bitsInOneSymbFn = 972;
          5: bitsInOneSymbFn = 1296;
          6: bitsInOneSymbFn = 1458;
          7: bitsInOneSymbFn = 1620;
          8: bitsInOneSymbFn = 1944;
          9: bitsInOneSymbFn = 2160;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==4))
        begin
          //Table 22-41—VHT-MCSs for optional 40 MHz, NSS = 4
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 216;
          1: bitsInOneSymbFn = 432;
          2: bitsInOneSymbFn = 648;
          3: bitsInOneSymbFn = 864;
          4: bitsInOneSymbFn = 1296;
          5: bitsInOneSymbFn = 1728;
          6: bitsInOneSymbFn = 1944;
          7: bitsInOneSymbFn = 2160;
          8: bitsInOneSymbFn = 2592;
          9: bitsInOneSymbFn = 2880;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==5))
        begin
          //Table 22-42—VHT-MCSs for optional 40 MHz, NSS = 5
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 270;
          1: bitsInOneSymbFn = 540;
          2: bitsInOneSymbFn = 810;
          3: bitsInOneSymbFn = 1080;
          4: bitsInOneSymbFn = 1620;
          5: bitsInOneSymbFn = 2160;
          6: bitsInOneSymbFn = 2430;
          7: bitsInOneSymbFn = 2700;
          8: bitsInOneSymbFn = 3240;
          9: bitsInOneSymbFn = 3600;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==6))
        begin
          //Table 22-43—VHT-MCSs for optional 40 MHz, NSS = 6
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 324;
          1: bitsInOneSymbFn = 648;
          2: bitsInOneSymbFn = 972;
          3: bitsInOneSymbFn = 1296;
          4: bitsInOneSymbFn = 1944;
          5: bitsInOneSymbFn = 2592;
          6: bitsInOneSymbFn = 2916;
          7: bitsInOneSymbFn = 3240;
          8: bitsInOneSymbFn = 3888;
          9: bitsInOneSymbFn = 4320;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==7))
        begin
          //Table 22-44—VHT-MCSs for optional 40 MHz, NSS = 7
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 378;
          1: bitsInOneSymbFn = 756;
          2: bitsInOneSymbFn = 1134;
          3: bitsInOneSymbFn = 1512;
          4: bitsInOneSymbFn = 2268;
          5: bitsInOneSymbFn = 3024;
          6: bitsInOneSymbFn = 3402;
          7: bitsInOneSymbFn = 3780;
          8: bitsInOneSymbFn = 4536;
          9: bitsInOneSymbFn = 5040;
          endcase
        end
        else if ((txChBWFn==1) && (txNumSSFn==8))
        begin
          //Table 22-45—VHT-MCSs for optional 40 MHz, NSS = 8
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 432;
          1: bitsInOneSymbFn = 864;
          2: bitsInOneSymbFn = 1296;
          3: bitsInOneSymbFn = 1728;
          4: bitsInOneSymbFn = 2592;
          5: bitsInOneSymbFn = 3456;
          6: bitsInOneSymbFn = 3888;
          7: bitsInOneSymbFn = 4320;
          8: bitsInOneSymbFn = 5184;
          9: bitsInOneSymbFn = 5760;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==1))
        begin
          //Table 22-46—VHT-MCSs for mandatory 80 MHz, NSS = 1
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 117;
          1: bitsInOneSymbFn = 234;
          2: bitsInOneSymbFn = 351;
          3: bitsInOneSymbFn = 468;
          4: bitsInOneSymbFn = 702;
          5: bitsInOneSymbFn = 936;
          6: bitsInOneSymbFn = 1053;
          7: bitsInOneSymbFn = 1170;
          8: bitsInOneSymbFn = 1404;
          9: bitsInOneSymbFn = 1560;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==2))
        begin
          //Table 22-47—VHT-MCSs for optional 80 MHz, NSS = 2
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 234;
          1: bitsInOneSymbFn = 468;
          2: bitsInOneSymbFn = 702;
          3: bitsInOneSymbFn = 936;
          4: bitsInOneSymbFn = 1404;
          5: bitsInOneSymbFn = 1872;
          6: bitsInOneSymbFn = 2106;
          7: bitsInOneSymbFn = 2340;
          8: bitsInOneSymbFn = 2808;
          9: bitsInOneSymbFn = 3120;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==3))
        begin
          //Table 22-48—VHT-MCSs for optional 80 MHz, NSS = 3
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 351;
          1: bitsInOneSymbFn = 702;
          2: bitsInOneSymbFn = 1053;
          3: bitsInOneSymbFn = 1404;
          4: bitsInOneSymbFn = 2106;
          5: bitsInOneSymbFn = 2808;
          //6: Not valid
          7: bitsInOneSymbFn = 3510;
          8: bitsInOneSymbFn = 4212;
          9: bitsInOneSymbFn = 4680;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==4))
        begin
          //Table 22-49—VHT-MCSs for optional 80 MHz, NSS = 4
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 468;
          1: bitsInOneSymbFn = 936;
          2: bitsInOneSymbFn = 1404;
          3: bitsInOneSymbFn = 1872;
          4: bitsInOneSymbFn = 2808;
          5: bitsInOneSymbFn = 3744;
          6: bitsInOneSymbFn = 4212;
          7: bitsInOneSymbFn = 4680;
          8: bitsInOneSymbFn = 5616;
          9: bitsInOneSymbFn = 6240;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==5))
        begin
          //Table 22-50—VHT-MCSs for optional 80 MHz, NSS = 5
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 585;
          1: bitsInOneSymbFn = 1170;
          2: bitsInOneSymbFn = 1755;
          3: bitsInOneSymbFn = 2340;
          4: bitsInOneSymbFn = 3510;
          5: bitsInOneSymbFn = 4680;
          6: bitsInOneSymbFn = 5265;
          7: bitsInOneSymbFn = 5850;
          8: bitsInOneSymbFn = 7020;
          9: bitsInOneSymbFn = 7800;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==6))
        begin
          //Table 22-51—VHT-MCSs for optional 80 MHz, NSS = 6
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 702;
          1: bitsInOneSymbFn = 1404;
          2: bitsInOneSymbFn = 2106;
          3: bitsInOneSymbFn = 2808;
          4: bitsInOneSymbFn = 4212;
          5: bitsInOneSymbFn = 5616;
          6: bitsInOneSymbFn = 6318;
          7: bitsInOneSymbFn = 7020;
          8: bitsInOneSymbFn = 8424;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==7))
        begin
          //Table 22-52—VHT-MCSs for optional 80 MHz, NSS = 7
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 819;
          1: bitsInOneSymbFn = 1638;
          2: bitsInOneSymbFn = 2457;
          3: bitsInOneSymbFn = 3276;
          4: bitsInOneSymbFn = 4914;
          5: bitsInOneSymbFn = 6552;
          //6: Not valid
          7: bitsInOneSymbFn = 8190;
          8: bitsInOneSymbFn = 9828;
          9: bitsInOneSymbFn = 10920;
          endcase
        end
        else if ((txChBWFn==2) && (txNumSSFn==8))
        begin
          //Table 22-53—VHT-MCSs for optional 80 MHz, NSS = 8
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 936;
          1: bitsInOneSymbFn = 1872;
          2: bitsInOneSymbFn = 2808;
          3: bitsInOneSymbFn = 3744;
          4: bitsInOneSymbFn = 5616;
          5: bitsInOneSymbFn = 7488;
          6: bitsInOneSymbFn = 8424;
          7: bitsInOneSymbFn = 9360;
          8: bitsInOneSymbFn = 11232;
          9: bitsInOneSymbFn = 12480;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==1))
        begin
          //Table 22-54—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 1
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 234;
          1: bitsInOneSymbFn = 468;
          2: bitsInOneSymbFn = 702;
          3: bitsInOneSymbFn = 936;
          4: bitsInOneSymbFn = 1404;
          5: bitsInOneSymbFn = 1872;
          6: bitsInOneSymbFn = 2106;
          7: bitsInOneSymbFn = 2340;
          8: bitsInOneSymbFn = 2808;
          9: bitsInOneSymbFn = 3120;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==2))
        begin
          //Table 22-55—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 2
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 468;
          1: bitsInOneSymbFn = 936;
          2: bitsInOneSymbFn = 1404;
          3: bitsInOneSymbFn = 1872;
          4: bitsInOneSymbFn = 2808;
          5: bitsInOneSymbFn = 3744;
          6: bitsInOneSymbFn = 4212;
          7: bitsInOneSymbFn = 4680;
          8: bitsInOneSymbFn = 5616;
          9: bitsInOneSymbFn = 6240;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==3))
        begin
          //Table 22-56—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 3
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 702;
          1: bitsInOneSymbFn = 1404;
          2: bitsInOneSymbFn = 2106;
          3: bitsInOneSymbFn = 2808;
          4: bitsInOneSymbFn = 4212;
          5: bitsInOneSymbFn = 5616;
          6: bitsInOneSymbFn = 6318;
          7: bitsInOneSymbFn = 7020;
          8: bitsInOneSymbFn = 8424;
          //9: Not valid
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==4))
        begin
          //Table 22-57—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 4
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 936;
          1: bitsInOneSymbFn = 1872;
          2: bitsInOneSymbFn = 2808;
          3: bitsInOneSymbFn = 3744;
          4: bitsInOneSymbFn = 5616;
          5: bitsInOneSymbFn = 7488;
          6: bitsInOneSymbFn = 8424;
          7: bitsInOneSymbFn = 9360;
          8: bitsInOneSymbFn = 11232;
          9: bitsInOneSymbFn = 12480;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==5))
        begin
          //Table 22-58—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 5
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 1170;
          1: bitsInOneSymbFn = 2340;
          2: bitsInOneSymbFn = 3510;
          3: bitsInOneSymbFn = 4680;
          4: bitsInOneSymbFn = 7020;
          5: bitsInOneSymbFn = 9360;
          6: bitsInOneSymbFn = 10530;
          7: bitsInOneSymbFn = 11700;
          8: bitsInOneSymbFn = 14040;
          9: bitsInOneSymbFn = 15600;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==6))
        begin
          //Table 22-59—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 6
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 1404;
          1: bitsInOneSymbFn = 2808;
          2: bitsInOneSymbFn = 4212;
          3: bitsInOneSymbFn = 5616;
          4: bitsInOneSymbFn = 8424;
          5: bitsInOneSymbFn = 11232;
          6: bitsInOneSymbFn = 12636;
          7: bitsInOneSymbFn = 14040;
          8: bitsInOneSymbFn = 16848;
          9: bitsInOneSymbFn = 18720;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==7))
        begin
          //Table 22-60—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 7
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 1638;
          1: bitsInOneSymbFn = 3276;
          2: bitsInOneSymbFn = 4914;
          3: bitsInOneSymbFn = 6552;
          4: bitsInOneSymbFn = 9828;
          5: bitsInOneSymbFn = 13104;
          6: bitsInOneSymbFn = 14742;
          7: bitsInOneSymbFn = 16380;
          8: bitsInOneSymbFn = 19656;
          9: bitsInOneSymbFn = 21840;
          endcase
        end
        else if ((txChBWFn==3) && (txNumSSFn==8))
        begin
          //Table 22-61—VHT-MCSs for optional 160 MHz and 80+80 MHz, NSS = 8
          case (txMCSFn[3:0])
          0: bitsInOneSymbFn = 1872;
          1: bitsInOneSymbFn = 3744;
          2: bitsInOneSymbFn = 5616;
          3: bitsInOneSymbFn = 7488;
          4: bitsInOneSymbFn = 11232;
          5: bitsInOneSymbFn = 14976;
          6: bitsInOneSymbFn = 16848;
          7: bitsInOneSymbFn = 18720;
          8: bitsInOneSymbFn = 22464;
          9: bitsInOneSymbFn = 24960;
          endcase
        end
      end
      // HT Format
      else if ((txFormatFn == 2) || (txFormatFn == 3))
      begin
        if ((txMCSFn>=7'd0)&(txMCSFn<=7'd31))
        begin
          //This portion concentrates on txMCS values in between 0 to 31
          //for 20 and 40 MHz.
          txMCSmod=(txMCSFn % 8);
          if (txChBWFn==1'b0)
          begin
            case(txMCSmod)
              3'b000: bitsInOneSymbFn = (26*txNumSSFn);
              3'b001: bitsInOneSymbFn = (52*txNumSSFn);
              3'b010: bitsInOneSymbFn = (78*txNumSSFn);
              3'b011: bitsInOneSymbFn = (104*txNumSSFn);
              3'b100: bitsInOneSymbFn = (156*txNumSSFn);
              3'b101: bitsInOneSymbFn = (208*txNumSSFn);
              3'b110: bitsInOneSymbFn = (234*txNumSSFn);
              3'b111: bitsInOneSymbFn = (260*txNumSSFn);
            endcase
          end
          else
          begin
            case(txMCSmod)
              3'b000: bitsInOneSymbFn = (54*txNumSSFn);
              3'b001: bitsInOneSymbFn = (108*txNumSSFn);
              3'b010: bitsInOneSymbFn = (162*txNumSSFn);
              3'b011: bitsInOneSymbFn = (216*txNumSSFn);
              3'b100: bitsInOneSymbFn = (324*txNumSSFn);
              3'b101: bitsInOneSymbFn = (432*txNumSSFn);
              3'b110: bitsInOneSymbFn = (486*txNumSSFn);
              3'b111: bitsInOneSymbFn = (540*txNumSSFn);
            endcase
          end
        end
        //This portion concentrates on txMCS value of 32 and 40 MHz.
        else if ((txMCSFn==7'd32)&(txChBWFn==1))
        begin
          bitsInOneSymbFn = 24;
        end
        else if ((txMCSFn>=7'd33)&(txMCSFn<=7'd76))
        begin
          if (txChBWFn == 0)
          begin
            case(txMCSFn)
              7'd33 : bitsInOneSymbFn = 156;
              7'd34 : bitsInOneSymbFn = 208;
              7'd35 : bitsInOneSymbFn = 260;
              7'd36 : bitsInOneSymbFn = 234;
              7'd37 : bitsInOneSymbFn = 312;
              7'd38 : bitsInOneSymbFn = 390;
              7'd39 : bitsInOneSymbFn = 208;
              7'd40 : bitsInOneSymbFn = 260;
              7'd41 : bitsInOneSymbFn = 260;
              7'd42 : bitsInOneSymbFn = 312;
              7'd43 : bitsInOneSymbFn = 364;
              7'd44 : bitsInOneSymbFn = 364;
              7'd45 : bitsInOneSymbFn = 416;
              7'd46 : bitsInOneSymbFn = 312;
              7'd47 : bitsInOneSymbFn = 390;
              7'd48 : bitsInOneSymbFn = 390;
              7'd49 : bitsInOneSymbFn = 468;
              7'd50 : bitsInOneSymbFn = 546;
              7'd51 : bitsInOneSymbFn = 546;
              7'd52 : bitsInOneSymbFn = 624;
              7'd53 : bitsInOneSymbFn = 260;
              7'd54 : bitsInOneSymbFn = 312;
              7'd55 : bitsInOneSymbFn = 364;
              7'd56 : bitsInOneSymbFn = 312;
              7'd57 : bitsInOneSymbFn = 364;
              7'd58 : bitsInOneSymbFn = 416;
              7'd59 : bitsInOneSymbFn = 468;
              7'd60 : bitsInOneSymbFn = 416;
              7'd61 : bitsInOneSymbFn = 468;
              7'd62 : bitsInOneSymbFn = 520;
              7'd63 : bitsInOneSymbFn = 520;
              7'd64 : bitsInOneSymbFn = 572;
              7'd65 : bitsInOneSymbFn = 390;
              7'd66 : bitsInOneSymbFn = 468;
              7'd67 : bitsInOneSymbFn = 546;
              7'd68 : bitsInOneSymbFn = 468;
              7'd69 : bitsInOneSymbFn = 546;
              7'd70 : bitsInOneSymbFn = 624;
              7'd71 : bitsInOneSymbFn = 702;
              7'd72 : bitsInOneSymbFn = 624;
              7'd73 : bitsInOneSymbFn = 702;
              7'd74 : bitsInOneSymbFn = 780;
              7'd75 : bitsInOneSymbFn = 780;
              7'd76 : bitsInOneSymbFn = 858;
            endcase
          end
          else
          begin
            case(txMCSFn)
              7'd33 : bitsInOneSymbFn = 324;
              7'd34 : bitsInOneSymbFn = 432;
              7'd35 : bitsInOneSymbFn = 540;
              7'd36 : bitsInOneSymbFn = 486;
              7'd37 : bitsInOneSymbFn = 648;
              7'd38 : bitsInOneSymbFn = 810;
              7'd39 : bitsInOneSymbFn = 432;
              7'd40 : bitsInOneSymbFn = 540;
              7'd41 : bitsInOneSymbFn = 540;
              7'd42 : bitsInOneSymbFn = 648;
              7'd43 : bitsInOneSymbFn = 756;
              7'd44 : bitsInOneSymbFn = 756;
              7'd45 : bitsInOneSymbFn = 864;
              7'd46 : bitsInOneSymbFn = 648;
              7'd47 : bitsInOneSymbFn = 810;
              7'd48 : bitsInOneSymbFn = 810;
              7'd49 : bitsInOneSymbFn = 972;
              7'd50 : bitsInOneSymbFn = 1134;
              7'd51 : bitsInOneSymbFn = 1134;
              7'd52 : bitsInOneSymbFn = 1296;
              7'd53 : bitsInOneSymbFn = 540;
              7'd54 : bitsInOneSymbFn = 648;
              7'd55 : bitsInOneSymbFn = 756;
              7'd56 : bitsInOneSymbFn = 648;
              7'd57 : bitsInOneSymbFn = 756;
              7'd58 : bitsInOneSymbFn = 864;
              7'd59 : bitsInOneSymbFn = 972;
              7'd60 : bitsInOneSymbFn = 864;
              7'd61 : bitsInOneSymbFn = 972;
              7'd62 : bitsInOneSymbFn = 1080;
              7'd63 : bitsInOneSymbFn = 1080;
              7'd64 : bitsInOneSymbFn = 1188;
              7'd65 : bitsInOneSymbFn = 810;
              7'd66 : bitsInOneSymbFn = 972;
              7'd67 : bitsInOneSymbFn = 1134;
              7'd68 : bitsInOneSymbFn = 972;
              7'd69 : bitsInOneSymbFn = 1134;
              7'd70 : bitsInOneSymbFn = 1296;
              7'd71 : bitsInOneSymbFn = 1458;
              7'd72 : bitsInOneSymbFn = 1296;
              7'd73 : bitsInOneSymbFn = 1458;
              7'd74 : bitsInOneSymbFn = 1620;
              7'd75 : bitsInOneSymbFn = 1620;
              7'd76 : bitsInOneSymbFn = 1782;
            endcase
          end
        end
      end
      // NON-HT Format
      else
      begin
        case(txLRateFn[3:0])
          4'b0000 :
          begin
            bitsInOneSymbFn = 4;
          end
          4'b0001 :
          begin
            bitsInOneSymbFn = 8;
          end
          4'b0010 :
          begin
            bitsInOneSymbFn = 22;
          end
          4'b0011 :
          begin
            bitsInOneSymbFn = 44;
          end
          4'b1011 :
          begin
            bitsInOneSymbFn = 24;
          end
          4'b1111 :
          begin
            bitsInOneSymbFn = 36;
          end
          4'b1010 :
          begin
            bitsInOneSymbFn = 48;
          end
          4'b1110 :
          begin
            bitsInOneSymbFn = 72;
          end
          4'b1001 :
          begin
            bitsInOneSymbFn = 96;
          end
          4'b1101 :
          begin
            bitsInOneSymbFn = 144;
          end
          4'b1000 :
          begin
            bitsInOneSymbFn = 192;
          end
          4'b1100 :
          begin
            bitsInOneSymbFn = 216;
          end
        endcase
      end

      if (bitsInOneSymbFn == 0)
        `uvm_error("FUNC ERROR",$sformatf("get_bits_in_one_symbol_func, Invalid parameters:\n"))
      return(bitsInOneSymbFn);
    endfunction : get_bits_in_one_symbol_func

  //*************************************************************
  // Calculate the number of spatial streams based on txMCS.
  //*************************************************************
  function int get_num_ss_func(int txMCS,
                               int txFormat,
                               int txChBW,
                               int txnSTS,
                               int txSTBC);

    int     txNumSS;

    `uvm_info("GET_NUM_SS_FUNC", $sformatf("MCS = %0d, format = %0d, CHBW = %0d, nSTS = %0d, STBC = %0d",
               txMCS,txFormat,txChBW,txnSTS,txSTBC), UVM_HIGH)
    txNumSS = 0; // Default value

    // HT-MF and HT-GF
    if ((txFormat == 2) || (txFormat == 3)) begin
       if (((txMCS>=7'd0 ) & (txMCS<=7'd7)) |
           ((txMCS==7'd32) & (txChBW == 1)))
         txNumSS = 1;
       else if (((txMCS>=7'd8)  & (txMCS<=7'd15)) |
                ((txMCS>=7'd33) & (txMCS<=7'd38)))
         txNumSS = 2;
       else if (((txMCS>=7'd16) & (txMCS<=7'd23)) |
                ((txMCS>=7'd39) & (txMCS<=7'd52)))
         txNumSS = 3;
       else if (((txMCS>=7'd24) & (txMCS<=7'd31)) |
                ((txMCS>=7'd53) & (txMCS<=7'd76)))
         txNumSS = 4;
    end
    // VHT
    else if (txFormat == 4) begin
       if (txSTBC==2'b00)
         txNumSS = txnSTS + 1;
       else if (txSTBC==2'b01)
         txNumSS = (txnSTS+1)/2;
    end
    // HE-SU, HE-MU, HE-TB
    else if (txFormat >= 5) begin
      txNumSS = txnSTS;
    end

    return txNumSS;
  endfunction : get_num_ss_func

  //---------------------------------------------------------------------------
  // function for calculating legacy rate for response frame when Rx frame is
  // in HT format mode (table 9-5 from 11n standard)
  //---------------------------------------------------------------------------
  function bit [3:0] get_legacy_rate_from_mcs(format_mod_e mod, int mcs);
    case (mcs)
      0, 32 : return decode_leg_rate(6);
      1     : return decode_leg_rate(12);
      2     : return decode_leg_rate(18);
      3     : return decode_leg_rate(24);
      4, 12 : return decode_leg_rate(36);
      5, 13 : return decode_leg_rate(48);
      6, 14 : return decode_leg_rate(54);
      7, 15 : return decode_leg_rate(54);
      8     : if (mod >= VHT)
                return decode_leg_rate(54);
              else
                return decode_leg_rate(6);
      9     : if (mod >= VHT)
                return decode_leg_rate(54);
              else
                return decode_leg_rate(12);
      10    : if (mod >= VHT)
                return decode_leg_rate(54);
              else
                return decode_leg_rate(18);
      11    : if (mod >= VHT)
                return decode_leg_rate(54);
              else
                return decode_leg_rate(24);
      default: return 0;
    endcase
  endfunction : get_legacy_rate_from_mcs

  //---------------------------------------------------------------------------
  // determine coding rate
  //---------------------------------------------------------------------------
  function real get_coding_rate(int mcs);
    case (mcs)
      0 : return 1/2.0;
      1 : return 1/2.0;
      2 : return 3/4.0;
      3 : return 1/2.0;
      4 : return 3/4.0;
      5 : return 2/3.0;
      6 : return 3/4.0;
      7 : return 5/6.0;
      8 : return 1/2.0;
      9 : return 1/2.0;
      10: return 3/4.0;
      11: return 1/2.0;
      12: return 3/4.0;
      13: return 2/3.0;
      14: return 3/4.0;
      15: return 5/6.0;
      32, 33, 34, 35: return 1/2.0;
      36, 37, 38: return 3/4.0;
      default: return 0;
    endcase
  endfunction : get_coding_rate


int NBPSCS[12] = '{
   // MCS
   // 0    1    2    3    4    5    6    7    8    9    10   11
      1,   2,   2,   4,   4,   6,   6,   6,   8,   8,   10,  10
};

int HE_NSDSHORT[2][7] = '{
   // DCM=0
   '{
      //  RU size
      //  26       52        106       242       484       996       2x996
          6,       12,       24,       60,       120,      240,      492
   },
   // DCM=1
   '{
      //  RU size
      //  26       52        106       242       484       996       2x996
          2,       6,        12,       30,       60,       120,      246
   }
};

// REF IEEE Std 802.11 - 2012 Chptr 20.6 Parameters for HT MCSs
int HESIGB_NDBPS[6] = '{
      //  MCS Index
      //  0        1         2         3         4         5
          26,      52,       78,       104,      156,      208
};
  //---------------------------------------------------------------------------
  // decode MCS index from rate
  //---------------------------------------------------------------------------
  function bit [3:0] from_mcs_idx_to_legacy_rate(int mcs);
    case (mcs)
      0 : return 4'b0000; /*   1 Mbps */
      1 : return 4'b0001; /*   2 Mbps */
      2 : return 4'b0010; /* 5.5 Mbps */
      3 : return 4'b0011; /*  11 Mbps */
      4 : return 4'b1011; /*   6 Mbps */
      5 : return 4'b1111; /*   9 Mbps */
      6 : return 4'b1010; /*  12 Mbps */
      7 : return 4'b1110; /*  18 Mbps */
      8 : return 4'b1001; /*  24 Mbps */
      9 : return 4'b1101; /*  36 Mbps */
      10: return 4'b1000; /*  48 Mbps */
      11: return 4'b1100; /*  54 Mbps */
      default : return 4'b0000; /*   1 Mbps */
    endcase
  endfunction: from_mcs_idx_to_legacy_rate

  //---------------------------------------------------------------------------
  // decode legacy rate from MCS index
  //---------------------------------------------------------------------------
  function int get_mcs_from_legacy_rate(int leg_rate);
    case (leg_rate)
      4'b0000 /*   1 Mbps */ : return 0;
      4'b0001 /*   2 Mbps */ : return 1;
      4'b0010 /* 5.5 Mbps */ : return 2;
      4'b0011 /*  11 Mbps */ : return 3;
      4'b1011 /*   6 Mbps */ : return 4;
      4'b1111 /*   9 Mbps */ : return 5;
      4'b1010 /*  12 Mbps */ : return 6;
      4'b1110 /*  18 Mbps */ : return 7;
      4'b1001 /*  24 Mbps */ : return 8;
      4'b1101 /*  36 Mbps */ : return 9;
      4'b1000 /*  48 Mbps */ : return 10;
      4'b1100 /*  54 Mbps */ : return 11;
    endcase
  endfunction: get_mcs_from_legacy_rate

  //---------------------------------------------------------------------------
  // decode from rate in Mb/s to coded value for Tx vector
  //---------------------------------------------------------------------------
  function bit [3:0] decode_leg_rate(int leg_rate);
    case (leg_rate)
       1 /*   1 Mbps */ : return 4'b0000;
       2 /*   2 Mbps */ : return 4'b0001;
       5 /* 5.5 Mbps */ : return 4'b0010;
      11 /*  11 Mbps */ : return 4'b0011;
       6 /*   6 Mbps */ : return 4'b1011;
       9 /*   9 Mbps */ : return 4'b1111;
      12 /*  12 Mbps */ : return 4'b1010;
      18 /*  18 Mbps */ : return 4'b1110;
      24 /*  24 Mbps */ : return 4'b1001;
      36 /*  36 Mbps */ : return 4'b1101;
      48 /*  48 Mbps */ : return 4'b1000;
      54 /*  54 Mbps */ : return 4'b1100;
    endcase
  endfunction: decode_leg_rate

  //---------------------------------------------------------------------------
  // from register BSS basic rate determine which rate should be used for
  // response frame
  //---------------------------------------------------------------------------
  function bit [3:0] bss_basic_rate_set(bit [3:0]  rx_rate,
                                        bit [31:0] basic_rates);

    static int rates[] = {1, 2, 5, 11, 6, 9, 12, 18, 24, 36, 48, 54};
    int index_match;

    // first determine at which index is rate of RX frame
    foreach (rates[i]) begin
      if (decode_leg_rate(rates[i]) == rx_rate) begin
        index_match = i;
        break;
      end
    end

    // find highest rate enabled in rates register
    for (int i=rates.size()-1; i>=0; i--) begin
      if (index_match >= i && basic_rates[i]) begin
        return decode_leg_rate(rates[i]);
      end
    end

    return 0;

  endfunction : bss_basic_rate_set

  //---------------------------------------------------------------------------
  // from register BSS basic MCS determine which MCS should be used for
  // response frame
  //---------------------------------------------------------------------------
  function int bss_basic_mcs_set(int          rx_mcs,
                                 format_mod_e mod,
                                 bit [31:0]   htmcs);

    if (mod inside {HT_GF, HT_MF}) begin
      // when received frame with MCS32 response frame should be MCS32
      if (rx_mcs == 32) return 32;

      for (int i=21; i>=16; i--) // MCS index range 33-38
        if (htmcs[i] && (i+17) <= rx_mcs) return (i+17);

      for (int i=15; i>=0; i--) // MCS index range 0-15
        if (htmcs[i] && i <= rx_mcs) return i;
    end
    else if (mod == VHT) begin
      //NOTE: VHTMCS register is not used
    end

    return 0;
  endfunction : bss_basic_mcs_set

  //---------------------------------------------------------------------------
  // get the index of RU type from RU allocation value
  //---------------------------------------------------------------------------
  function ru_type_e get_ru_type(bit [7:0] ru_allocation);
    if (ru_allocation[7:1] inside {[0:36]})
      return RU26;
    else if (ru_allocation[7:1] inside {[37:52]})
      return RU52;
    else if (ru_allocation[7:1] inside {[53:60]})
      return RU106;
    else if (ru_allocation[7:1] inside {[61:64]})
      return RU242;
    else if (ru_allocation[7:1] inside {[65:66]})
      return RU484;
    else if (ru_allocation[7:1] == 67)
      return RU996;
    else
      return RU2X996;
  endfunction : get_ru_type

  //--------------------------------------------------------------------
  // convert GI type to real format
  //--------------------------------------------------------------------
  function real gi_type_to_real(int gi_type);
    case (gi_type)
      0:return 0.8;
      1:return 1.6;
      default:return 3.2;
    endcase
  endfunction : gi_type_to_real

  //--------------------------------------------------------------------
  // get the STA list, based on the ru_allocation subfield
  //--------------------------------------------------------------------
  function sta_list_t get_sta_list(bit [7:0] ru_allocation, bit [2:0] ch_bw);
    int num_of_users;
    int offset;

    if (ch_bw == 1 && ru_allocation < 200)
      offset = 9;
    else if (ch_bw == 2 && ru_allocation < 208)
      offset = 28;
    else
      offset = 0;


    if (ru_allocation < 16) begin
      get_sta_list = new[9 - $countones(ru_allocation) + offset];
    end
    else if (ru_allocation inside {[16:95]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      get_sta_list = new[RU_ALLOCATION_TABLE[ru_allocation[7:3]+14].size() + offset + num_of_users];
    end
    else if (ru_allocation inside {[96:111]}) begin
      //set number of users [y1y0z1z0],
      //polynom 2^1*y1 + y0 + 1
      //polynom 2^1*z1 + z0 + 1
      num_of_users = (ru_allocation & 8'h03) + ((ru_allocation & 8'h0C) >> 2);
      get_sta_list = new[RU_ALLOCATION_TABLE[26].size() + offset + num_of_users];
    end
    else if (ru_allocation == 112) begin
      get_sta_list = new[RU_ALLOCATION_TABLE[27].size() + offset];
    end
    else if (ru_allocation inside {[192:199]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      get_sta_list = new[1 + offset + num_of_users];
    end
    else if (ru_allocation inside {[200:207]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      get_sta_list = new[1 + offset + num_of_users];
    end
    else if (ru_allocation inside {[208:215]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      get_sta_list = new[1 + offset + num_of_users];
    end

    foreach(get_sta_list[i])
      get_sta_list[i] = 2046;

  endfunction : get_sta_list

  //--------------------------------------------------------------------
  // get size of ru_allocation subfield
  //--------------------------------------------------------------------
  function int get_ru_allocation_subfield_size(bit [7:0] ru_allocation);
    int num_of_users;
    int size;

    if (ru_allocation < 16) begin
      size = 9 - $countones(ru_allocation);
    end
    else if (ru_allocation inside {[16:95]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      size = RU_ALLOCATION_TABLE[ru_allocation[7:3]+14].size() + num_of_users;
    end
    else if (ru_allocation inside {[96:111]}) begin
      //set number of users [y1y0z1z0],
      //polynom 2^1*y1 + y0 + 1
      //polynom 2^1*z1 + z0 + 1
      num_of_users = (ru_allocation & 8'h03) + ((ru_allocation & 8'h0C) >> 2);
      size = RU_ALLOCATION_TABLE[26].size() + num_of_users;
    end
    else if (ru_allocation == 112) begin
      size = RU_ALLOCATION_TABLE[27].size();
    end
    else if (ru_allocation inside {[192:199]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      size = 1 + num_of_users;
    end
    else if (ru_allocation inside {[200:207]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      size = 1 + num_of_users;
    end
    else if (ru_allocation inside {[208:215]}) begin
      //set number of users [y2y1y0],
      //polynom 2^2*y2 + 2^1*y1 + y0 + 1
      num_of_users = ru_allocation & 8'h07;
      size = 1 + num_of_users;
    end

    return size;
  endfunction : get_ru_allocation_subfield_size

 // RU allocation table, to get the RU type
 // related with Table 28-24
  int RU_ALLOCATION_TABLE[35][] = '{
/* 0  */  '{26,  26,  26,  26,  26,  26,  26,  26,  26},
/* 1  */  '{26,  26,  26,  26,  26,  26,  26,  52     },
/* 2  */  '{26,  26,  26,  26,  26,       52,  26,  26},
/* 3  */  '{26,  26,  26,  26,  26,  52,  52          },
/* 4  */  '{26,  26,  52,       26,  26,  26,  26,  26},
/* 5  */  '{26,  26,  52,       26,  26,  26,  52     },
/* 6  */  '{26,  26,  52,       26,  52,       26,  26},
/* 7  */  '{26,  26,  52,       26,  52,       52     },
/* 8  */  '{52,       26,  26,  26,  26,  26,  26,  26},
/* 9  */  '{52,       26,  26,  26,  26,  26,  52     },
/* 10 */  '{52,       26,  26,  26,  52,       26,  26},
/* 11 */  '{52,       26,  26,  26,  52,       52     },
/* 12 */  '{52,       52,       26,  26,  26,  26,  26},
/* 13 */  '{52,       52,       26,  26,  26,  52     },
/* 14 */  '{52,       52,       26,  52,       26,  26},
/* 15 */  '{52,       52,       26,  52,       52     },
/* 16 */  '{52,       52,            106              },
/* 24 */  '{106,                     52,       52     },
/* 32 */  '{26,  26,  26,  26,  26,  106              },
/* 40 */  '{26,  26,  52,       26,  106              },
/* 48 */  '{52,       26,  26,  26,  106              },
/* 56 */  '{52,       52,       26,  106              },
/* 64 */  '{106,                26,  26,  26,  26,  26},
/* 72 */  '{106,                26,  26,  26,  52     },
/* 80 */  '{106,                26,  52,       26,  26},
/* 88 */  '{106,                26,  52,       52     },
/* 96 */  '{106,                     106              },
/* 112*/  '{52,       52,            52,       52     },
/* 113*/  '{242                                       },  // 242-tone RU empty
/* 114*/  '{484                                       },  // 484-tone RU with zero User fields
/* 115*/  '{996                                       },  // 996-tone RU with zero User fields
/* 128*/  '{106,                26,  106              },
/* 192*/  '{242                                       },
/* 200*/  '{484                                       },
/* 208*/  '{996                                       }
  };

 // RU allocation table, to get the RU index
 // related ot Table 28-24 and 28-6 AX standard
  int RU_ALLOCATION_INDEX_TABLE[35][] = '{
 /* 0   */  '{0,  1,  2,  3,  4,  5,  6,  7,  8},
 /* 1   */  '{0,  1,  2,  3,  4,  5,  6,  3    },
 /* 2   */  '{0,  1,  2,  3,  4,  2,      7,  8},
 /* 3   */  '{0,  1,  2,  3,  4,  2,      3    },
 /* 4   */  '{0,  1,  1,      4,  5,  6,  7,  8},
 /* 5   */  '{0,  1,  1,      4,  5,  6,  3    },
 /* 6   */  '{0,  1,  1,      4,  2,      7,  8},
 /* 7   */  '{0,  1,  1,      4,  2,      3    },
 /* 8   */  '{0,      2,  3,  4,  5,  6,  7,  8},
 /* 9   */  '{0,      2,  3,  4,  5,  6,  3    },
 /* 10  */  '{0,      2,  3,  4,  2,      7,  8},
 /* 11  */  '{0,      2,  3,  4,  2,      3    },
 /* 12  */  '{0,      1,      4,  5,  6,  7,  8},
 /* 13  */  '{0,      1,      4,  5,  6,  3    },
 /* 14  */  '{0,      1,      4,  2,      7,  8},
 /* 15  */  '{0,      1,      4,  2,      3    },
 /* 16  */  '{0,      1,          1            },
 /* 24  */  '{0,                  2,      3    },
 /* 32  */  '{0,  1,  2,  3,  4,  1            },
 /* 40  */  '{0,  1,  1,      4,  1            },
 /* 48  */  '{0,      2,  3,  4,  1            },
 /* 56  */  '{0,      1,      4,  1            },
 /* 64  */  '{0,              4,  5,  6,  7,  8},
 /* 72  */  '{0,              4,  5,  6,  3    },
 /* 80  */  '{0,              4,  2,      7,  8},
 /* 88  */  '{0,              4,  2,      3    },
 /* 96  */  '{0,                  1            },
 /* 112 */  '{0,      1,          2,      3    },
 /* 113 */  '{0                                },
 /* 114 */  '{0                                },
 /* 115 */  '{0                                },
 /* 128 */  '{0,              4,  1            },
 /* 192 */  '{0                                },
 /* 200*/   '{0                                },
 /* 208*/   '{0                                }
  };

  //--------------------------------------------------------------------
  //  Function for creating a sta_list for a specific ru_type
  //--------------------------------------------------------------------
  function sta_list_t sta_list_by_ru_type(ru_type_e ru_type, bit [2:0] sta_id[], bit [7:0] ru_allocation);
    int   ru_temp;
    int   j;

    case(ru_type)
      RU26  : ru_temp = 26;
      RU52  : ru_temp = 52;
      RU106 : ru_temp = 106;
      RU242 : ru_temp = 242;
      RU484 : ru_temp = 484;
      RU996 : ru_temp = 996;
    endcase

    sta_list_by_ru_type = new[9-$countones(ru_allocation)];

    foreach(sta_list_by_ru_type[i])
      sta_list_by_ru_type[i] = 2046;

    foreach(sta_id[k]) begin
      foreach(RU_ALLOCATION_TABLE[ru_allocation][i]) begin
        if (ru_temp == RU_ALLOCATION_TABLE[ru_allocation][i]) begin
          if (sta_list_by_ru_type[i] == 2046) begin
            sta_list_by_ru_type[i] = sta_id[j++] + `STAID_OFFSET;
            break;
          end
        end
      end
    end

  endfunction : sta_list_by_ru_type

  //--------------------------------------------------------------------
  // Function to check what RU type is on a specific location
  //--------------------------------------------------------------------
  function ru_type_e get_ru_type_from_ru_allocation(bit [7:0] ru_allocation, int dut_location);
    int       ru_temp;
    ru_type_e ru_type;

    if (ru_allocation < 16) begin
      ru_temp = RU_ALLOCATION_TABLE[ru_allocation][dut_location];
    end
    else if (ru_allocation inside {[16:95]}) begin
      if (ru_allocation[2:0] == 0) begin
        ru_temp = RU_ALLOCATION_TABLE[ru_allocation[7:3]+14][dut_location];
      end
      else begin
        ru_temp = 106;
      end
    end
    else if (ru_allocation inside {[96:111]}) begin
      ru_temp = 106;
    end
    else if (ru_allocation == 112) begin
      ru_temp = 52;
    end
    else if (ru_allocation inside {[192:199]}) begin
      ru_temp = 242;
    end
    else if (ru_allocation inside {[200:207]}) begin
      ru_temp = 484;
    end
    else if (ru_allocation inside {[208:215]}) begin
      ru_temp = 996;
    end

    case(ru_temp)
      26  : ru_type = RU26;
      52  : ru_type = RU52;
      106 : ru_type = RU106;
      242 : ru_type = RU242;
      484 : ru_type = RU484;
      996 : ru_type = RU996;
    endcase

    return ru_type;

  endfunction : get_ru_type_from_ru_allocation

  //--------------------------------------------------------------------
  // Function get RU type for HE-SU frames
  //--------------------------------------------------------------------
  function ru_type_e get_ru_type_he_su(bit [2:0] chbw);
    case (chbw)
      2'b00: return RU242;
      2'b01: return RU484;
      2'b10: return RU996;
      default: return RU2X996;
    endcase
  endfunction : get_ru_type_he_su

  //--------------------------------------------------------------------
  // Function to get the ru_index, based on ru_allocation and user pos.
  //--------------------------------------------------------------------
  function int get_ru_index(bit [7:0] ru_allocation, int dut_location);

    if (ru_allocation < 16) begin
      return RU_ALLOCATION_INDEX_TABLE[ru_allocation][dut_location];
    end
    else if (ru_allocation inside {[16:95]}) begin
      // Search for RU index, when there is only 1 user
      if (ru_allocation[2:0] == 0) begin
        return RU_ALLOCATION_INDEX_TABLE[ru_allocation[7:3]+14][dut_location];
      end
      else begin
      // Search for the RU index in case there is multiple users
        foreach(RU_ALLOCATION_TABLE[ru_allocation[7:3]+14][i])begin
          if (RU_ALLOCATION_TABLE[ru_allocation[7:3]+14][i] == 106) begin
            return RU_ALLOCATION_INDEX_TABLE[ru_allocation[7:3]+14][i];
          end
        end
      end
    end
    else if (ru_allocation inside {[96:111]}) begin
      return RU_ALLOCATION_INDEX_TABLE[26][dut_location];
    end
    else if (ru_allocation == 112) begin
      return RU_ALLOCATION_INDEX_TABLE[27][dut_location];
    end
    else if (ru_allocation inside {[192:199]}) begin  // 242 RU tone
      return RU_ALLOCATION_INDEX_TABLE[32][dut_location];
    end
    else if (ru_allocation inside {[200:207]}) begin  // 484 RU tone
      return RU_ALLOCATION_INDEX_TABLE[33][dut_location];
    end
    else if (ru_allocation inside {[208:215]}) begin  // 996 RU tone
      return RU_ALLOCATION_INDEX_TABLE[34][dut_location];
    end

  endfunction : get_ru_index

  //--------------------------------------------------------------------
  // Function to get the primary channel value from RU allocation
  //--------------------------------------------------------------------
  function bit [1:0] get_primary_channel(bit [7:0] ru_allocation);
    bit [1:0] primary_channel;

`ifdef RW_NX_CHBW20

    if (ru_allocation[7:1] inside {[0:8],[37:40],[53:54],61})
      primary_channel = 0;
    else if (ru_allocation[7:1] inside {[9:17],[41:44],[55:56],62})
      primary_channel = 1;
    else if (ru_allocation[7:1] inside {[18:26],[44:47],[57:58],63})
      primary_channel = 2;
    else if (ru_allocation[7:1] inside {[27:36],[48:52],[59:60],64})
      primary_channel = 3;

`elsif RW_NX_CHBW4020

    if (ru_allocation[7:1] inside {[0:17],[37:44],[53:56],61,62,65})
      primary_channel = $urandom_range(0,1);
    else
      primary_channel = $urandom_range(2,3);

`elsif RW_NX_CHBW804020

    primary_channel = $urandom_range(0,3);

`endif

    return primary_channel;
  endfunction : get_primary_channel

  //-------------------------------------------------------
  // extract pattern from TC file and create queue of
  // matches found (input file should be named tc_modem.txt)
  //-------------------------------------------------------
  function string_queue_t extract_pattern_from_file(string pattern, string fname);
    int            fhandle;
    string         line;
    string         regexp;
    string_queue_t vector;

    fhandle = $fopen(fname, "r");

    if (fhandle == 0)
      `uvm_fatal("extract_pattern_from_file", $sformatf("Unable to open %s for reading", fname))
    else
      `uvm_info("extract_pattern_from_file", $sformatf("Opened %s for reading",fname), UVM_LOW)

    vector.delete();
    // --------------------------------------------------------------
    // get single parameters and create vectortor
    // --------------------------------------------------------------
    regexp = uvm_glob_to_re($sformatf("*%s*",pattern));
    do begin
      if ($fgets(line, fhandle)) begin
        // filter out paramters that are not TXV
        if (!uvm_re_match(regexp, line))
          vector.push_back(line);
      end
    end while (!$feof(fhandle));

    `uvm_info("extract_pattern_from_file",$sformatf("%s: %p",pattern,vector),UVM_HIGH)
    $fclose(fhandle);

    return vector;
  endfunction : extract_pattern_from_file

  //-------------------------------------------------------
  // search in input string queue for regex pattern
  // and return value
  //-------------------------------------------------------
  function string get_param_value(string vector[$], string pattern);
    string regexp;
    int    ret, index;
    string subgroup,bracket[2],value;
    bit    match_found;

    match_found = 0;
    regexp = uvm_glob_to_re($sformatf("*%s*",pattern));
    foreach (vector[i]) begin
      if (!uvm_re_match(regexp, vector[i])) begin
        index = i;
        match_found = 1;
        break;
      end
    end
    ret = $sscanf(vector[index],"%s %s %s %s",subgroup,bracket[0],value,bracket[1]);
    if (match_found)
      `uvm_info("get_param_value",$sformatf("%s %s %s %s",subgroup,bracket[0],value,bracket[1]),UVM_LOW)
    else
      `uvm_info("get_param_value",$sformatf("No match found for pattern %s",pattern),UVM_LOW)

    return (match_found) ? value : "";
  endfunction : get_param_value


//***********************************************
// DPI's
//***********************************************
  import "DPI-C" context ComputeTimeOnAirAC = function int ComputeTimeOnAirAC (input int length_i,    input int preType_i,    input int mcsIndex_i,
                                                                               input int shortGI_i,   input int chBW_i,       input int stbc_i,
                                                                               input int extNSS_i,    input int woPreamble_i, input int band5G_i,
                                                                               input int multiUser_i, input int nSTSTotal_i,  input int debug_i);

  import "DPI-C" context ComputeNumOfSymbols = function int ComputeNumOfSymbols (input int length_i,    input int preType_i,    input int mcsIndex_i,
                                                                                 input int shortGI_i,   input int chBW_i,       input int stbc_i,
                                                                                 input int extNSS_i,    input int woPreamble_i, input int band5G_i,
                                                                                 input int multiUser_i, input int nSTSTotal_i,  input int debug_i);

  import "DPI-C" context ComputeTimeOnAirAX = function int ComputeTimeOnAirAX (input int length_i,     input int preType_i,       input int mcsIndex_i,
                                                                               input int giType_i,     input int ruType_i,        input int heLtfType_i,
                                                                               input int numHeLtf_i,   input int dcm_i,           input int packetExtension_i,
                                                                               input int heTbLength_i, input int triggerMethod_i, input int doppler_i,
                                                                               input int mma_i,        input int stbc_i,          input int woPreamble_i,
                                                                               input HESIGB_s heSigB_i,input int debug_i);

  import "DPI-C" context GetHeTbLength      = function int GetHeTbLength (input int lsigLength_i,
                                                                          input int heLtfType_i,
                                                                          input int giType_i,
                                                                          input int numHeLtf_i,
                                                                          input int ruType_i,
                                                                          input int mcsIndex_i,
                                                                          input int dcm_i,
                                                                          input int stbc_i,
                                                                          input int doppler_i,
                                                                          input int fec_coding_i,
                                                                          input int ldpc_extra_symbol_i,
                                                                          input int pre_fec_padding_i,
                                                                          input int midamble_periodicity_i,
                                                                          input int bpe_dis_i,
                                                                          input int debug_i);

  import "DPI-C" context GenHeTbTrs = function int GenHeTbTrs (input int ruLen_i,
                                                               input int heLtfType_i,
                                                               input int giType_i,
                                                               input int packetExtension_i,
                                                               input int mcsIndex_i,
                                                               input int dcm_i,
                                                               input int numSymb_i,
                                                               input funcParamRet_e funcParamRet_i,
                                                               input int debug_i);

  import "DPI-C" context GetNSymbHESIGB = function int GetNSymbHESIGB(input int isSIGBCompression,
                                                                      input int NUserFields,
                                                                      input int NDBPS);

  export "DPI-C" tb_print = function tb_print_sv;
  export "DPI-C" tb_fire_error = function tb_fire_error_sv;

  function void tb_print_sv(input string STR);
    if(STR != "")
      `uvm_info("C function-DEBUG", $sformatf("%s",STR), UVM_LOW)
  endfunction : tb_print_sv

  function void tb_fire_error_sv(input string STR);
    `uvm_error("C function-ERROR",$sformatf("%s",STR))
  endfunction : tb_fire_error_sv

`endif// FRAME_MODEL_COMMON_SV

