//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef FRAME_MODEL_COVERAGE_SV
`define FRAME_MODEL_COVERAGE_SV

class frame_model_coverage extends uvm_subscriber #(PPDU_frame);

  `uvm_component_utils(frame_model_coverage)

  PPDU_frame              frame;
  security_wrapper_engine security;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup ppdu_kind_cg;
    option.per_instance = 1;
    option.auto_bin_max = 8;

    kind_cpt : coverpoint frame.kind;
  endgroup : ppdu_kind_cg

  covergroup mpdu_type_cg;
    option.per_instance = 1;
    option.auto_bin_max = 50;

    mpdu_type_cpt : coverpoint frame.ampdu_frame[0].mpdu_frame_type[0];
  endgroup : mpdu_type_cg

  //---------------------------------------------
  // cover security from MPDU
  //---------------------------------------------
  covergroup security_cg;
    option.per_instance = 1;
    option.auto_bin_max = 8;

    type_cpt : coverpoint security.security_type {
      bins NULL_KEY = {NULL_KEY};
      bins WEP      = {WEP     };
      bins TKIP     = {TKIP    };
      bins CCMP     = {CCMP    };
      bins GCMP     = {GCMP    };
      bins WAPI     = {WAPI    };
    }

    enc_cpt : coverpoint security.encrypted {
      bins YES = {1};
      bins NO  = {0};
    }
    dec_cpt : coverpoint security.decrypted {
      bins YES = {1};
      bins NO  = {0};
    }
    enc_type_cr : cross type_cpt, enc_cpt {
      ignore_bins irrelevant = binsof(enc_cpt.NO);
    }
    dec_type_cr : cross type_cpt, dec_cpt {
      ignore_bins irrelevant = binsof(dec_cpt.NO);
    }

    wep_iv_cpt   : coverpoint security.wep_sec.IV;
    tkip_iv_cpt  : coverpoint security.tkip_sec.IV;
    tkip_eiv_cpt : coverpoint security.tkip_sec.eIV;
    ccmp_iv_cpt  : coverpoint security.ccmp_sec.IV;
    ccmp_eiv_cpt : coverpoint security.ccmp_sec.eIV;
    wapi_key_cpt : coverpoint security.wapi_sec.key_idx;
  endgroup : security_cg

  //----------------------------------------------------------------
  // end coverage
  //----------------------------------------------------------------

  function new(string name = "frame_model_coverage", uvm_component parent = null);
    super.new(name, parent);

    ppdu_kind_cg = new();
    mpdu_type_cg = new();
    security_cg = new();
  endfunction : new

  function void write(PPDU_frame t);
    frame = t;

`ifndef STANDALONE_PHY
    if (frame.kind != NDP && frame.ampdu_frame.size() != 0) begin
      if (!frame.ampdu_frame[0].no_valid_frames) begin
        security  = frame.ampdu_frame[0].security_wrap;
        if (security != null)
          security_cg.sample();
      end
    end

    if (frame.ampdu_frame.size() != 0) begin
      mpdu_type_cg.sample();
    end
`endif
    ppdu_kind_cg.sample();

  endfunction : write

endclass : frame_model_coverage

`endif//FRAME_MODEL_COVERAGE_SV
