//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef FRAME_MODEL_PKG_SV
`define FRAME_MODEL_PKG_SV

package frame_model_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"
  import security_lib_pkg::*;
  import KeyStorageRAM_pkg::*;

  `include "frame_model_common.sv"
  `include "MAC_header.sv"
  `include "./frame_security/security_common.sv"
  `include "./frame_security/security_wrapper_engine.sv"
  `include "MPDU_frame.sv"
  // FRAME TYPES
  `include "./control_mpdu/control_MPDU_frame.sv"
  `include "./management_mpdu/management_MPDU_frame.sv"
  `include "./data_mpdu/data_MPDU_frame.sv"
  // FRAME SUBTYPES
  // ---------------------
  // MANAGEMENT SUBTYPES
  // ---------------------
  `include "./management_mpdu/ASSOCIATION_REQUEST_frame.sv"
  `include "./management_mpdu/ASSOCIATION_RESPONSE_frame.sv"
  `include "./management_mpdu/REASSOCIATION_REQUEST_frame.sv"
  `include "./management_mpdu/REASSOCIATION_RESPONSE_frame.sv"
  `include "./management_mpdu/PROBE_REQUEST_frame.sv"
  `include "./management_mpdu/PROBE_RESPONSE_frame.sv"
  `include "./management_mpdu/TIMING_ADVERTISEMENT_frame.sv"
  `include "./management_mpdu/BEACON_frame.sv"
  `include "./management_mpdu/ATIM_frame.sv"
  `include "./management_mpdu/DISASSOCIATION_frame.sv"
  `include "./management_mpdu/AUTHENTICATION_frame.sv"
  `include "./management_mpdu/DEAUTHENTICATION_frame.sv"
  `include "./management_mpdu/ACTION_frame.sv"
  `include "./management_mpdu/ACTION_NOACK_frame.sv"
  `include "./management_mpdu/BEAMFORMING_REPORT_frame.sv"
  // ---------------------
  // CONTROL SUBTYPES
  // ---------------------
  `include "./control_mpdu/BEAMFORMING_REPORT_POLL_frame.sv"
  `include "./control_mpdu/VHT_NDP_ANNOUNCEMENT_frame.sv"
  `include "./control_mpdu/HE_NDP_ANNOUNCEMENT_frame.sv"
  `include "./control_mpdu/BLOCK_ACK_REQUEST_frame.sv"
  `include "./control_mpdu/BLOCK_ACK_frame.sv"
  `include "./control_mpdu/PS_POLL_frame.sv"
  `include "./control_mpdu/RTS_frame.sv"
  `include "./control_mpdu/CTS_frame.sv"
  `include "./control_mpdu/ACK_frame.sv"
  `include "./control_mpdu/CF_END_frame.sv"
  `include "./control_mpdu/CF_END_CF_ACK_frame.sv"
  `include "./control_mpdu/CONTROL_WRAPPER_frame.sv"
  `include "./control_mpdu/TRIGGER_frame.sv"
  // ---------------------
  // DATA SUBTYPES
  // ---------------------
  `include "./data_mpdu/DATA_frame.sv"
  `include "./data_mpdu/DATA_CF_ACK_frame.sv"
  `include "./data_mpdu/DATA_CF_POLL_frame.sv"
  `include "./data_mpdu/DATA_CF_ACK_CF_POLL_frame.sv"
  `include "./data_mpdu/NULL_frame.sv"
  `include "./data_mpdu/CF_ACK_frame.sv"
  `include "./data_mpdu/CF_POLL_frame.sv"
  `include "./data_mpdu/CF_ACK_CF_POLL_frame.sv"
  `include "./data_mpdu/QOS_DATA_frame.sv"
  `include "./data_mpdu/QOS_DATA_CF_ACK_frame.sv"
  `include "./data_mpdu/QOS_DATA_CF_POLL_frame.sv"
  `include "./data_mpdu/QOS_DATA_CF_ACK_CF_POLL_frame.sv"
  `include "./data_mpdu/QOS_NULL_frame.sv"
  `include "./data_mpdu/QOS_CF_POLL_frame.sv"
  `include "./data_mpdu/QOS_CF_ACK_CF_POLL_frame.sv"
  // ---------------------
  // ERROR SUBTYPES
  // ---------------------
  `include "error_MPDU_frame.sv"
  // ----------------------
  // DELIMITERS
  // ----------------------
  `include "delimiter.sv"
  `include "blank_delimiter.sv"
  // ----------------------
  // A-MPDU, PPDU frame objects
  // ----------------------
  `include "AMPDU_frame.sv"
  `include "./ppdu_preamble/PPDU_preamble_header.sv"
  `include "./ppdu_preamble/NON_HT_PPDU.sv"
  `include "./ppdu_preamble/NON_HT_DUP_OFDM_PPDU.sv"
  `include "./ppdu_preamble/HT_MF_PPDU.sv"
  `include "./ppdu_preamble/HT_GF_PPDU.sv"
  `include "./ppdu_preamble/VHT_PPDU.sv"
  `include "./ppdu_preamble/HE_EXT_SU_PPDU.sv"
  `include "./ppdu_preamble/HE_MU_PPDU.sv"
  `include "./ppdu_preamble/HE_SU_PPDU.sv"
  `include "./ppdu_preamble/HE_TRIG_PPDU.sv"
  `include "MU_MIMO_PPDU_frame.sv"
  `include "PPDU_frame.sv"
  `include "frame_model_coverage.sv"

endpackage : frame_model_pkg

`endif// FRAME_MODEL_PKG_SV
