//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef SECURITY_COMMON_SV
`define SECURITY_COMMON_SV

  `define WEP_HEADER_FOOTER_LEN    8
  `define TKIP_HEADER_FOOTER_LEN   20
  `define CCMP_HEADER_FOOTER_LEN   24
  `define WAPI_HEADER_FOOTER_LEN   34
  `define GCMP_HEADER_FOOTER_LEN   24

  // definitions of IV, eIV, MIC, CCMP structures

  typedef struct packed {
    bit [1:0]    key_id_f;
    bit [5:0]    pad_f;
    bit [23:0]   init_vec_f;
  } wep_IV_s;

  typedef struct packed {
    bit [1:0]    key_id_f;
    bit          ext_iv_f;
    bit [4:0]    pad_f;
    bit [7:0]    tsc0_f;
    bit [7:0]    wep_seed_f;
    bit [7:0]    tsc1_f;
  } tkip_IV_s;

  typedef struct packed {
    bit [7:0]    tsc5_f;
    bit [7:0]    tsc4_f;
    bit [7:0]    tsc3_f;
    bit [7:0]    tsc2_f;
  } tkip_eIV_s;

  typedef struct packed {
    bit [1:0]    key_id_f;
    bit          ext_iv_f;
    bit [4:0]    rsvd2_f;
    bit [7:0]    rsvd1_f;
    bit [7:0]    pn1_f;
    bit [7:0]    pn0_f;
  } ccmp_IV_s;

  typedef struct packed {
    bit [7:0]    pn5_f;
    bit [7:0]    pn4_f;
    bit [7:0]    pn3_f;
    bit [7:0]    pn2_f;
  } ccmp_eIV_s;

  // definitions of security fields per secyrity type
  // NOTE: class is used instead of union because of
  // randomization issues and better constraining

  class wep_security;
    rand wep_IV_s     IV;
    rand bit [31:0]   ICV;

    constraint c_default_values {
      IV.pad_f == 0;
    }
  endclass : wep_security

  class tkip_security;
    rand tkip_IV_s    IV;
    rand tkip_eIV_s   eIV;
    rand bit [7:0]    MIC[8];
    rand bit [31:0]   ICV;

    constraint c_default_values {
      IV.pad_f == 0;
      IV.ext_iv_f == 1;
    }
  endclass : tkip_security

  class ccmp_security;
    rand ccmp_IV_s    IV;
    rand ccmp_eIV_s   eIV;
    rand bit [7:0]    MIC[];

    constraint c_default_values {
      IV.rsvd1_f == 0;
      IV.rsvd2_f == 0;
      IV.ext_iv_f == 1;
    }

    constraint c_mic_size {
      MIC.size() inside {8, 16};
    }
  endclass : ccmp_security

  class wapi_security;
    rand bit [7:0]    key_idx;
    rand bit [127:0]  PN;
    rand bit [7:0]    MIC[16];

    constraint c_key_idx {
      key_idx inside {0,1};
    }
  endclass : wapi_security

  class gcmp_security;
    // reusing CCMP IV and eIV structures
    // since they are identical
    rand ccmp_IV_s    IV;
    rand ccmp_eIV_s   eIV;
    rand bit [7:0]    MIC[];

    constraint c_default_values {
      IV.rsvd1_f == 0;
      IV.rsvd2_f == 0;
      IV.ext_iv_f == 1;
    }
    constraint c_mic_size {
      MIC.size() == 16;
    }
  endclass : gcmp_security

`endif //SECURITY_COMMON_SV
