//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Special type of ACTION_NOACK frame
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BEAMFORMING_REPORT_FRAME_SV
`define BEAMFORMING_REPORT_FRAME_SV

class BEAMFORMING_REPORT_frame extends ACTION_NOACK_frame;

  bit [7:0]             vht_he_action = 8'd0; // compressed beamforming report
  rand bit [7:0]        category;
  rand bit              is_he;
  rand vht_mimo_ctrl_s  vht_mimo_ctrl;
  rand he_mimo_ctrl_s   he_mimo_ctrl;

  `uvm_object_utils_begin(BEAMFORMING_REPORT_frame)
    `uvm_field_int(category, UVM_DEFAULT)
    `uvm_field_int(vht_he_action, UVM_DEFAULT)
    `uvm_field_int(vht_mimo_ctrl, UVM_DEFAULT | UVM_NOPRINT)
    `uvm_field_int(he_mimo_ctrl, UVM_DEFAULT | UVM_NOPRINT)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_frame_body_size {
    frame_body.size() >= 40;
    frame_body.size() <= 2320;
  }

  constraint c_mimo_ctrl {
    soft is_he == 0;

    if (is_he) {
      category == 8'd30;
      he_mimo_ctrl == 0;
    } else {
      category == 8'd21;
      vht_mimo_ctrl.channel_width_f <= 2'b11;
      vht_mimo_ctrl.nc_index_f <= vht_mimo_ctrl.nr_index_f;
      vht_mimo_ctrl.rem_feedback_sgmt_f == 0;
      vht_mimo_ctrl.first_feedback_sgmt_f == 1;
    }
  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function new (string name = "BEAMFORMING_REPORT_frame");
    super.new(name);
  endfunction

  function void custom_post_randomize();
    frame_body[0] = category;
    frame_body[1] = vht_he_action;
    if (is_he)
      {frame_body[6],
       frame_body[5],
       frame_body[4],
       frame_body[3],
       frame_body[2]} = he_mimo_ctrl;
    else
      {frame_body[4],
       frame_body[3],
       frame_body[2]} = vht_mimo_ctrl;
  endfunction : custom_post_randomize

  function void post_monitor();
    category   = frame_body[0];
    vht_he_action = frame_body[1];
    if (is_he)
      he_mimo_ctrl = {frame_body[6],
                      frame_body[5],
                      frame_body[4],
                      frame_body[3],
                      frame_body[2]};
    else
      vht_mimo_ctrl = {frame_body[4],
                       frame_body[3],
                       frame_body[2]};
  endfunction : post_monitor

  //------------------------------------------------------------
  // custom print function
  //------------------------------------------------------------
  function void do_print(uvm_printer printer);
    super.do_print(printer);

    if (is_he)
      printer.print_string("he_mimo_ctrl", $sformatf("%p",he_mimo_ctrl));
    else
      printer.print_string("vht_mimo_ctrl", $sformatf("%p",vht_mimo_ctrl));
  endfunction : do_print

endclass : BEAMFORMING_REPORT_frame

`endif// BEAMFORMING_REPORT_FRAME_SV
