//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TIMING_ADVERTISEMENT_FRAME_SV
`define TIMING_ADVERTISEMENT_FRAME_SV

class TIMING_ADVERTISEMENT_frame extends management_MPDU_frame;

  rand timestamp_t      timestamp;

  `uvm_object_utils_begin(TIMING_ADVERTISEMENT_frame)
    `uvm_field_int(timestamp, UVM_DEFAULT | UVM_NOCOMPARE)
  `uvm_object_utils_end

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_frame_body_size {
    frame_body.size() > 100;
    frame_body.size() < 500;
  }

  constraint c_MAC_header_subtype {
    MAC_header.frame_ctrl.subtype_f  == `TIMING_ADVERTISEMENT;
    MAC_header.frame_ctrl.protected_frame_f   == 1'b0;
  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function void custom_post_randomize();
    bit [63:0] tmp = timestamp;

    for (int i=0; i<($bits(timestamp_t)/8); i++) begin
      frame_body[i] = tmp[7:0];
      tmp >>= 8;
    end
  endfunction : custom_post_randomize

  function new (string name = "TIMING_ADVERTISEMENT_frame");
    super.new(name);
  endfunction

  function void post_monitor();
    super.post_monitor();

    for (int i=($bits(timestamp_t)/8)-1; i>=0; i--) begin
      timestamp <<= 8;
      timestamp[7:0] = frame_body[i];
    end
  endfunction : post_monitor

endclass : TIMING_ADVERTISEMENT_frame

`endif// TIMING_ADVERTISEMENT_FRAME_SV

