//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MANGEMENT_MPDU_FRAME_SV
`define MANGEMENT_MPDU_FRAME_SV

class management_MPDU_frame extends MPDU_frame;

  `uvm_object_utils(management_MPDU_frame)

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_frame_body_size {
    frame_body.size() >= 0;
    frame_body.size() <= 2320;
  }

  constraint c_solve_order {
    solve MAC_header.frame_ctrl before MAC_header.ht_ctrl;
  }

  constraint c_MAC_address {
    MAC_header.addr.size() == 3;
  }

  constraint c_MAC_header_frame_ctrl {
    MAC_header.frame_ctrl.type_f              == `MANAGEMENT_MPDU;
    MAC_header.frame_ctrl.to_DS_f             == 1'b0;
    MAC_header.frame_ctrl.from_DS_f           == 1'b0;
    MAC_header.frame_ctrl.more_fragments_f    == 1'b0;
    MAC_header.frame_ctrl.retry_f             == 1'b0;
    MAC_header.frame_ctrl.more_data_f         == 1'b0;
  }

  constraint c_qos_ctrl_present {
    MAC_header.qos_ctrl.size() == 0;
  }

  constraint c_ht_ctrl_present {
    if (MAC_header.frame_ctrl.order_f == 1'b1){
      MAC_header.ht_ctrl.size() == 1;
    } else {
      MAC_header.ht_ctrl.size() == 0;
    }
  }

  constraint c_seq_ctrl_present {
    MAC_header.seq_ctrl.size() == 1;
  }
  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

  function new (string name = "management_MPDU_frame");
    super.new(name);
  endfunction

endclass : management_MPDU_frame

`endif// MANGEMENT_MPDU_FRAME_SV
