//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef HE_EXT_SU_PPDU_SV
`define HE_EXT_SU_PPDU_SV

class HE_EXT_SU_PPDU extends PPDU_preamble_header;

  `uvm_object_utils(HE_EXT_SU_PPDU)

  function new (string name = "HE_EXT_SU_PPDU");
    super.new(name);
  endfunction

    //---------------------------------------------
    // constraints
    //---------------------------------------------

    constraint c_preamble_header {
      //------------------------------------------------------
      //  Constraints derived from Matlab config files
      //------------------------------------------------------
      solve ch_bw before user_header_he;

      //NOTE: Fields left random
      //  tx_pwr_level
        sounding           == 0;
        bss_color inside {[0:63]};
      //  ldpc_extra_symbol {0:1}
        if (tr == RX) {
          uplink_flag      == 0;
        }
        if (doppler == 0) midamble_periodicity == 0;
        continuous_tx      == 0;
        num_tx             == tx_num_func();
        soft ch_bw         == channel_bw_func(HE_SU);
        leg_rate           == 4'd11; // 6Mbps
  //NOTE: Preamble Type is reserved for formats other than NON-HT
        preamble_type      == 0;
        format_mod         == HE_EXT_SU;
  //NOTE: time_of_departure_requested is set to measure time of departure by the PHY
        time_dep_req       == 0;
        gi_type            != 2'b11;

  //NOTE: Set beam_change to 1, if the pre-HE-STF portion of the PPDU is differently mapped from HE-LTF1
        beam_change        == 1;
        he_ltf_type        != 2'b11;
        num_he_ltf         == 0;
        txop_duration inside { [0:127] };
        spatial_reuse_e'(spatial_reuse[0]) inside {SRP_DISALLOW,
                                                   SRP_AND_NON_SRG_OBSS_PD_PROHIBITED};

        /* HE LTF TYPE = 2'b00  - 1x HE-LTF for 3.2 us
                                  GI_TYPE = 0.8 us
                         2'b01  - 2x HE_LTF for 6.4 us
                                  GI_TYPE inside { 0.8 us : 1.6 us}
                         2'b10  - 4x HE_LTF for 12.8 us
                                  GI_TYPE inside {0.8 us : 3.2 us}*/
        if (he_ltf_type == 2'b00) {
          gi_type == 2'b00;
        } else if (he_ltf_type == 2'b01) {
          gi_type inside  {2'b00,2'b01};
        } else if (he_ltf_type == 2'b10) {
          gi_type inside {2'b00,2'b10};
          if (gi_type == 2'b00) {
            stbc == 0;
            dcm == 0;
          }
        }
        partial_aid        == 0;
        group_id           == 0;
        service            == 0;
        num_extn_ss        == 0;
        // if 1 antenna on TX side, no STBC
        if (num_tx == 0 && tr == TX) {
          stbc == 0;
        }
        // DCM is not applied to STBC
        if (stbc == 1){
          dcm == 0;
        }
        foreach (user_header_he[i]) {
          user_header_he[i].dut_location_f == 0;
          user_header_he[i].user_position_f == 0;
          user_header_he[i].staid_f == 0;
          user_header_he[i].mcs_f <= MAX_MCS; //RTL constraint
          if (tr == TX) {
          `ifndef RW_NX_LDPC_ENC
            user_header_he[i].mcs_f inside { [0:9] };
            user_header_he[i].fec_coding_f == 0;
          `else
            // constraint MCS
            if (user_header_he[i].fec_coding_f == 1)
              user_header_he[i].mcs_f inside { [0:11] };
            else
              user_header_he[i].mcs_f inside { [0:9] };
          `endif
          } else if (tr == RX) {
          `ifndef RW_NX_LDPC_DEC
            user_header_he[i].mcs_f inside { [0:9] };
            user_header_he[i].fec_coding_f == 0;
          `else
            // constraint MCS
            if (user_header_he[i].fec_coding_f == 1)
              user_header_he[i].mcs_f inside { [0:11] };
            else
              user_header_he[i].mcs_f inside { [0:9] };
          `endif
          }

          // set PE duration to 16us
          user_header_he[i].pkt_ext_f == 3'b100;
          if (beamformed) {
            user_header_he[i].smm_index_f inside { [8'h80:8'hff] };
          } else {
            user_header_he[i].smm_index_f == 0;
          }
          user_header_he[i].nss_f inside { [0:3] };
          if (user_header_he[i].mcs_f inside {0,1,3,4}) {
            dcm inside { [0:1] };
          } else {
            dcm == 0;
          }
          // constraint FEC to LDPC in CHBW40 and CHBW80
          if (ch_bw >= 3'b001) {
            user_header_he[i].fec_coding_f == 1;
          }
        }
      ru_allocation == 0;
      //-----------------------------------------------------
      //  Constraints based on the RTL configuration
      //-----------------------------------------------------
      // Indicates which antennas to be used for transmission
      `ifdef RW_TXRX_1X1
        antenna_set      == 1;
      `elsif RW_TXRX_2X2
        antenna_set      == 3;
      `endif

      `ifdef RW_NX_1024QAM_EN
        MAX_MCS == 11;
      `elsif RW_NX_256QAM_EN
        MAX_MCS == 9;
      `else
        MAX_MCS == 7;
      `endif

      foreach (user_header_he[i]) {
        soft user_header_he[i].nss_f == 0;
      }
      beamformed         == 0;
    }

    //---------------------------------------------
    // end of constraints
    //---------------------------------------------


endclass : HE_EXT_SU_PPDU

`endif //HE_EXT_SU_PPDU_SV
