//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef HE_MU_PPDU_SV
`define HE_MU_PPDU_SV

class HE_MU_PPDU extends PPDU_preamble_header;

  rand int              nsts_total;
  rand int unsigned     uniq_dut_loc[$];
       int unsigned     ru_restrictions[$];
  rand bit              ru_allocation_96;
  // users inside secondary channel which will be used only if
  // ru_with_more_users = 1, on WLAN tests
  rand int unsigned     uniq_dut_loc_sec[];

  `uvm_object_utils_begin(HE_MU_PPDU)
    `uvm_field_int(nsts_total, UVM_DEFAULT | UVM_NOCOMPARE | UVM_NOCOPY)
  `uvm_object_utils_end

  function new (string name = "HE_MU_PPDU");
    super.new(name);
  endfunction

    //---------------------------------------------
    // constraints
    //---------------------------------------------
    constraint c_dut_loc {
      solve ru_allocation before uniq_dut_loc;

      if (user_header_he.size() == 1 || ru_with_more_users)
        uniq_dut_loc.size() == get_ru_allocation_subfield_size(ru_allocation);
      else
        uniq_dut_loc.size() == user_header_he.size();

      unique {uniq_dut_loc};
      foreach (uniq_dut_loc[i]) {
        uniq_dut_loc[i] < uniq_dut_loc.size();
      }
    }

    constraint c_secondary_users {
      // create additional users that will be inside secondary channel
      if (ru_with_more_users && ch_bw > 3'b000) {
        user_header_he_sec.size() inside {[2:4]};
        uniq_dut_loc_sec.size() == user_header_he_sec.size();
        unique {uniq_dut_loc_sec};
        foreach (uniq_dut_loc_sec[i])
          uniq_dut_loc_sec[i] < 9;
       } else {
        user_header_he_sec.size() == 0;
        uniq_dut_loc_sec.size() == 0;
       }
    }

    constraint c_preamble_header {
      solve user_header_he before nsts_total;
      solve nsts_total before num_he_ltf;
      //------------------------------------------------------
      //  Constraints derived from Matlab config files
      //------------------------------------------------------

  //NOTE: Fields left random
      //  tx_pwr_level
        smoothing          == 0;
        sounding           == 0;
        bss_color          == 1;
        // The LDPC_EXTRA_SYMBOL parameter is not present
        // if the RU Allocation subfield indicates less
        // than a 484-tone RU; otherwise set to 1
        if (ru_allocation < 200)
          ldpc_extra_symbol == 0;
        else
          ldpc_extra_symbol == 1;

        uplink_flag        == 0;
        if (user_header_he.size() > 1) {
          dcm  == 0; //DCM is not applied in MUMIMO
          stbc == 0; //no STBC in MUMIMO
        }
        if (doppler == 0) midamble_periodicity == 0;
        continuous_tx      == 0;
        num_tx             == tx_num_func();
        if (tr == TX) {
          soft ch_bw       == channel_bw_func(HE_MU);
        } else {
`ifdef RW_NX_CHBW4020
          // TODO: Remove this when RTL and Matlab supports 80MHz frame
          // in the 40MHz STA configuration
          ch_bw            inside {3'b000,3'b001};
`else
          ch_bw            inside {3'b000,3'b001, 3'b010};
`endif

`ifndef STANDALONE_PHY
          ch_bw            != 3'b010;
`endif//STANDALONE_PHY
        }
        leg_rate           == 4'd11; // 6Mbps
  //NOTE: Preamble Type is reserved for formats other than NON-HT
        preamble_type      == 0;
        format_mod         == HE_MU;
  //NOTE: time_of_departure_requested is set to measure time of departure by the PHY
        time_dep_req       == 0;
        gi_type            != 2'b11;

  //NOTE: Set beam_change to 1, if the pre-HE-STF portion of the PPDU is differently mapped from HE-LTF1
        beam_change        == 0;

        // TODO: remove this constraint when RTL supports 80MHz, with
        // different than HE-LTF-4X
        if (ch_bw == 3'b010)
          he_ltf_type == 2'b10;
        else
          he_ltf_type        inside {2'b01,2'b10};

        // calculate total number of NSTS
        nsts_total == user_header_he.size() - 1 + stbc;
        // encoding of NHeLTF
        // 0 - 1x HE-LTF
        // 1 - 2x HE-LTF
        // 3 - 4x HE-LTF
        // 5 - 6x HE-LTF
        // 7 - 8x HE-LTF
        num_he_ltf >= nsts_total;
        if (doppler) {
          num_he_ltf inside {0, 1, 3};
        } else {
          num_he_ltf inside {0, 1, 3};
        }
        txop_duration inside { [0:127] };
        spatial_reuse_e'(spatial_reuse[0]) == SRP_DISALLOW;

        /* HE LTF TYPE = 2'b00  - 1x HE-LTF for 3.2 us
                                GI_TYPE = 0.8 us
                       2'b01  - 2x HE_LTF for 6.4 us
                                GI_TYPE inside { 0.8 us : 1.6 us}
                       2'b10  - 4x HE_LTF for 12.8 us
                                GI_TYPE = 3.2 us */
        if (he_ltf_type == 2'b01) {
          gi_type inside  {2'b00,2'b01};
        } else if (he_ltf_type == 2'b10) {
          gi_type == 2'b10;
        }
        partial_aid        == 0;
        group_id           == 0;
        service            == 0;
        num_extn_ss        == 0;
        // if 1 antenna on TX side, no STBC
        if (num_tx == 0 && tr == TX) {
          stbc == 0;
        }
        n_user             == user_header_he.size();
        // DCM is not applied to STBC
        if (stbc == 1){
          dcm == 0;
        }
        //-----------------------------------------------------------------
        // RU ALLOCATION constraints
        //-----------------------------------------------------------------
        // maximum RU242 in CHBW20
        if (ch_bw == 2'b00) {
          ru_allocation < 200;
        // maximum RU484 in CHBW40
        } else if (ch_bw == 2'b01) {
        `ifdef RW_NX_CHBW20
          ru_allocation < 192;
        `else
          ru_allocation < 208;
        `endif
        // maximum RU996 in CHBW80
        } else if (ch_bw == 2'b10) {
        `ifdef RW_NX_CHBW20
          ru_allocation < 192;
        `elsif RW_NX_CHBW4020
          ru_allocation < 208;
        `else
          ru_allocation < 216;
        `endif
        }

        if (ru_with_more_users) {
          ru_allocation inside {[0:15],16,24,32,40,48,56,64,72,80,88};
        } else if (user_header_he.size() == 1) {
          // RU allocation, when there is only one user
          ru_allocation inside {[0:15],16,24,32,40,48,56,64,72,80,88,96,112,192,200,208};
        } else {
          // RU allocation, when there is MU
          ru_allocation inside {[16:111],[192:199],[200:207],[208:215]};

          if (ru_allocation[7:3] inside {[2:11],24,25,26}) {
            //set number of users [y2y1y0],
            //polynom 2^2*y2 + 2^1*y1 + y0 + 1
            ru_allocation[2:0] == (user_header_he.size()-1);
          } else {
            //set number of users [y1y0z1z0],
            //polynom 2^1*y1 + y0 + 1
            //polynom 2^1*z1 + z0 + 1
            if (ru_allocation_96 == 0) {
              ru_allocation[3:2] == (user_header_he.size()-1);
              ru_allocation[1:0] == 0;
            } else {
              ru_allocation[1:0] == (user_header_he.size()-1);
              ru_allocation[3:2] == 0;
            }
          }
        }

        foreach (user_header_he[i]) {
          user_header_he[i].user_position_f == 0;
          user_header_he[i].staid_f == (`STAID_OFFSET+2+i); //aligned with MDM
          user_header_he[i].mcs_f <= MAX_MCS; //RTL constraint
          if (tr == TX) {
          `ifndef RW_NX_LDPC_ENC
            user_header_he[i].mcs_f inside { [0:9] };
            user_header_he[i].fec_coding_f == 0;
          `else
            // constraint FEC to LDPC RU > 242
            if (ru_allocation[7:3] > 5'd24) {
              user_header_he[i].fec_coding_f == 1;
            }
            // constraint MCS
            if (user_header_he[i].fec_coding_f == 1 && ru_allocation[7:3] >= 5'd24)
              user_header_he[i].mcs_f inside { [0:11] };
            else
              user_header_he[i].mcs_f inside { [0:9] };
          `endif
          } else if (tr == RX) {
          `ifndef RW_NX_LDPC_DEC
            user_header_he[i].mcs_f inside { [0:9] };
            user_header_he[i].fec_coding_f == 0;
          `else
            // constraint FEC to LDPC RU > 242
            if (ru_allocation[7:3] > 5'd24) {
              user_header_he[i].fec_coding_f == 1;
            }
            // constraint MCS
            if (user_header_he[i].fec_coding_f == 1 && ru_allocation[7:3] >= 5'd24)
              user_header_he[i].mcs_f inside { [0:11] };
            else
              user_header_he[i].mcs_f inside { [0:9] };
          `endif
          }

          // set PE duration to 16us
          user_header_he[i].pkt_ext_f == 3'b100;
          if (beamformed) {
            user_header_he[i].smm_index_f inside { [8'h80:8'hff] };
          } else {
            user_header_he[i].smm_index_f == 0;
          }
          user_header_he[i].nss_f inside { [0:3] };
          if (user_header_he[i].mcs_f inside {0,1,3,4}) {
            dcm inside { [0:1] };
          } else {
            dcm == 0;
          }
        }
        // HESIGB fields
        if (   (ru_allocation inside {[192:199]} && ch_bw == 2'b00)
            || (ru_allocation inside {[200:207]} && ch_bw == 2'b01)
            || (ru_allocation inside {[208:215]} && ch_bw == 2'b10)
           )
        {
          sig_b_comp_mode == 1;
        } else {
          sig_b_comp_mode == 0;
        }

        dcm_sig_b inside {0,1};
        if (dcm_sig_b == 0){
          mcs_sig_b inside {[0:5]};
        }
        else {
          mcs_sig_b inside {0,1,3,4};
        }

        //-----------------------------------------------------
        // there is limitation on HESIGB to not have more than 16 symbols
        //-----------------------------------------------------
        if (ch_bw == 2'b00 && get_ru_allocation_subfield_size(ru_allocation) > 7 && dcm_sig_b == 1)
          mcs_sig_b != 0;
        else if (ch_bw == 2'b01 && dcm_sig_b == 1)
          mcs_sig_b > 1;
        else if (ch_bw == 2'b01 && dcm_sig_b == 0 && get_ru_allocation_subfield_size(ru_allocation) > 6)
          mcs_sig_b > 0;
        else if (ch_bw == 2'b10 && dcm_sig_b == 1 && get_ru_allocation_subfield_size(ru_allocation) >= 3)
          mcs_sig_b >= 3;
        else if (ch_bw == 2'b10 && dcm_sig_b == 0 && get_ru_allocation_subfield_size(ru_allocation) >= 3)
          mcs_sig_b > 1;

        //-----------------------------------------------------
        // constraint secondary users if present
        //-----------------------------------------------------
        foreach (user_header_he_sec[i]) {
          user_header_he_sec[i].user_position_f == 0;
          user_header_he_sec[i].staid_f == (`STAID_OFFSET+6+i); //aligned with MDM
          user_header_he_sec[i].mcs_f <= MAX_MCS; //RTL constraint
          user_header_he_sec[i].pkt_ext_f == 3'b100;
          user_header_he_sec[i].fec_coding_f == 0;
          user_header_he_sec[i].dut_location_f == uniq_dut_loc_sec[i];
          user_header_he_sec[i].he_length_f == 100;
          user_header_he_sec[i].smm_index_f == 0;
          user_header_he_sec[i].nss_f == 0;
        }

        //-----------------------------------------------------
        //  Constraints based on the RTL configuration
        //-----------------------------------------------------
        // Indicates which antennas to be used for transmission
        `ifdef RW_TXRX_1X1
          antenna_set      == 1;
        `elsif RW_TXRX_2X2
          antenna_set      == 3;
        `endif

        `ifdef RW_NX_1024QAM_EN
          MAX_MCS == 11;
        `elsif RW_NX_256QAM_EN
          MAX_MCS == 9;
        `else
          MAX_MCS == 7;
        `endif

        foreach (user_header_he[i]) {
          user_header_he[i].nss_f == 0;
        }
        beamformed         == 0;

    }

    //---------------------------------------------
    // end of constraints
    //---------------------------------------------

    function void post_randomize();
      int sta_position;
      int to_remove[$];

      super.post_randomize();

      //find available sta position for HE MUMIMO
      sta_position = 0;
      if (user_header_he.size() > 1 && ru_with_more_users == 0) begin
        if (ru_allocation inside {[96:111]}) begin
          sta_position = ru_allocation_96;
        end
        else begin
          foreach (RU_ALLOCATION_TABLE[ru_allocation[7:3] + 14][i]) begin
            if (RU_ALLOCATION_TABLE[ru_allocation[7:3] + 14][i] inside {106, 242, 484})
              break;
            else
              sta_position++;
          end//foreach
        end//else
      end

`ifdef RW_NX_CHBW20
      // RU restriction for 20MHz
      for (int i=0; i<get_ru_allocation_subfield_size(ru_allocation); i++) begin
        if (ch_bw == 3'b010) begin
          // RU26
          if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU26) begin
            if (primary_channel == 0 && get_ru_index(ru_allocation,i) == 4) // 26-tone RU5
              ru_restrictions.push_front(i);
            else if (primary_channel == 1 && (get_ru_index(ru_allocation,i)+9) inside {9,13}) // 26-tone RU10,RU14
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation,i)+19) inside {23,27}) // 26-tone RU24,RU28
              ru_restrictions.push_front(i);
            else if ((get_ru_index(ru_allocation,i)+28) == 32) // 26-tone RU33
              ru_restrictions.push_front(i);
          // RU52
          end else if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU52) begin
            if (primary_channel == 1 && (get_ru_index(ru_allocation, i)+4) == 4) // 52-tone RU5
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation, i)+8) == 11) // 52-tone RU12
              ru_restrictions.push_front(i);
          // RU106
          end else if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU106) begin
            if (primary_channel == 1 && (get_ru_index(ru_allocation, i)+2) == 2) // 106-tone RU3
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation, i)+4) == 5) // 106-tone RU6
              ru_restrictions.push_front(i);
          end
        end else if (ch_bw == 3'b001) begin
          // RU26
          if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU26) begin
            if (primary_channel == 0 && get_ru_index(ru_allocation,i) == 4) // 26-tone RU5
              ru_restrictions.push_front(i);
            else if (primary_channel == 1 && (get_ru_index(ru_allocation,i)+9) == 13) // 26-tone RU14
              ru_restrictions.push_front(i);
          end
        end
      end//for

      // when RU is in restricted part remove it as potentional index
      if (user_header_he.size() == 1 || ru_with_more_users) begin
        foreach (uniq_dut_loc[i])
          if (uniq_dut_loc[i] inside {ru_restrictions})
            to_remove.push_front(i);
        foreach (to_remove[i])
          uniq_dut_loc.delete(to_remove[i]);
      end//if
`elsif RW_NX_CHBW4020

      if (ch_bw == 3'b010) begin
        // Ru restriction for 40MHz
        for (int i=0; i<get_ru_allocation_subfield_size(ru_allocation); i++) begin
          // RU26
          if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU26) begin
            if (primary_channel == 1 && (get_ru_index(ru_allocation,i)+9) == 9) // 26-tone RU10
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation,i)+19) == 27) // 26-tone RU28
              ru_restrictions.push_front(i);
          // RU52
          end else if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU52) begin
            if (primary_channel == 1 && (get_ru_index(ru_allocation, i)+4) == 4) // 52-tone RU5
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation, i)+8) == 11) // 52-tone RU12
              ru_restrictions.push_front(i);
          // RU106
          end else if (get_ru_type_from_ru_allocation(ru_allocation,i) == RU106) begin
            if (primary_channel == 1 && (get_ru_index(ru_allocation, i)+2) == 2) // 106-tone RU3
              ru_restrictions.push_front(i);
            else if (primary_channel == 2 && (get_ru_index(ru_allocation, i)+4) == 5) // 106-tone RU6
              ru_restrictions.push_front(i);
          end
        end
      end

      // when RU is in restricted part remove it as potentional index
      if (user_header_he.size() == 1 || ru_with_more_users) begin
        foreach (uniq_dut_loc[i])
          if (uniq_dut_loc[i] inside {ru_restrictions})
            to_remove.push_front(i);
        foreach (to_remove[i])
          uniq_dut_loc.delete(to_remove[i]);
      end//if
`endif//RW_NX_CHBW40

      // determine DUT location inside RU allocation
      foreach (user_header_he[i])
        user_header_he[i].dut_location_f = uniq_dut_loc[i] + sta_position;

      // determine RU type of the receiving user
      ru_type = get_ru_type_from_ru_allocation(ru_allocation,
                                               user_header_he[mu_mimo_userid].dut_location_f);

`ifdef RW_NX_CHBW20
      // change primary index in case of MUMIMO and 20mhz restrictions
      if (user_header_he.size() > 1 && ru_with_more_users == 0 && ch_bw == 3'b010) begin
        if (   primary_channel == 1
            && (ru_allocation inside {[24:31],[64:95]} || (ru_allocation inside {[104:111]} && !ru_allocation_96))
           ) begin

          randcase
            1: primary_channel = 0;
            1: primary_channel = 2;
            1: primary_channel = 3;
          endcase
        end
        else if (   primary_channel == 2
                 && (ru_allocation inside {[16:23],[32:63]} || (ru_allocation inside {[96:103]} && ru_allocation_96))
                ) begin
          randcase
            1: primary_channel = 0;
            1: primary_channel = 1;
            1: primary_channel = 3;
          endcase
        end
      end
`endif

    endfunction : post_randomize

endclass : HE_MU_PPDU

`endif //HE_MU_PPDU_SV
