//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef HT_GF_PPDU_SV
`define HT_GF_PPDU_SV

class HT_GF_PPDU extends PPDU_preamble_header;

  `uvm_object_utils(HT_GF_PPDU)

  function new (string name = "HT_GF_PPDU");
    super.new(name);
  endfunction

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_preamble_header {
      solve ch_bw before user_header;
//NOTE: tx_pwr_level  - leave random in all modes
      dyn_bw             == 0;
      if (sounding) {
      // Sounding frames are not smoothed; Tx BF frames are not smoothed
        smoothing        == 0;
      } else {
        smoothing        == 1;
      }
      continuous_tx     == 0;
      soft ch_bw        == channel_bw_func(HT_GF);
      `ifdef RW_TXRX_1X1
        antenna_set      == 1;
      `elsif RW_TXRX_2X2
        antenna_set      == 3;
      `endif
      preamble_type      == 0;
      format_mod         == HT_GF;
      leg_length         == 0;
      leg_rate           == 4'd11; // 6Mbps
//NOTE: aggregated - leave it random
      doze_not_allowed   == 0;
      num_tx             == tx_num_func();
      beamformed         == 0;
      partial_aid        == 0;
      group_id           == 0;
      foreach (user_header[i]) {
        `ifdef RW_TXRX_1X1
          if (ch_bw == 2'b00) {
            user_header[i].mcs_f inside { [0:7] };
          } else {
            user_header[i].mcs_f inside { [0:7], 32 };
          }
          user_header[i].num_sts_f == 0;
          stbc == 0;
        `elsif RW_TXRX_2X2
          if (ch_bw == 2'b00) {
            user_header[i].mcs_f inside { [0:15] };
          } else {
            user_header[i].mcs_f inside { [0:15], 32 };
          }

          if (user_header[i].mcs_f > 7)  {
            // mcs = 32 can only occur for 40MHz BW and Nss=1
            user_header[i].num_sts_f == 0;
          } else {
            user_header[i].num_sts_f inside { [0:1] };
          }

          if ((user_header[i].mcs_f <= 'd7)  && (user_header[i].num_sts_f == 'd1)) {
            stbc == 1;
          } else {
            stbc == 0;
          }

        `endif

        // BCC/LDPC
        `ifndef RW_NX_LDPC_ENC
          user_header[i].fec_coding_f == 0;
        `endif

        //FIXME check below
        if (user_header[i].num_sts_f == 0) {
          // short GI is not used in HT-greenfield format with one spatial stream
          gi_type[0] == 0;
        }

        user_header[i].user_position_f == 0;
        user_header[i].smm_index_f == 0;

        if (!sounding) {
          num_extn_ss == 0;
        } else {
          (num_extn_ss+user_header[i].num_sts_f) < num_tx;
        }
      }

  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

endclass : HT_GF_PPDU

`endif //HT_GF_PPDU_SV
