//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef NON_HT_DUP_OFDM_PPDU_SV
`define NON_HT_DUP_OFDM_PPDU_SV

class NON_HT_DUP_OFDM_PPDU extends PPDU_preamble_header;

  `uvm_object_utils(NON_HT_DUP_OFDM_PPDU)

  function new (string name = "NON_HT_DUP_OFDM_PPDU");
    super.new(name);
  endfunction

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_preamble_header {
//NOTE: tx_pwr_level  - leave random in all modes
      dyn_bw             == 0;
      sounding           == 0;
      smoothing          == 0; // smoothing is not present in NON_HT_DUP_OFDM PPDU
      continuous_tx     == 0;
      ch_bw              == channel_bw_func(NON_HT_DUP_OFDM);
      `ifdef RW_TXRX_1X1
        antenna_set      == 1;
      `elsif RW_TXRX_2X2
        antenna_set      == 3;
      `endif
      preamble_type == 0;
      format_mod         == NON_HT_DUP_OFDM;
      num_extn_ss        == 0;
//NOTE  leg_length - calculated in post randomization
      // Standard 802.11-2012, table 18.6, page 1595 for OFDM
      // Please note this table lists RATE field from LSB to MSB !
      //     leg_rate
      //   | 4'b1011 |  6 Mbps    |
      //   | 4'b1111 |  9 Mbps    |
      //   | 4'b1010 | 12 Mbps    |
      //   | 4'b1110 | 18 Mbps    |
      //   | 4'b1001 | 24 Mbps    |
      //   | 4'b1101 | 36 Mbps    |
      //   | 4'b1000 | 48 Mbps    |
      //   | 4'b1100 | 54 Mbps    |

      leg_rate[3]        == 1'b1;
      doze_not_allowed   == 0;
      gi_type            == 0;
      num_tx             == tx_num_func();
      stbc               == 0;
      beamformed         == 0;
      partial_aid        == 0;
      group_id           == 0;
      first_user         == 0;
      foreach (user_header[i]) {
        user_header[i] == 0;
      }
  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

endclass : NON_HT_DUP_OFDM_PPDU

`endif //NON_HT_DUP_OFDM_PPDU_SV
