//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef NON_HT_PPDU_SV
`define NON_HT_PPDU_SV

class NON_HT_PPDU extends PPDU_preamble_header;

  `uvm_object_utils(NON_HT_PPDU)

  function new (string name = "NON_HT_PPDU");
    super.new(name);
  endfunction

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_preamble_header {
      solve leg_rate before preamble_type;
//NOTE: tx_pwr_level  - leave random in all modes
      sounding           == 0;
      smoothing          == 0; // smoothing is not present in NON_HT PPDU
      continuous_tx     == 0;
      ch_bw              == channel_bw_func(NON_HT);
      `ifdef RW_TXRX_1X1
        antenna_set      == 1;
      `elsif RW_TXRX_2X2
        antenna_set      == 3;
      `endif

      // If leg_rate = 0, preamble_type must be 1.
      // If legacy rate >= 8, preamble_type must be 0.
      // For leg_rate inside [1,3] preamble_type can be 0 or 1
      if (leg_rate == 0){
        preamble_type == 1;
      } else if (leg_rate >= 8) {
        preamble_type == 0;
      }

      format_mod         == NON_HT;
      num_extn_ss        == 0;
//NOTE  leg_length - calculated in post randomization
      //   leg_rate
      // Standard 802.11-2012, chapter 17.2.3.4., page 1539 for HR/DSSS
      // Please note this chapter lists SIGNAL field from MSB to LSB !
      // Standard 802.11-2012, table 18.6, page 1595 for OFDM
      // Please note this table lists RATE field from LSB to MSB !
      // | 4'b0000 |     1 Mbps    |
      // | 4'b0001 |     2 Mbps    |
      // | 4'b0010 |   5.5 Mbps    |
      // | 4'b0011 |    11 Mbps    |
      // | 4'b1011 |     6 Mbps    |
      // | 4'b1111 |     9 Mbps    |
      // | 4'b1010 |    12 Mbps    |
      // | 4'b1110 |    18 Mbps    |
      // | 4'b1001 |    24 Mbps    |
      // | 4'b1101 |    36 Mbps    |
      // | 4'b1000 |    48 Mbps    |
      // | 4'b1100 |    54 Mbps    |
      soft leg_rate dist {
        [0:3]  := 5,  // 5% DSSS
        [8:15] := 95  // 95% OFDM
      };
      if (leg_rate inside {[0:3]})
        trigger_responding == 0;
      doze_not_allowed   == 0;
      gi_type            == 0;
      num_tx             == tx_num_func();
      stbc               == 0;
      beamformed         == 0;
      partial_aid        == 0;
      group_id           == 0;
      first_user         == 0;
      foreach (user_header[i]) {
        user_header[i] == 0;
      }
  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

endclass : NON_HT_PPDU

`endif //NON_HT_PPDU_SV
