//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : container class for PPDU preamble and header
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef VHT_PPDU_SV
`define VHT_PPDU_SV

class VHT_PPDU extends PPDU_preamble_header;

  rand bit [6:0]    smm_index[`MAX_USER_NUM]; // used in MU-MIMO Tx
  rand bit [1:0]    user_pos[`MAX_USER_NUM];  // used in MU-MIMO Tx

  `uvm_object_utils(VHT_PPDU)

  function new (string name = "VHT_PPDU");
    super.new(name);
  endfunction

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_preamble_header {
      solve ch_bw before user_header;
      solve stbc  before user_header;
      solve user_header before group_id;
      solve user_header before partial_aid;
      solve smm_index before user_header;
      solve user_pos before user_header;
      solve tr before user_pos;

      // randomize unique values SMM index array
      unique {smm_index};

      // randomize user position array
      if (tr == TX) {
        user_pos[0] < user_pos[1];
      } else {
        foreach (user_pos[i])
          user_pos[i] == i;
      }

//NOTE: tx_pwr_level  - leave random in all modes
      dyn_bw             == 0;
      sounding           == 0; // sounding is not present in VHT *XVECTOR
      // If smoothing is 0, the frame is considered to be beamformed
      // If smoothing is 1, the frame is considered not beamformed
      smoothing == !beamformed;
      continuous_tx      == 0;
      soft ch_bw         == channel_bw_func(VHT);
      `ifdef RW_TXRX_1X1
        antenna_set      == 1;
      `elsif RW_TXRX_2X2
        antenna_set      == 3;
      `endif
      preamble_type      == 0;
      format_mod         == VHT;
      num_extn_ss        == 0;
//NOTE  leg_length - calculated in post randomization
      leg_rate           == 4'd11; // 6Mbps
      doze_not_allowed   == 0;
      num_tx             == tx_num_func();
      // when transmiting NDP frame, aggregated will be set to 0
      // because there is no MPDUs (no aggregation)
      if (is_ndp && tr == TX) {
        aggregated == 0;
      } else {
        aggregated == 1;
      }

      if (group_id inside {0,63}) {
        partial_aid inside {[0:511]};
      } else {
        partial_aid == 0;
      }

      if (user_header.size() > 1) {
        group_id inside {[1:62]};
        stbc == 0;
      } else {
        stbc inside {[0:1]};
        group_id inside {0, 63};
      }

      n_user == user_header.size();

      foreach (user_header[i]) {
        `ifdef RW_NX_DERIV_EQU_VHT
          // QAM256 implemented
          if (ch_bw == 0) {
            user_header[i].mcs_f inside { [0:8] };
          } else {
            user_header[i].mcs_f inside { [0:9] };
          }
        `else
          // QAM256 not implemented
          user_header[i].mcs_f inside { [0:7] };
        `endif

        if (user_header.size() > 1 || beamformed) {
          user_header[i].smm_index_f[6:0] == smm_index[i];
          // force MSB to 1
          user_header[i].smm_index_f[7] == 1;
        `ifdef STANDALONE_PHY
          user_header[i].user_position_f == user_pos[i];
        `else
          user_header[i].user_position_f == i;
        `endif
        } else {
          user_header[i].user_position_f == 0;
          user_header[i].smm_index_f == 0;
        }

        if (tr == TX) {
        `ifdef RW_TXRX_1X1
          stbc == 0;
          user_header[i].num_sts_f == 0;
        `elsif RW_TXRX_2X2
          if (user_header.size() > 1 || beamformed) {
            stbc == 0;
          }

          if (stbc) {
            user_header[i].num_sts_f == 1;
          } else {
            if (user_header.size() > 1 || beamformed) {
              user_header[i].num_sts_f == 0;
            } else {
              user_header[i].num_sts_f <= 1;
            }
          }
        `endif
        } else if (tr == RX) { // RX
          // when NDP frame Nsts is > 1
          if (is_ndp) {
            user_header[i].num_sts_f > 0;
          } else if (stbc) {
            user_header[i].num_sts_f == 1;
          } else {
            user_header[i].num_sts_f == 0;
          }
        }

        if (tr == TX) {
        `ifndef RW_NX_LDPC_ENC
            user_header[i].fec_coding_f == 0;
        `endif
          } else if (tr == RX) {
        `ifndef RW_NX_LDPC_DEC
            user_header[i].fec_coding_f == 0;
        `endif
        }
      }
  }

  //---------------------------------------------
  // end of constraints
  //---------------------------------------------

endclass : VHT_PPDU

`endif //VHT_PPDU_SV
