//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef KEYSTORAGERAM_COMMON_SV
`define KEYSTORAGERAM_COMMON_SV

`ifdef RW_CONFIG_6VAP_40STA
  `define KEYRAM_SIZE                64
  `define NUM_OF_VAPS                 6
`elsif RW_CONFIG_6VAP_104STA
  `define KEYRAM_SIZE               128
  `define NUM_OF_VAPS                 6
`elsif RW_CONFIG_4VAP_128STA
  `define KEYRAM_SIZE               144
  `define NUM_OF_VAPS                 4
`else
  `define KEYRAM_SIZE                64
  `define NUM_OF_VAPS                 6
`endif

//determine which cipher types are enabled in RTL
`ifdef RW_WAPI_EN
  `ifdef RW_GCMP_EN
    `define RW_ALL_CIPHER_EN
  `endif
`endif

  `define KEYRAM_VLAN_START_ADDR     0
  `define KEYRAM_VLAN_END_ADDR       (`NUM_OF_VAPS*`DEFAULT_KEY_CNT-1)
  `define KEYRAM_DEV_START_ADDR      (`NUM_OF_VAPS*`DEFAULT_KEY_CNT)
  `define KEYRAM_DEV_END_ADDR        (`KEYRAM_SIZE-1)
  `define DEFAULT_KEY_CNT            4

  typedef enum bit [2:0] {
    NULL_KEY     = 3'b000,
    WEP          = 3'b001,
    TKIP         = 3'b010,
    CCMP         = 3'b011,
    WAPI         = 3'b100,
    GCMP         = 3'b101,
    //--------------------
    NO_SECURITY  = 3'b110
  } cipher_type_e;

  // class that represents kay storage RAM data type
  class key_storage_ram_field;
    rand bit [1:0]         offset_key_idx_f;   // key index in security structure
    rand cipher_type_e     ctype_ram_f;        // cipher_type_ram_e
    rand bit [3:0]         vlan_id_ram_f;
    rand bit [1:0]         spp_ram_f;          // 01 - PP A-MSDU
                                               // 10 - SPP A-MSDU
                                               // 00,11 - discard received A-MSDU
    rand bit               use_def_key_ram_f;
    rand bit [1:0]         clen_ram_f;         // 0 - 64bit encryption
                                               // 1 - 128bit encryption
                                               // for CCMP/GCMP
                                               // 0 - 128bit encryption
                                               // 2 - 256bit encryption
    rand bit [47:0]        mac_addr_ram_f;
    rand bit [255:0]       encr_key_ram_f;
    rand bit [127:0]       int_wpi_key_ram_f;

    //-------------------------------------------------------------------------
    // constraints
    //-------------------------------------------------------------------------
    constraint c_ctype {
      soft ctype_ram_f inside {WEP, TKIP, CCMP, WAPI, GCMP};

`ifndef RW_GCMP_EN
      ctype_ram_f != GCMP;
`endif//RW_GCMP_EN

`ifndef RW_WAPI_EN
      ctype_ram_f != WAPI;
`endif//RW_WAPI_EN
    }
    constraint c_spp_ram {
      spp_ram_f inside {2'b01, 2'b10};
    }
    constraint c_clen {
      solve ctype_ram_f before clen_ram_f;

      if (ctype_ram_f == WEP){
        clen_ram_f inside {2'b00,2'b01};
      } else if (ctype_ram_f == TKIP) {
        clen_ram_f == 2'b01;
    `ifdef RW_GCMP_EN
      } else if (ctype_ram_f inside {CCMP,GCMP}) {
        clen_ram_f inside {2'b00,2'b10};
    `else // RW_GCMP_EN
      } else if (ctype_ram_f inside {CCMP}) {
        clen_ram_f == 2'b00;
    `endif // RW_GCMP_EN
      } else if (ctype_ram_f == WAPI) {
        clen_ram_f == 2'b00;
      } else if (ctype_ram_f == NULL_KEY){
        clen_ram_f == 2'b00;
      } else {
        clen_ram_f == 2'b00;
      }
    }
    constraint c_use_def_key_ram {
      if (ctype_ram_f inside {NULL_KEY, WEP, WAPI}) {
        use_def_key_ram_f == 0;
      }
    }
    constraint c_int_wpi_key {
      if (ctype_ram_f != WAPI) {
        int_wpi_key_ram_f == 0;
      }
    }
    //-------------------------------------------------------------------------
    // methods
    //-------------------------------------------------------------------------
    function void reset();
      offset_key_idx_f = 0;
      ctype_ram_f = NO_SECURITY;
      vlan_id_ram_f = 0;
      spp_ram_f = 0;
      use_def_key_ram_f = 0;
      clen_ram_f = 0;
      mac_addr_ram_f = 0;
      encr_key_ram_f = 0;
      int_wpi_key_ram_f = 0;
    endfunction : reset

    function string print();
      string s;
      s = $sformatf("offset_key_idx_f = %0d, ctype_ram_f = %s, vlan_id_ram_f = %0d, spp_ram_f = %0d, use_def_key_ram_f = %0d, clen_ram_f = %0d, mac_addr_ram_f = %0h, encr_key_ram_f = %0h, int_wpi_key_ram_f = %0h",
      offset_key_idx_f,
      ctype_ram_f.name(),
      vlan_id_ram_f,
      spp_ram_f,
      use_def_key_ram_f,
      clen_ram_f,
      mac_addr_ram_f,
      encr_key_ram_f,
      int_wpi_key_ram_f);

      return s;
    endfunction : print

  endclass : key_storage_ram_field

`endif //KEYSTORAGERAM_COMMON_SV
