//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 28315 $
// $Date: 2016-09-29 17:34:35 +0300 (Thu, 29 Sep 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef MDM_DATA_MODEL_COMMON_SV
`define MDM_DATA_MODEL_COMMON_SV

  // add defines, parameters, typedefs, enums...

  `define MIMO_NR     4       // Number of supported MU-MIMO users
  `define ANTENNA_NR  4       // Number of antennas supported by Matlab (NOT the RTL!)
  `define BFSTA_NR    2       // Number of stations targeted by TX
  `define NB_STA_MAX  4       // Maximum number of STAs supported in testbench

  // location of sysparam.txt and payload.txt
`ifndef SYSPARAM_TXT_DIR
  `define SYSPARAM_TXT_DIR  ./Pattern
`endif//SYSPARAM_TXT_DIR

  `define PAYLOAD_TXT_DIR   ./Pattern
  // location to store sysparam.txt and phyPayload.txt before deleting them
  `define BACKUP_DIR ./Pattern_backup

  `define MUMIMO_DIR

  // file names for verision 1 of Matlab API
  `define SYSPARAM_NAME "sysParam"
  `define SYSPARAM_EXT ".txt"

`ifndef PAYLOAD_NAME
  `define PAYLOAD_NAME "phyPayload"
`endif
  `define PAYLOAD_EXT ".txt"

  // file names for verision 2 of Matlab API
  `define DEFSTA_NAME  "defSTAs"
  `define DEFSTA_EXT   ".txt"

  `define DEFBSS_NAME  "defBSS"
  `define DEFBSS_EXT   ".txt"

`ifdef STANDALONE_PHY
  `define TESTCASE_NAME "tc_modem"
`else
  `define TESTCASE_NAME "tc_wlan"
`endif
  `define TESTCASE_EXT  ".txt"
  `define NDPTESTCASE_NAME "tc_ndp"

  `define MUMIMO_SUFFIX "_user%1d"  // In case of MU-MIMO Rx or Tx, payload files have a suffix defined here for

  `define HMEM_WIDTH         13
  `define BFRSIGMADB_WIDTH    8
  `define SIGMAE2_WIDTH      24

  `define TXBFRCOMPREP_WIDTH 20000
  `define TXBFRLENGTH_WIDTH  16

  `define GPIO_WIDTH         8  //RF GPIO signal width

  `define AGC_SAMPLE_WIDTH   13

`ifndef SAMPLE_TOLERANCE
  `define SAMPLE_TOLERANCE   0
`endif

`ifndef SAMPLE_NONCOMP_TOLERANCE
  `define SAMPLE_NONCOMP_TOLERANCE   0
`endif


  typedef bit [`GPIO_WIDTH-1:0] rf_gpio_t;
  typedef bit [`PHY_TX_DATA_WIDTH-1:0] phyData_t;
  typedef enum {Rx = 0, Tx} direction_e;
  typedef bit signed [`DACWIDTH-1:0] DAC_mu_data_t[`ANTENNA_NR-1:0];
  typedef bit signed [`ADCWIDTH-1:0] ADC_data_t;
  typedef bit signed [`ADCWIDTH-1:0] ADC_mu_data_t[`ANTENNA_NR-1:0];

  // data types used when AGC is disabled
  typedef bit signed [`AGC_SAMPLE_WIDTH-1:0] AGC_data_t;
  typedef bit signed [`AGC_SAMPLE_WIDTH-1:0] AGC_mu_data_t[`ANTENNA_NR-1:0];

  // naming of RX fields from matlab dump
  typedef enum bit [7:0] {
    L_STF        = 1,
    L_LTF        = 2,
    HT_GF_LTF    = 3,
    HT_LTF1      = 4,
    L_SIG        = 5,
    RL_SIG       = 6,
    HT_SIG       = 7,
    VHT_SIGA     = 8,
    VHT_SIGB     = 9,
    HE_SIGA      = 10,
    HE_SIGB      = 11,
    HT_STF       = 12,
    VHT_STF      = 13,
    HE_STF       = 14,
    HT_LTF       = 15,
    VHT_LTF      = 16,
    HE_LTF       = 17,
    L_DATA       = 18,
    HT_DATA      = 19,
    VHT_DATA     = 20,
    HE_DATA      = 21,
    X_SYM        = 23, //X-SYM maybe L-DATA0 or HT-SIG1 or VHT-SIGA1 or RL-SIG 
    X_SYM2       = 24, //X-SYM2 maybe L-DATA1 or VHT-SIGA2
    HT_SIG1      = 25
  } rxfield_e;

  // structure for FFT data
  typedef struct packed {
    AGC_data_t          re_f;
    AGC_data_t          im_f;
    logic signed [15:0] index_f;
    logic [15:0]        symb_idx_f;
    logic [15:0]        nsymb_f;
    logic [11:0]        fft_size_f;
    rxfield_e           rxfield_f;
  } FFT_data_s;

  typedef bit signed [`FEDATA_WIDTH-1:0] TXCORE_data_t;

  // structures used for collecting frontend stream data
  typedef struct packed {
    bit                enable_f;
    TXCORE_data_t      re_f;
    TXCORE_data_t      im_f;
  } TXCORE_data_s;

  // structures used for collecting mapper stream data
  typedef struct packed {
    bit signed [`MAPINDEX_WIDTH-1:0]  index_f;
    bit [31:0]                        symb_idx_f;
    bit signed [`MAPDATA_WIDTH-1:0]   re_f;
    bit signed [`MAPDATA_WIDTH-1:0]   im_f;
  } TXMAP_data_s;

  // structure used for DAC samples
  typedef struct packed {
    bit signed [`DACWIDTH-1:0] re_f;
    bit signed [`DACWIDTH-1:0] im_f;
  } DAC_data_s;

  // soft bits at the output of demapper or compressed
  typedef struct packed {
    bit signed [`SBSTREAMWIDTH-1:0]  real_comp_f;
    bit signed [`DEMAPSBWIDTH-1:0]   real_f;
    bit signed [31:0]                symb_f;
    bit signed [31:0]                indsymb_f;
    bit signed [31:0]                indsc_f;
    bit [3:0]                        stream_f;
    bit [15:0]                       bit_f;
    bit [15:0]                       seg_f;
  } soft_bits_s;

  // soft bits at DCM interface
  typedef struct packed {
    bit signed [`SBSTREAMWIDTH-1:0]  real_f;
    bit [31:0]                       symb_f;
    bit [3:0]                        stream_f;
    bit [15:0]                       bit_f;
    bit [15:0]                       seg_f;
  } dcm_sample_s;

  // LDPC samples
  typedef struct packed {
    bit signed [`LDPCSBWIDTH-1:0]   real_f;
    bit signed [`LDPCLENWIDTH-1:0]  bcc_es_f;
    int                             indsymb_f;
    int                             rxfield_f;
  } ldpc_samples_s;

  // Viterbi samples
  typedef struct packed {
    bit signed [`VITERBISBWIDTH-1:0]   real_f;
    bit signed [`VITERBILENWIDTH-1:0]  bcc_es_f;
    int                                indsymb_f;
    int                                rxfield_f;
    int                                contentchanidx_f;
  } viterbi_samples_s;

  // LDPC data samples
  typedef struct packed {
    bit [7:0]           real_f;
    int                 indsymb_f;
    int                 rxfield_f;
  } ldpc_data_samples_s;

  // structures used for collecting H memory data
  typedef struct packed {
    bit signed [`HMEM_WIDTH-1:0]   re_f;
    bit signed [`HMEM_WIDTH-1:0]   im_f;
    bit signed [7:0]               index_f;
  } HMEM_data_s;

  // define dynamic array for HMEM
  typedef HMEM_data_s hmem_array[];

  // structure that contains Rx parameters used for TDRx block inputs
  typedef struct {
    // paramters that are part of interface signals
    bit [1:0]  cbw_f;
    bit [1:0]  gi_type_f;
    bit [1:0]  he_ltf_type_f;
    bit [1:0]  ness_f;
    bit [4:0]  he_sigb_f;   // number of HE-SIGB symbols
    bit [2:0]  nsts_f;
    bit [14:0] nsymb_f;
    bit [2:0]  num_he_ltf_f;
    bit        vht_ndp_f;
    int        format_mod_f;
    bit [2:0]  tpe_f;
    bit        rlsig_f;
    // from matlab but not part of interface signals
    int        nsd_f;
    int        nbpsc0_f;
    int        nbpsc1_f;
    bit        stbc_f;
    bit        fec_f;
    bit        smoothing_f;
    bit        htndp_f;
    bit        lsig6m_f;
    bit [2:0]  nss_f;
    bit [2:0]  rutype_f;
    bit [2:0]  nbpsc_he_sigb_f;
    bit [5:0]  ruindex_f;
    // Used for forcing RatioNoiseSignal in RTL
    bit [11:0] RatioNoiseSignal;
    bit [5:0]  RatioShift;
    int        dut_location_f;
    int        nsym_init_f[4];
    bit        doppler_f;
    bit        midamble_f;
    bit [8:0]  nma_f;
    bit        dcm_f;
    bit [2:0]  mcs_sigb_f;
    bit        dcm_sigb_f;
    bit        sig_b_compression_f;
    bit [21:0] FDCpeSlope;
  } rxparameters_s;

  // define a dynamic array type of demap/deint soft bits structure
  typedef soft_bits_s soft_bits_array[];

  // define a dynamic array type of dcm input/output structure
  typedef dcm_sample_s dcm_data_array[];

  // define a dynamic array type of FFT output structure
  typedef FFT_data_s fft_data_array[];

  // define a dynamic array type of LDPC structure
  typedef ldpc_samples_s ldpc_array[];

  // define a dynamic array type of Viterbi structure
  typedef viterbi_samples_s viterbi_array[];

  // define a dynamic array type of LDPC data structure
  typedef ldpc_data_samples_s ldpc_data_array[];

  // define subgroups for Matlab parameter files
  typedef enum {
    AGC,   BSS,   CFG, NDPA,  RF,
    RXALG, RXREG, SIM, TXALG, TXV,
    TV,    ERR,   RIU, HW
  } param_subgroups_e;

  // -------------------------------------
  // SIG strunctures
  // -------------------------------------
  // LSIG
  typedef struct packed {
    bit [5:0]    tail_f;
    bit          parity_f;
    bit [11:0]   length_f;
    bit          reserved_f;
    bit [3:0]    rate_f;
  } l_sig_s;

  // HT
  typedef struct packed {
    bit [5:0]    tail_f;
    bit [7:0]    crc_f;
    bit [1:0]    num_extn_ss_f;
    bit          short_gi_f;
    bit          fec_coding_f;
    bit [1:0]    stbc_f;
    bit          aggregation_f;
    bit          reserved_f;
    bit          not_sounding_f;
    bit          smoothing_f;
    bit [15:0]   ht_length_f;
    bit          cbw_2040_f;
    bit [6:0]    mcs_f;
  } ht_sig_s;

  // VHT
  typedef struct packed {
    bit [5:0]    tail_f;
    bit [7:0]    crc_f;
    bit          reserved3_f;
    bit          beamformed_f;
    bit [3:0]    mcs_f;
    bit          ldpc_extra_symbol_f;
    bit          fec_coding_f;
    bit          disambiguity_f;
    bit          short_gi_f;
    bit          reserved2_f;
    bit          txop_ps_not_allowed_f;
    bit [8:0]    partial_aid_f;
    bit [2:0]    nsts_f;
    bit [5:0]    group_id_f;
    bit          stbc_f;
    bit          reserved1_f;
    bit [1:0]    cbw_f;
  } vht_siga_su_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [7:0]    crc_f;
    bit [2:0]    reserved3_f;
    bit          fec_coding3_f;
    bit          fec_coding2_f;
    bit          fec_coding1_f;
    bit          ldpc_extra_symbol_f;
    bit          fec_coding0_f;
    bit          disambiguity_f;
    bit          short_gi_f;
    bit          reserved2_f;
    bit          txop_ps_not_allowed_f;
    bit [2:0]    nsts3_f;
    bit [2:0]    nsts2_f;
    bit [2:0]    nsts1_f;
    bit [2:0]    nsts0_f;
    bit [5:0]    group_id_f;
    bit          stbc_f;
    bit          reserved1_f;
    bit [1:0]    cbw_f;
  } vht_siga_mu_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [2:0]    reserved_f;
    bit [16:0]   length_f;
  } vht_sigb_su_20mhz_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [1:0]    reserved_f;
    bit [18:0]   length_f;
  } vht_sigb_su_40mhz_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [1:0]    reserved_f;
    bit [20:0]   length_f;
  } vht_sigb_su_80mhz_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    mcs_f;
    bit [16:0]   length_f;
  } vht_sigb_mu_20mhz_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    mcs_f;
    bit [18:0]   length_f;
  } vht_sigb_mu_40mhz_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    mcs_f;
    bit [20:0]   length_f;
  } vht_sigb_mu_80mhz_s;

  // HE
  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    crc_f;
    bit          doppler_f;
    bit          reserved2_f;
    bit          pe_disambiguity_f;
    bit [1:0]    pre_fec_padding_factor_f;
    bit          tx_bf_f;
    bit          stbc_f;
    bit          ldpc_extra_symbol_f;
    bit          fec_coding_f;
    bit [6:0]    txop_f;
    bit [2:0]    nsts_midamble_periodicity_f;
    bit [1:0]    gi_ltf_size_f;
    bit [1:0]    bw_f;
    bit [3:0]    spatial_reuse_f;
    bit          reserved1_f;
    bit [5:0]    bss_color_f;
    bit          dcm_f;
    bit [3:0]    mcs_f;
    bit          ul_dl_f;
    bit          beam_change_f;
    bit          format_f;
  } he_siga_su_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    crc_f;
    bit          pe_disambiguity_f;
    bit [1:0]    pre_fec_padding_factor_f;
    bit          stbc_f;
    bit          ldpc_extra_symbol_f;
    bit [2:0]    num_he_ltf_midamble_periodicity_f;
    bit          reserved1_f;
    bit [6:0]    txop_f;
    bit          doppler_f;
    bit [1:0]    gi_ltf_size_f;
    bit          sigb_compression_f;
    bit [3:0]    num_he_sigb_f;
    bit [2:0]    bw_f;
    bit [3:0]    spatial_reuse_f;
    bit [5:0]    bss_color_f;
    bit          sigb_dcm_f;
    bit [2:0]    sigb_mcs_f;
    bit          ul_dl_f;
  } he_siga_mu_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    crc_f;
    bit [8:0]    reserved2_f;
    bit [6:0]    txop_f;
    bit [1:0]    bw_f;
    bit          reserved1_f;
    bit [3:0]    spatial_reuse4_f;
    bit [3:0]    spatial_reuse3_f;
    bit [3:0]    spatial_reuse2_f;
    bit [3:0]    spatial_reuse1_f;
    bit [5:0]    bss_color_f;
    bit          format_f;
  } he_siga_tb_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    crc_f;
`ifdef RW_NX_DERIV_CHBW804020ONLY
    bit          center_26tone_ru_f;
`endif
    bit [7:0]    ru_allocation_f;
  } he_sigb_common_s;

  typedef struct packed {
    bit [5:0]    tail_f;
    bit [3:0]    crc_f;
    bit          fec_coding_f;
    bit          dcm_f;
    bit [3:0]    mcs_f;
    bit          beamformed_f;
    bit [2:0]    nsts_f;
    bit [10:0]   sta_id_f;
  } he_sigb_user_s;

  typedef struct packed {
    he_sigb_user_s   user_field_f;
    he_sigb_common_s common_field_f;
  } he_sigb_s;

  //---------------------------------------------------------------------------
  // helper functions
  //---------------------------------------------------------------------------
  function string TXMAP2string(TXMAP_data_s data);
    string s;

    s = $sformatf("index: %0d, symb_cnt: %0d, re: %0d, im: %0d",
        signed'(data.index_f),
        data.symb_idx_f,
        signed'(data.re_f),
        signed'(data.im_f));

    return s;
  endfunction : TXMAP2string

  function string FFT2string(FFT_data_s data);
    string s;

    s = $sformatf("index: %0d, symb_cnt: %0d, re: %0d, im: %0d, rxfield: %s",
        signed'(data.index_f),
        data.symb_idx_f,
        signed'(data.re_f),
        signed'(data.im_f),
        data.rxfield_f.name());

    return s;
  endfunction : FFT2string

  function string TXCORE2string(TXCORE_data_s data);
    string s;

    s = $sformatf("re: %0d, im: %0d",signed'(data.re_f), signed'(data.im_f));

    return s;
  endfunction : TXCORE2string

  // update TXCORE RE/IM parts with tolerance value
  function TXCORE_data_s updateTXCORE(TXCORE_data_s data, int tolerance);
    TXCORE_data_s ret;

    ret.enable_f = data.enable_f;
    ret.re_f = data.re_f + tolerance;
    ret.im_f = data.im_f + tolerance;
    return ret;
  endfunction : updateTXCORE

  // convert number to two's complement
  function bit signed [`DACWIDTH-1:0] two_complement(bit signed [`DACWIDTH-1:0] data);
    bit signed [`DACWIDTH-1:0] ret;

    ret = (data < 0) ? (~data + 1'b1) : data;
    return ret;
  endfunction : two_complement

`endif //MDM_DATA_MODEL_COMMON_SV

