//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef MDM_DATA_MODEL_VER2_SV
`define MDM_DATA_MODEL_VER2_SV


class mdm_data_model_ver2 extends mdm_data_model;

  // referente data from TXCORE (HDMCore)
  TXCORE_data_s TxCoreOut[];
  TXMAP_data_s  TxMapOut[];
  int           scrambler_initial_state;
  string        testname[$];
  int           cmdline_size;
  int           primary_channel;

  `uvm_object_utils(mdm_data_model_ver2)

  //--------------------------------------------------------------------
  // Constructor
  //--------------------------------------------------------------------
  function new (string name ="mdm_data_model_ver2");
    super.new(name);

    golden_frame = new();
    assert (golden_frame.randomize() with {ppdu_format == NON_HT;});

    scrambler_initial_state = 1; // init value
    snr_dB = 40;
    foreach (STAIDList[i])
      STAIDList[i] = i+2;
    RNGSeed = $get_initial_random_seed(); // get svseed value
    // get test name from command line
    cmdline_size = uvm_cmdline_proc.get_arg_values("+UVM_TESTNAME=",testname);
  endfunction

  //--------------------------------------------------------------------
  // Returns 1 if MU-MIMO Rx or Tx is active, 0 otherwise
  //--------------------------------------------------------------------
  virtual function bit is_mumimo_active();
    if (golden_frame.kind == MU_MIMO || golden_frame.preamble_header.ru_with_more_users == 1)
      return 1;
    else
      return 0;
  endfunction: is_mumimo_active

  //--------------------------------------------------------------------
  // Returns 1 if NDP Rx or Tx is active, 0 otherwise
  //--------------------------------------------------------------------
  virtual function bit is_ndp_active();
    if (golden_frame.kind == NDP)
      return 1;
    else
      return 0;
  endfunction : is_ndp_active

  //--------------------------------------------------------------------
  // Return PHY payload file name
  //--------------------------------------------------------------------
  virtual function string get_phyPayload_file_name(int user=0);
    if (is_mumimo_active()) begin
      return {`PAYLOAD_NAME, $sformatf(`MUMIMO_SUFFIX, (user+1)), `PAYLOAD_EXT};
    end else if (is_ndp_active()) begin
      return ""; //empty because NDP doesn't have payload
    end else begin
      return {`PAYLOAD_NAME, `PAYLOAD_EXT};
    end
  endfunction: get_phyPayload_file_name

  //--------------------------------------------------------------------
  // return station IDs in list
  //--------------------------------------------------------------------
  function string station_list(int add_offset = 0);
    string    str;
    int       i;
    int       sta_position;

    if (!is_mumimo_active()) begin
      i = 0;
      if (golden_frame.ppdu_format != HE_MU) begin
        str = $sformatf("%0d", STAIDList[0]+add_offset);
      end
      else begin
        if(add_offset > 0) begin
          sta_list = get_sta_list(golden_frame.preamble_header.ru_allocation, golden_frame.preamble_header.ch_bw);
          if (golden_frame.preamble_header.ch_bw == 1 && golden_frame.preamble_header.ru_allocation < 200) begin
            if (primary_channel == 0)
              sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f;
            else if (primary_channel == 1)
              sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f + 9;
          end
          else if (golden_frame.preamble_header.ch_bw == 2 && golden_frame.preamble_header.ru_allocation < 208) begin
            case(primary_channel)
              0 : sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f;
              1 : sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f + 9;
              2 : sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f + 18 + 1 /*RU26 center tone*/;
              3 : sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f + 27 + 1 /*RU26 center tone*/;
            endcase
          end
          else begin
            sta_position = golden_frame.preamble_header.user_header_he[0].dut_location_f;
          end
          sta_list[sta_position] = golden_frame.preamble_header.user_header_he[0].staid_f;
          repeat (sta_list.size())
            str = {str," ",$sformatf("%0d", sta_list[i++])};
        end
        else begin
          repeat (golden_frame.num_of_users)
            str = {str," ",$sformatf("%0d", STAIDList[i++])};
        end
      end

    end//SINGLETON, AGGREGATION
    else if (is_mumimo_active()) begin
      i = 0;
      if (golden_frame.ppdu_format == HE_MU) begin
        if(add_offset > 0) begin
          sta_list = get_sta_list(golden_frame.preamble_header.ru_allocation, golden_frame.preamble_header.ch_bw);

          // add offset in case of secondary channel to skipp unused channel
          if (golden_frame.preamble_header.ch_bw == 1 && primary_channel == 1 && golden_frame.preamble_header.ru_allocation < 200)
            sta_position = 9;
          else if (golden_frame.preamble_header.ch_bw == 2 && golden_frame.preamble_header.ru_allocation < 208)
            case(primary_channel)
              0 : sta_position = 0;
              1 : sta_position = 9;
              2 : sta_position = 18 + 1 /*RU26 center tone*/;
              3 : sta_position = 27 + 1 /*RU26 center tone*/;
            endcase
          else
            sta_position = 0;


          // set STAID in list
          foreach (golden_frame.preamble_header.user_header_he[i])
            sta_list[sta_position + golden_frame.preamble_header.user_header_he[i].dut_location_f] = golden_frame.preamble_header.user_header_he[i].staid_f;

          // find first position of secondary users, offset are number of primary users
          sta_position = (sta_position == 0)
                         ? get_ru_allocation_subfield_size(golden_frame.preamble_header.ru_allocation)
                         : 0;
          foreach (golden_frame.preamble_header.user_header_he_sec[i])
            sta_list[sta_position + golden_frame.preamble_header.user_header_he_sec[i].dut_location_f] = golden_frame.preamble_header.user_header_he_sec[i].staid_f;

          foreach (sta_list[i])
            str = {str," ",$sformatf("%0d", sta_list[i])};
        end
        else begin
          repeat (golden_frame.num_of_users)
            str = {str," ",$sformatf("%0d", STAIDList[i++])};
        end
      end//if HE_MU
    end//MU_MIMO
    else if (is_ndp_active()) begin
      i = 0;
      repeat (nBeamformingSTA)
        str = {str," ",$sformatf("%0d", STAIDList[i++]+add_offset)};
    end//NDP

    return str;
  endfunction : station_list

  //--------------------------------------------------------------------
  // convert to GI type string format
  //--------------------------------------------------------------------
  function string gi_type_to_string(int gi_type);
    case (gi_type)
      0:return "0.8";
      1:return "1.6";
      default:return "3.2";
    endcase
  endfunction : gi_type_to_string

  //--------------------------------------------------------------------
  // create and write to defSTA and defBSS files
  //--------------------------------------------------------------------
  virtual function void write_STAparam(direction_e direction,
                                       bit agcBypass = 0,
                                       bit [3:0] modemconf,
                                       bit [1:0] controlChannel);

    int               fptr;   // file pointer
    string            fname;  // file name
    param_subgroups_e subgroup;
    int               station_id[];
    bit [31:0]        reg_data;
    int               add_he_mu_sec_users;

    fname = {get_sysparam_dir_name(),`DEFSTA_NAME,`DEFSTA_EXT};
    fptr = $fopen(fname, "w");

    if (fptr == 0)
      `uvm_fatal(get_type_name(), $sformatf("Unable to open %s for writing", fname))
    else
      `uvm_info(get_type_name(), $sformatf("Created %s",fname), UVM_LOW)

    // write file header
    $fwrite(fptr, "# %s\n", "Configuration of all STAs");
    $fwrite(fptr, "# %s\n", "NAME,              VALUE");

    // determine how meny secondary users we have
    if (golden_frame.ppdu_format == HE_MU && golden_frame.preamble_header.ch_bw > 2'b00)
      add_he_mu_sec_users = golden_frame.preamble_header.user_header_he_sec.size();
    else
      add_he_mu_sec_users = 0;

    // create 4 stations plus 1 TX station,
    // and in case of WLAN HE-MU CBW40 additional users will be added to
    // secondary channel
    station_id = new[`NB_STA_MAX+1+add_he_mu_sec_users];
    foreach (station_id[i]) begin
      station_id[i] = i+1;
    end

    foreach (station_id[i]) begin
      $fwrite(fptr, "## %s\n",$sformatf("STA %0d,",station_id[i]));
      // set CFG parameters
      subgroup = CFG;
      $fwrite(fptr,"%s\n",$sformatf("%s.IND,        [ %0d ]",subgroup.name(),station_id[i]));
      $fwrite(fptr,"%s\n",$sformatf("%s.STA_ID,     [ %0d ]",subgroup.name(),station_id[i]+`STAID_OFFSET));
      $fwrite(fptr,"%s\n",$sformatf("%s.NTx,        [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.stbc ? 2 : (is_ndp_active() && (station_id[i] == 1)) ? NSTS[0] : nTx));
`ifdef RW_TXRX_2X2
      $fwrite(fptr,"%s\n",$sformatf("%s.NRx,        [ %0d ]",subgroup.name(), 2));
`else
      $fwrite(fptr,"%s\n",$sformatf("%s.NRx,        [ %0d ]",subgroup.name(), 1));
`endif

      primary_channel = m_regmodel.get_mirrored_reg_value("PRIMARYIND");
      // additional stations start from index 6 (6,7,8,9)
      if (station_id[i] < 6)
        $fwrite(fptr,"%s\n",$sformatf("%s.PrimaryInd, [ %0d ]",subgroup.name(), primary_channel));
      else// additonal stations are in secondary channel
        $fwrite(fptr,"%s\n",$sformatf("%s.PrimaryInd, [ %0d ]",subgroup.name(), ~primary_channel[0]));

`ifdef RW_NX_CHBW20
      if (golden_frame.preamble_header.ch_bw == 3'b010 && golden_frame.ppdu_format == HE_MU && direction == Rx && station_id[i] == 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),80));
      else if (golden_frame.preamble_header.ch_bw == 3'b001 && golden_frame.ppdu_format == HE_MU && direction == Rx && station_id[i] == 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),40));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),20));
`elsif RW_NX_CHBW4020
      // In a 40 MHz BSS, the 40 MHz STA can be configured in 20 MHz only mode
      if (testname[0] == "test_modem_rx_20mhz_only" && station_id[i] != 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),20));
      else if (golden_frame.preamble_header.ch_bw == 3'b010 && golden_frame.ppdu_format == HE_MU && direction == Rx && station_id[i] == 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),80));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),40));
`elsif RW_NX_CHBW804020
      $fwrite(fptr,"%s\n",$sformatf("%s.ChannelBW,  [ %0d ]",subgroup.name(),80));
`endif

      if (direction == Rx && !(golden_frame.ppdu_format == NON_HT && golden_frame.preamble_header.leg_rate inside {[0:3]}))
        $fwrite(fptr,"%s\n",$sformatf("%s.TXALG,      [ '%s' ]",subgroup.name(),"FLPT"));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.TXALG,      [ '%s' ]",subgroup.name(),"FXPT"));

      if ((`AGC_ON == 1) && (agcBypass == 0)) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.AGC,        [ '%s' ]",subgroup.name(),"FXPT"));
      end
      // Rx station should be in FXPT
      if (i != 0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.RXALG,      [ '%s' ]",subgroup.name(),"FXPT"));
      end

      // set RXALG parameters
      subgroup = RXALG;
      $fwrite(fptr,"%s\n",$sformatf("%s.Smoothing,    [ '%s' ]",subgroup.name(),"FXPT"));
      $fwrite(fptr,"%s\n",$sformatf("%s.TDDCComp,     [ '%s' ]",subgroup.name(),"FXPT"));
`ifdef RW_NX_CHBW20
      $fwrite(fptr,"%s\n",$sformatf("%s.ProcessSecondaryEn,     [ 0 ]",subgroup.name()));
`else
      $fwrite(fptr,"%s\n",$sformatf("%s.ProcessSecondaryEn,     [ 1 ]",subgroup.name()));
`endif
      $fwrite(fptr,"%s\n",$sformatf("%s.SkipMidamble1x,     [ 1 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.SkipMidamble2x,     [ 1 ]",subgroup.name()));

      $fwrite(fptr,"%s\n",$sformatf("%s.FDOffsetComp,     [ '%s' ]",subgroup.name(),"FXPT"));
      $fwrite(fptr,"%s\n",$sformatf("%s.TDFOComp,         [ '%s' ]",subgroup.name(),"FXPT"));
      $fwrite(fptr,"%s\n",$sformatf("%s.SBNoiseVarSrcSel, [ '%s' ]",subgroup.name(),"RCFE"));
      $fwrite(fptr,"%s\n",$sformatf("%s.ViterbiType,      [ '%s' ]",subgroup.name(),"RADIX4"));
      $fwrite(fptr,"%s\n",$sformatf("%s.LDPCDecMode,      [ '%s' ]",subgroup.name(),"TABLE-DYN"));
//      $fwrite(fptr,"%s\n",$sformatf("%s.LDPCDecTabName, [ '%s' ]",subgroup.name(),"8_6_3_2p_240_120_sta40")); // also used in 20 MHz
`ifdef RW_NX_FPGA_SIM
      $fwrite(fptr,"%s\n",$sformatf("%s.LDPCDecTabName, [ '%s' ]",subgroup.name(),"8_6_3_2p_120_120_stbc_only")); // includes he, for FPGA
`else
      $fwrite(fptr,"%s\n",$sformatf("%s.LDPCDecTabName, [ '%s' ]",subgroup.name(),"8_6_3_2p_240_120_stbc_only")); // includes he
`endif
      $fwrite(fptr,"%s\n",$sformatf("%s.AGCDCEstim,   [ 'NON' ]",subgroup.name()));

`ifndef RW_NX_CHBW20
      // set RIU parameters
      if ((`AGC_ON == 1) && (agcBypass == 0)) begin
        subgroup = RIU;
        $fwrite(fptr,"%s\n",$sformatf("%s.HTSTFAGCEn,    [ 1 ]",subgroup.name()));
      end
`endif

      // set TXALG parameters
      subgroup = TXALG;
      $fwrite(fptr,"%s\n",$sformatf("%s.FDUpSamp,          [ %0d ]",subgroup.name(), 2));
      $fwrite(fptr,"%s\n",$sformatf("%s.FFTVerSel,         [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.WindowingLength,   [ %0d ]",subgroup.name(), 3));
      $fwrite(fptr,"%s\n",$sformatf("%s.Tx4044FilterShift, [ %0d ]",subgroup.name(), 0));
      $fwrite(fptr,"%s\n",$sformatf("%s.FrequencyShift_En, [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.SupportHESIGBCompression, [ %0d ]",subgroup.name(), 1));

      // for the test_modem_rx_tx_he_tb test, HW is in default mode (enable, not forced)
      // and program the MATLAB as follows for the HE-TB tx
      if (   (direction == Tx && testname[0] == "test_modem_rx_tx_he_tb")
          || (direction == Tx && golden_frame.ppdu_format == HE_TB && testname[0] inside {"test_wlan_rx_ampdu_frame",
                                                                                          "test_wlan_rx_ampdu_frame_wc",
                                                                                          "test_wlan_rx_mumimo_frame",
                                                                                          "test_wlan_bf_su_rx_he",
                                                                                          "test_wlan_bf_mu_rx_he"})
         ) begin

        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreEstim,       [ '%s' ]",subgroup.name(), "FORCE"));
        reg_data = m_regmodel.get_mirrored_reg_value("RXSFOEST");
        $fwrite(fptr,"%s\n",$sformatf("%s.SFOPreForceTsNormOut, [ %0d ]",subgroup.name(), reg_data[26:0]));
        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreComp,        [ '%s' ]",subgroup.name(), "FXPT"));
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreEstim,       [ '%s' ]",subgroup.name(), "FORCE"));
`ifdef RW_NX_DERIV_CHBW4020ONLY
        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreAlgo,        [ '%s' ]",subgroup.name(), "LAGRANGE")); // 40 MHz
`endif
        reg_data = m_regmodel.get_mirrored_reg_value("RXCFOEST");
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreForceDphi,   [ %0d ]",subgroup.name(), reg_data[24:0]));
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreComp,        [ '%s' ]",subgroup.name(), "FXPT"));
      end
      else if (   direction == Tx
               && (       golden_frame.ppdu_format == HE_TB
                   || (   golden_frame.ppdu_format inside {NON_HT,NON_HT_DUP_OFDM}
                       && golden_frame.preamble_header.trigger_responding == 1'b1))
      ) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreEstim,       [ '%s' ]",subgroup.name(), "FORCE"));
        reg_data = m_regmodel.get_mirrored_reg_value("TXTDSFOCTRL");
        $fwrite(fptr,"%s\n",$sformatf("%s.SFOPreForceTsNormOut, [ %0d ]",subgroup.name(), reg_data[26:0]));
        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreComp,        [ '%s' ]",subgroup.name(), "FXPT"));
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreEstim,       [ '%s' ]",subgroup.name(), "FORCE"));
`ifdef RW_NX_DERIV_CHBW4020ONLY
        $fwrite(fptr,"%s\n",$sformatf("%s.SCOPreAlgo,        [ '%s' ]",subgroup.name(), "LAGRANGE")); // 40 MHz
`endif
        reg_data = m_regmodel.get_mirrored_reg_value("TXTDCFOCTRL");
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreForceDphi,   [ %0d ]",subgroup.name(), reg_data[24:0]));
        $fwrite(fptr,"%s\n",$sformatf("%s.CFOPreComp,        [ '%s' ]",subgroup.name(), "FXPT"));
      end

      // set RXREG parameters
      subgroup = RXREG;
      $fwrite(fptr,"%s\n",$sformatf("%s.TD_SNREST_OLD_EN,    [ 1 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.STOCompTime,         [ 0 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.SmoothingFilterEn,   [ 1 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.FDOOldEn,            [ 1 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.SkipMidambleFDOEn,   [ 1 ]",subgroup.name()));
      if (testname[0] inside {"test_modem_rx_td_non_ht",
                              "test_modem_rx_td_ht_mf",
                              "test_modem_rx_td_ht_gf",
                              "test_modem_rx_td_vht",
                              "test_modem_rx_td_he_su",
                              "test_modem_rx_td_he_tb",
                              "test_modem_rx_td_he_mu"})
        $fwrite(fptr,"%s\n",$sformatf("%s.STOTDComp_En,        [ 0 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.AutoCorrCompareRatio20Low,            [ 0.25 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.AutoCorrCompareRatio20High,           [ 0.8125 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.AutoCorrTriggerIndexOffset,           [ 8 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.HSTFTDDCMode,         [ 'NEW' ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.TDFDOCompEn,          [ 1 ]",subgroup.name()));
      if (sig_error_injection == 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.Demod_En,          [ 0 ]",subgroup.name()));
      // set HW parameters
      subgroup = HW;
`ifdef RW_NX_DERIV_CHBW20ONLY
      $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 32 ]",subgroup.name()));
      if (testname[0] inside {"test_modem_rx_td_vht"})
        $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 32 ]",subgroup.name()));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 48 ]",subgroup.name()));
`elsif RW_NX_DERIV_CHBW4020ONLY
      if(modemconf=='d0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
        $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 32 ]",subgroup.name()));
        if (testname[0] inside {"test_modem_rx_td_vht"})
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 32 ]",subgroup.name()));
        else
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 48 ]",subgroup.name()));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
        $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 64 ]",subgroup.name()));
        if (testname[0] inside {"test_modem_rx_td_vht"})
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 64 ]",subgroup.name()));
        else
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 96 ]",subgroup.name()));
      end
`elsif RW_NX_DERIV_CHBW804020ONLY
      if(modemconf=='d0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
        $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 32 ]",subgroup.name()));
      if (testname[0] inside {"test_modem_rx_td_vht"})
        $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 32 ]",subgroup.name()));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 48 ]",subgroup.name()));
      end
      else if(modemconf=='d1) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
        $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 64 ]",subgroup.name()));
        if (testname[0] inside {"test_modem_rx_td_vht"})
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 64 ]",subgroup.name()));
        else
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 96 ]",subgroup.name()));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ 1 ]",subgroup.name()));
        $fwrite(fptr,"%s\n",$sformatf("%s.DCHTTrigOff20,       [ 64 ]",subgroup.name()));
        if (testname[0] inside {"test_modem_rx_td_vht"})
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 64 ]",subgroup.name()));
        else
          $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 96 ]",subgroup.name()));

//         $fwrite(fptr,"%s\n",$sformatf("%s.DCRelockHTTrigOff,   [ -1 ]",subgroup.name()));
//         $fwrite(fptr,"%s\n",$sformatf("%s.DCVHTTrigOff20,      [ 235 ]",subgroup.name()));
      end
`endif
      // set RF parameters
      subgroup = RF;

`ifdef STANDALONE_PHY
      if (testname[0] inside {"test_modem_rx_td_non_ht",
                              "test_modem_rx_td_ht_mf",
                              "test_modem_rx_td_ht_gf",
                              "test_modem_rx_td_vht",
                              "test_modem_rx_td_he_su",
                              "test_modem_rx_td_he_tb",
                              "test_modem_rx_td_he_mu"})
        offset_ppm = 0;
      // $TODO: remove doppler limitation when matlab is fixed !!!
      else if (golden_frame.preamble_header.doppler)
        offset_ppm = 0;
      else if (station_id[i] != 1)
        offset_ppm = ((`AGC_ON == 1) && (agcBypass == 0)) ? 0 : $urandom_range(0, 20);
      else
        offset_ppm = 0;

      $fwrite(fptr,"%s\n",$sformatf("%s.Offset_ppm,    [ %0d ]",subgroup.name(),offset_ppm));
`else
      $fwrite(fptr,"%s\n",$sformatf("%s.Offset_ppm,    [ 0 ]",subgroup.name()));
`endif

      if ((`AGC_ON == 1) && (agcBypass == 0)) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.RFName,              [ '%s' ]",subgroup.name(),"KARST"));
      end

      // set NDPA paremeters
      subgroup = NDPA;
      if ((nBeamformingSTA != 0) && (i > 0) && is_ndp_active()) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.Nc,                  [ %0d ]",subgroup.name(),Nc[i-1]+1));
        $fwrite(fptr,"%s\n",$sformatf("%s.Grouping,            [ %0d ]",subgroup.name(),Grouping[i-1]));
        $fwrite(fptr,"%s\n",$sformatf("%s.Codebook,            [ %0d ]",subgroup.name(),Codebook[i-1]));
        $fwrite(fptr,"%s\n",$sformatf("%s.Feedback,            [ %0d ]",subgroup.name(),Feedback[i-1]));
        $fwrite(fptr,"%s\n",$sformatf("%s.RUStartIndex,        [ %0d ]",subgroup.name(),RUStartIndex[i-1]));
        $fwrite(fptr,"%s\n",$sformatf("%s.RUEndIndex,          [ %0d ]",subgroup.name(),RUEndIndex[i-1]));
      end
    end//for
    // write file footer
    $fwrite(fptr, "# END FILE\n");
    $fclose(fptr);
  endfunction : write_STAparam

  //--------------------------------------------------------------------
  // create and write BSS file
  //--------------------------------------------------------------------
  virtual function void write_BSSparam();
    int               fptr;   // file pointer
    string            fname;  // file name
    param_subgroups_e subgroup;
    int               group_id;
    int               reg_data;
    real              carrier_freq;

    fname = {get_sysparam_dir_name(),`DEFBSS_NAME,`DEFBSS_EXT};
    fptr = $fopen(fname, "w");

    if (fptr == 0)
      `uvm_fatal(get_type_name(), $sformatf("Unable to open %s for writing", fname))
    else
      `uvm_info(get_type_name(), $sformatf("Created %s",fname), UVM_LOW)

    // write file header
    $fwrite(fptr, "# %s\n", "Configuration of BSS");
    $fwrite(fptr, "# %s\n", "NAME,              VALUE");

    // for DSSS-CCK frames
    if (golden_frame.ppdu_format == NON_HT && golden_frame.preamble_header.leg_rate inside {[0:3]}) begin
      $fwrite(fptr,"%s\n",$sformatf("CarrierFreq_GHz,  [ 2.4 ]"));
    end
    else begin
      reg_data = m_regmodel.get_mirrored_reg_value("RXFOESTCTRL");
      carrier_freq = (2**26)/real'(reg_data[14:0]);
      $fwrite(fptr,"%s\n",$sformatf("CarrierFreq_GHz,  [ %0.3f ]", carrier_freq/1000));
    end

    group_id = golden_frame.preamble_header.group_id;
    // Matlab will crash if GroupID value is 0
    if (group_id == 0) group_id++;

    if (golden_frame.ppdu_format == VHT) begin
      $fwrite(fptr,"GID(%s),  [ ",$sformatf("%0d", group_id));
      for (int i=0; i<`NB_STA_MAX; i++) begin
        $fwrite(fptr,"%0d ",i+2+`STAID_OFFSET);
      end
      $fwrite(fptr,"],\n");
    end

    // write file footer
    $fwrite(fptr, "# END FILE\n");
    $fclose(fptr);
  endfunction : write_BSSparam

  //--------------------------------------------------------------------
  // create and write test case file
  //--------------------------------------------------------------------
  virtual function void write_testcase(direction_e direction,
                                       bit agcBypass = 0);
    int               fptr;   // file pointer
    string            fname;  // file name
    param_subgroups_e subgroup;
    string            non_ht_modulation;
    string            trigger_method;
    bit [15:0]        spatial_reuse_tb;
    string            mumimo_str;
    bit [99:0]        swap_sig;
    string            staid;
    int               sta_pos;

    if (is_ndp_active())
      fname = {get_sysparam_dir_name(),`NDPTESTCASE_NAME,`TESTCASE_EXT};
    else
      fname = {get_sysparam_dir_name(),`TESTCASE_NAME,`TESTCASE_EXT};
    fptr = $fopen(fname, "w");

    if (fptr == 0)
      `uvm_fatal(get_type_name(), $sformatf("Unable to open %s for writing", fname))
    else
      `uvm_info(get_type_name(), $sformatf("Created %s",fname), UVM_LOW)

    // write file header
    $fwrite(fptr, "# %s\n", "Set default values of all frame parameters");
    $fwrite(fptr, "# %s\n", "NAME,   VALUE,   MU index");
    // set simualation parameters
    subgroup = SIM;
    $fwrite(fptr,"%s\n",$sformatf("%s.TXINDs,         [ %0d ]",subgroup.name(), 1));
    $fwrite(fptr,"%s\n",$sformatf("%s.DUTINDs,        [ %s ]",subgroup.name(),
    (direction == Tx)    ? "1" :
    (is_mumimo_active()) ? $sformatf("%0d", golden_frame.preamble_header.mu_mimo_userid+2) : station_list()));
    $fwrite(fptr,"%s\n",$sformatf("%s.DispEn,         [ %0d ]",subgroup.name(), 1));
    $fwrite(fptr,"%s\n",$sformatf("%s.SNR_v,          [ %0d ]",subgroup.name(), snr_dB));
    $fwrite(fptr,"%s\n",$sformatf("%s.RNGSeed,        [ %0d ]",subgroup.name(), RNGSeed));
    if ((`AGC_ON == 1) && (agcBypass == 0)) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.PAnt_v,         [ -40 ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.PerfCrit,       [ 'pant' ]",subgroup.name()));
`ifdef DEBUG_SAMPLES
      $fwrite(fptr,"%s\n",$sformatf("%s.AGCPrint,    [ 1 ]",subgroup.name()));
`endif
    end

`ifndef FULL_WLAN_SYSTEM
    //NOTE: for WLAN test cases ChanType will not be set, default one will be
    //      used
    if (is_ndp_active()) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.ChanType,       [ 'B' ]",subgroup.name()));
      $fwrite(fptr,"%s\n",$sformatf("%s.ChanReset,      [ 1 ]",subgroup.name()));
    end
    else if (is_mumimo_active()) begin

      void'(station_list(`STAID_OFFSET));

      foreach (sta_list[i]) begin
        if (sta_list[i] != 2046 && sta_list[i] != golden_frame.preamble_header.user_header_he[golden_frame.preamble_header.mu_mimo_userid].staid_f)
          sta_pos++;
        else if (sta_list[i] == golden_frame.preamble_header.user_header_he[golden_frame.preamble_header.mu_mimo_userid].staid_f)
          break;
      end
      mumimo_str = $sformatf("_RXIND%0d_(%0d;1)",
                   golden_frame.preamble_header.mu_mimo_userid+2,
                   (golden_frame.ppdu_format == HE_MU) ? sta_pos+1 : golden_frame.preamble_header.mu_mimo_userid+1);
      $fwrite(fptr,"%s\n",$sformatf("%s.ChanType,       [ 'UD_TXIND1%s' ]",subgroup.name(),mumimo_str));
    end
    else if (golden_frame.ppdu_format == HE_MU) begin
      if (golden_frame.preamble_header.stbc == 1)
        $fwrite(fptr,"%s\n",$sformatf("%s.ChanType,       [ 'UD_TXIND1_RXIND2_(1;1)(2;1)' ]",subgroup.name()));
      else
        $fwrite(fptr,"%s\n",$sformatf("%s.ChanType,       [ 'UD_TXIND1_RXIND2_(1;1)' ]",subgroup.name()));
    end
    else if (golden_frame.preamble_header.stbc == 1)
      $fwrite(fptr,"%s\n",$sformatf("%s.ChanType,       [ 'UD_TXIND1_RXIND2_(1;1)(2;1)' ]",subgroup.name()));
`endif//FULL_WLAN_SYSTEM

    // set parameters for test vector
    subgroup = TV;
    if (direction == Tx) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.TXFRONTEND_EN,   [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.TXPSDU_EN,       [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.TXCORE_EN,       [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.TXENCODER_EN,    [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.TXMAPPER_EN,     [ %0d ]",subgroup.name(), 1));
    end
    else begin
      $fwrite(fptr,"%s\n",$sformatf("%s.AGC_EN,          [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXPSDU_EN,       [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXFRONTEND_EN,   [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXVECTOR_EN,     [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.EQUALIZER_EN,    [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXDEMAP_EN,      [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXSBCOMPRESS_EN, [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RX_BPBF_EN,      [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXFFT_EN,        [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXPARAMETERS_EN, [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXTBE_EN,        [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.FINETDFO_EN,     [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.COARSETDFO_EN,   [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.BF_EN,           [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXSOFTBITGEN_EN, [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXDECODER_EN,    [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.RXRF_EN,         [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.FDOFFSET_EN,     [ %0d ]",subgroup.name(), 1));
      $fwrite(fptr,"%s\n",$sformatf("%s.TXPARAMETERS_EN, [ %0d ]",subgroup.name(), 1));
    end

    if (golden_frame.kind != NDP)
      $fwrite(fptr,"%s\n",$sformatf("%s.TBOFFSET_EN,     [ %0d ]",subgroup.name(), 1));

    // set TX vector parameters
    subgroup = TXV;
    if (golden_frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM, HT_MF, HT_GF, VHT}) begin
      if (golden_frame.preamble_header.service[6:0] != 0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ]",subgroup.name(),
        golden_frame.preamble_header.service[6:0]));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ]",subgroup.name(),
        scrambler_initial_state));
      end
    end

    $fwrite(fptr,"%s\n",$sformatf("%s.FORMAT,            [ '%s' ]",subgroup.name(),
    (golden_frame.ppdu_format == NON_HT_DUP_OFDM) ? "NON_HT"   :
    (golden_frame.ppdu_format == HE_EXT_SU)       ? "HE_ER_SU" :
    golden_frame.ppdu_format.name()));

    non_ht_modulation = (golden_frame.ppdu_format == NON_HT_DUP_OFDM) ? "NON_HT_DUP_OFDM"
                        :(is_ndp_active()) ? "OFDM"
                        :(golden_frame.preamble_header.leg_rate inside {[0:3]}) ? "DSSS-CCK"
                        : "OFDM";
    $fwrite(fptr,"%s\n",$sformatf("%s.NON_HT_MODULATION, [ '%s' ]",subgroup.name(),
    non_ht_modulation));

    if (golden_frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM, HT_MF, HT_GF, HE_TB}) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.L_LENGTH,          [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.leg_length));
    end

    $fwrite(fptr,"%s\n",$sformatf("%s.L_DATARATE,        [ %s ]",subgroup.name(),
    golden_frame.preamble_header.decode_leg_rate_string()));

    $fwrite(fptr,"%s\n",$sformatf("%s.CH_BANDWIDTH,      [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.ch_bw));

    $fwrite(fptr,"%s\n",$sformatf("%s.SMOOTHING,         [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.smoothing));

    $fwrite(fptr,"%s\n",$sformatf("%s.SOUNDING,          [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.sounding));

    $fwrite(fptr,"%s\n",$sformatf("%s.AGGREGATION,       [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.aggregated));

    $fwrite(fptr,"%s\n",$sformatf("%s.STBC,              [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.stbc));

    $fwrite(fptr,"%s\n",$sformatf("%s.PREAMBLE_TYPE,     [ %0d ]",subgroup.name(),
    ~golden_frame.preamble_header.preamble_type)); //inverted logic from PPDU preamble header

    $fwrite(fptr,"%s\n",$sformatf("%s.GI_TYPE,           [ %s ]",subgroup.name(),
    (golden_frame.ppdu_format inside {HE_SU, HE_MU, HE_EXT_SU, HE_TB})
    ? gi_type_to_string(golden_frame.preamble_header.gi_type)
    : (golden_frame.preamble_header.gi_type[0]) ? "0.4" : "0.8"));

    $fwrite(fptr,"%s\n",$sformatf("%s.TXPWR_LEVEL_INDEX, [ %0d ]",subgroup.name(),
    golden_frame.preamble_header.tx_pwr_level));

    if (golden_frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM}) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.TRIGGER_RESPONDING,[ %0d ]",subgroup.name(),
      golden_frame.preamble_header.trigger_responding));
    end

    // TODO: when supported uncomment
    //$fwrite(fptr,"%s\n",$sformatf("%s.BEAMFORMED,        [ %0d ]",subgroup.name(),
    //golden_frame.preamble_header.beamformed));

    if (golden_frame.ppdu_format == VHT) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.GROUP_ID,          [ %0d ]",subgroup.name(),
      (is_ndp_active()) ? 0 : golden_frame.preamble_header.group_id));

      $fwrite(fptr,"%s\n",$sformatf("%s.PARTIAL_AID,       [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.partial_aid));

      $fwrite(fptr,"%s\n",$sformatf("%s.TXOP_PS_NOT_ALLOWED,[ %0d ]",subgroup.name(),
      golden_frame.preamble_header.doze_not_allowed));
    end

    $fwrite(fptr,"%s\n",$sformatf("%s.NUM_USERS,         [ %0d ]",subgroup.name(),
    (is_ndp_active()) ? 1 : golden_frame.num_of_users));

    if (golden_frame.ppdu_format inside {HT_MF,HT_GF}) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.LENGTH,            [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.user_header[0].ht_length_f));
    end

    // HE frames specific parameters
    if (golden_frame.ppdu_format inside {HE_SU, HE_MU, HE_TB, HE_EXT_SU}) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.BSS_COLOR,         [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.bss_color));

      $fwrite(fptr,"%s\n",$sformatf("%s.HE_LTF_TYPE,       [ %0d ]",subgroup.name(),
      (golden_frame.preamble_header.he_ltf_type == 0) ? 1 : golden_frame.preamble_header.he_ltf_type*2));

      $fwrite(fptr,"%s\n",$sformatf("%s.TXOP_DURATION,     [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.txop_duration));

      $fwrite(fptr,"%s\n",$sformatf("%s.BEAM_CHANGE,       [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.beam_change));

      $fwrite(fptr,"%s\n",$sformatf("%s.UPLINK_FLAG,       [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.uplink_flag));

      if (golden_frame.ppdu_format == HE_TB) begin
        spatial_reuse_tb = {golden_frame.preamble_header.spatial_reuse[3],
                            golden_frame.preamble_header.spatial_reuse[2],
                            golden_frame.preamble_header.spatial_reuse[1],
                            golden_frame.preamble_header.spatial_reuse[0]};
        $fwrite(fptr,"%s\n",$sformatf("%s.SPATIAL_REUSE,     [ %0d ]",subgroup.name(),
        spatial_reuse_tb));
        $fwrite(fptr,"%s\n",$sformatf("%s.LDPC_EXTRA_SYMBOL, [ %0d ]",subgroup.name(),
        golden_frame.preamble_header.ldpc_extra_symbol));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SPATIAL_REUSE,     [ %0d ]",subgroup.name(),
        golden_frame.preamble_header.spatial_reuse[0]));
      end

      $fwrite(fptr,"%s\n",$sformatf("%s.DOPPLER,           [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.doppler));

      if (golden_frame.preamble_header.doppler) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.MIDAMBLE_PERIODICITY, [ %0d ]",subgroup.name(),
        (golden_frame.preamble_header.midamble_periodicity) ? 20 : 10));
      end

    end

    if (golden_frame.ppdu_format inside {HE_TB, HE_MU}) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.NUM_HE_LTF,        [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.num_he_ltf + 1));
    end

    // HE frames specific parameters
    if (golden_frame.ppdu_format == HE_MU) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.MCS_SIG_B,         [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.mcs_sig_b));

      $fwrite(fptr,"%s\n",$sformatf("%s.DCM_SIG_B,         [ %0d ]",subgroup.name(),
      golden_frame.preamble_header.dcm_sig_b));

      $fwrite(fptr,"%s\n",$sformatf("%s.SIG_B_COMPRESSION_MODE,[ %0d ]",subgroup.name(),
      golden_frame.preamble_header.sig_b_comp_mode));
    end


    // HT USER HEADER FIELDS
    foreach (golden_frame.preamble_header.user_header[i]) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.FEC_CODING,        [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header[i].fec_coding_f,
      (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      $fwrite(fptr,"%s\n",$sformatf("%s.MCS,               [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header[i].mcs_f,
      (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      $fwrite(fptr,"%s\n",$sformatf("%s.NUM_STS,           [ %0d ], %s",subgroup.name(), //1st arg
      golden_frame.preamble_header.user_header[i].num_sts_f+1,                           //2nd arg
      (is_mumimo_active()) ?$sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));          //3rd arg

      $fwrite(fptr,"%s\n",$sformatf("%s.USER_POSITION,     [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header[i].user_position_f,
      (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      if (!(golden_frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM})) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.APEP_LENGTH,       [ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.user_header[i].ht_length_f,
        (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
      end

      $fwrite(fptr,"%s\n",$sformatf("%s.EXPANSION_MAT_IND, [ %0d ], %s",subgroup.name(),
      (is_ndp_active() || is_mumimo_active()) ? 0 : STAIDList[i], // SMM index from preamble_header is not used in testcase file
      (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
    end//foreach

    if (golden_frame.ppdu_format == HE_MU) begin
      $fwrite(fptr,"%s\n",$sformatf("%s.STA_ID_LIST,     [ %s ]",subgroup.name(),
      station_list(`STAID_OFFSET)));
    end

    // RU allocation
    if (golden_frame.ppdu_format == HE_MU) begin
      if (golden_frame.preamble_header.ch_bw == 1 && golden_frame.preamble_header.ru_allocation < 200) begin
        if (primary_channel == 1)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ 0  %0d ]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
        else if (primary_channel == 0)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ %0d  0 ]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
      end
      else if (golden_frame.preamble_header.ch_bw == 2 && golden_frame.preamble_header.ru_allocation < 208) begin
        if (primary_channel == 3)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ 0  0  0  %0d ]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
        else if (primary_channel == 2)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ 0  0  %0d  0 ]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
        else if (primary_channel == 1)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ 0  %0d  0  0 ]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
        else if (primary_channel == 0)
          $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ %0d  0  0  0]",subgroup.name(),
          golden_frame.preamble_header.ru_allocation[7:0]));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ %0d ]",subgroup.name(),
        golden_frame.preamble_header.ru_allocation[7:0]));
      end
    end

    // HE USER HEADER FIELDS
    foreach (golden_frame.preamble_header.user_header_he[i]) begin

      $fwrite(fptr,"%s\n",$sformatf("%s.DCM,               [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.dcm,
      (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (golden_frame.ppdu_format == HE_MU && is_mumimo_active() == 0) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      if (golden_frame.ppdu_format == HE_TB) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.RU_ALLOCATION,     [ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.ru_allocation[7:1],
        (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
        (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
      end

      if (golden_frame.preamble_header.service[6:0] != 0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.service[6:0],
        (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
        (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ], %s",subgroup.name(),
        scrambler_initial_state,
        (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
        (is_mumimo_active()) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
      end

      $fwrite(fptr,"%s\n",$sformatf("%s.FEC_CODING,        [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he[i].fec_coding_f,
      (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (is_mumimo_active() || golden_frame.ppdu_format inside {HE_TB, HE_MU}) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      $fwrite(fptr,"%s\n",$sformatf("%s.MCS,               [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he[i].mcs_f,
      (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (is_mumimo_active() || golden_frame.ppdu_format inside {HE_TB, HE_MU}) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      $fwrite(fptr,"%s\n",$sformatf("%s.NUM_STS,           [ %0d ], %s",subgroup.name(), //1st arg
      (golden_frame.preamble_header.stbc == 1) ? 2 : golden_frame.preamble_header.user_header_he[i].nss_f+1, //2nd arg
      (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (is_mumimo_active() || golden_frame.ppdu_format inside {HE_TB, HE_MU}) ?$sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));//3rd arg

      $fwrite(fptr,"%s\n",$sformatf("%s.APEP_LENGTH,       [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he[i].he_length_f,
      (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (is_mumimo_active() || golden_frame.ppdu_format inside {HE_TB, HE_MU}) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      $fwrite(fptr,"%s\n",$sformatf("%s.EXPANSION_MAT_IND, [ %0d ], %s",subgroup.name(),
      (is_mumimo_active()) ? 0 : STAIDList[i], // SMM index from preamble_header is not used in testcase file
      (direction == Tx && golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
      (is_mumimo_active() || golden_frame.ppdu_format inside {HE_TB, HE_MU}) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));

      if (golden_frame.ppdu_format inside {HE_SU, HE_EXT_SU, HE_MU}) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.NOMINAL_PACKET_PADDING,[ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.user_header_he[i].pkt_ext_f * 4,
        (direction == Tx &&  golden_frame.ppdu_format == HE_TB)   ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET-1) :
        (is_mumimo_active() || golden_frame.ppdu_format == HE_TB) ? $sformatf("%0d",STAIDList[i]+`STAID_OFFSET) : ""));
      end
      else if (golden_frame.ppdu_format == HE_TB) begin // HE_TB
        trigger_method = (golden_frame.preamble_header.trigger_method) ? "TRS" : "TRIGGER_FRAME";
        $fwrite(fptr,"%s\n",$sformatf("%s.TRIGGER_METHOD,    [ '%s' ]",subgroup.name(),
        trigger_method));

        // TRS trigger frame
        if (golden_frame.preamble_header.trigger_method) begin
          $fwrite(fptr,"%s\n",$sformatf("%s.DEFAULT_PE_DURATION,         [ %0d ]",subgroup.name(),
          golden_frame.preamble_header.user_header_he[i].pkt_ext_f*4));
        end
        else begin
          $fwrite(fptr,"%s\n",$sformatf("%s.HE_TB_PE_DISAMBIGUITY,       [ %0d ]",subgroup.name(),
          golden_frame.preamble_header.user_header_he[i].pkt_ext_f[2]));
          $fwrite(fptr,"%s\n",$sformatf("%s.HE_TB_PreFEC_Padding_Factor, [ %0d ]",subgroup.name(),
          golden_frame.preamble_header.user_header_he[i].pkt_ext_f[1:0]));
        end

        $fwrite(fptr,"%s\n",$sformatf("%s.HE_SIG_A2_RESERVED,          [ %0d ]",subgroup.name(),
        golden_frame.preamble_header.he_siga_reserved));
      end

    end//foreach

    // HE user header for secondary users
    foreach (golden_frame.preamble_header.user_header_he_sec[i]) begin
      staid.itoa(golden_frame.preamble_header.user_header_he_sec[i].staid_f);

      if (golden_frame.preamble_header.service[6:0] != 0) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.service[6:0],
        staid));
      end
      else begin
        $fwrite(fptr,"%s\n",$sformatf("%s.SCRAMBLER_INITIAL_STATE,   [ %0d ], %s",subgroup.name(),
        scrambler_initial_state,
        staid));
      end

      $fwrite(fptr,"%s\n",$sformatf("%s.FEC_CODING,        [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he_sec[i].fec_coding_f,
      staid));

      $fwrite(fptr,"%s\n",$sformatf("%s.MCS,               [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he_sec[i].mcs_f,
      staid));

      $fwrite(fptr,"%s\n",$sformatf("%s.NUM_STS,           [ %0d ], %s",subgroup.name(), //1st arg
      (golden_frame.preamble_header.stbc == 1) ? 2 : golden_frame.preamble_header.user_header_he_sec[i].nss_f+1, //2nd arg
      staid));//3rd arg

      $fwrite(fptr,"%s\n",$sformatf("%s.APEP_LENGTH,       [ %0d ], %s",subgroup.name(),
      golden_frame.preamble_header.user_header_he_sec[i].he_length_f,
      staid));

      $fwrite(fptr,"%s\n",$sformatf("%s.EXPANSION_MAT_IND, [ %0d ], %s",subgroup.name(),
      (is_mumimo_active()) ? 0 : STAIDList[i], // SMM index from preamble_header is not used in testcase file
      staid));

      if (golden_frame.ppdu_format inside {HE_SU, HE_EXT_SU, HE_MU}) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.NOMINAL_PACKET_PADDING,[ %0d ], %s",subgroup.name(),
        golden_frame.preamble_header.user_header_he_sec[i].pkt_ext_f * 4,
        staid));
      end
    end//foreach

    //increment scrambler init value
    if (scrambler_initial_state == 127)
      scrambler_initial_state = 1;
    // increment only when tx frame
    else if (direction == Tx)
      scrambler_initial_state++;

    subgroup = ERR;
    if (sig_error_injection) begin
      swap_sig = 0;

      if (golden_frame.ppdu_format inside {NON_HT,NON_HT_DUP_OFDM}) begin
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_LSIG,      [ %0d ]",subgroup.name(),l_sig));
        `uvm_info(get_type_name(),$sformatf("LSIG err injection - %p!!!",l_sig),UVM_LOW)
      end
      if (golden_frame.ppdu_format inside {HT_MF,HT_GF}) begin
        `uvm_info(get_type_name(),$sformatf("HTSIG err injection - %p!!!",ht_sig),UVM_LOW)
        for (int i=0; i<$bits(ht_sig); i++) swap_sig[i] = ht_sig[$bits(ht_sig)-1-i];
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_HTSIG,     [ %0d ]",subgroup.name(),swap_sig));
      end
      if (golden_frame.ppdu_format == VHT) begin
        `uvm_info(get_type_name(),$sformatf("VHTSIGA err injection - %p!!!",vht_siga_su),UVM_LOW)
        for (int i=0; i<$bits(vht_siga_su); i++) swap_sig[i] = vht_siga_su[$bits(vht_siga_su)-1-i];
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_VHTSIGA,   [ %0d ]",subgroup.name(),swap_sig));
      end
      if (golden_frame.ppdu_format inside {HE_SU,HE_EXT_SU}) begin
        `uvm_info(get_type_name(),$sformatf("HESIGA SU err injection - %p!!!",he_siga_su),UVM_LOW)
        for (int i=0; i<$bits(he_siga_su); i++) swap_sig[i] = he_siga_su[$bits(he_siga_su)-1-i];
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_HESIGA,   [ %0d ]",subgroup.name(),swap_sig));
      end
      if (golden_frame.ppdu_format == HE_MU) begin
        `uvm_info(get_type_name(),$sformatf("HESIGA MU err injection - %p!!!",he_siga_mu),UVM_LOW)
        for (int i=0; i<$bits(he_siga_mu); i++) swap_sig[i] = he_siga_mu[$bits(he_siga_mu)-1-i];
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_HESIGA,   [ %0d ]",subgroup.name(),swap_sig));
      end
      if (golden_frame.ppdu_format == HE_TB) begin
        `uvm_info(get_type_name(),$sformatf("HESIGA TB err injection - %p!!!",he_siga_tb),UVM_LOW)
        for (int i=0; i<$bits(he_siga_tb); i++) swap_sig[i] = he_siga_tb[$bits(he_siga_tb)-1-i];
        $fwrite(fptr,"%s\n",$sformatf("%s.Force_HESIGA,   [ %0d ]",subgroup.name(),swap_sig));
      end
    end

    // write file footer
    $fwrite(fptr, "# END FILE\n");
    $fclose(fptr);
  endfunction : write_testcase

  //--------------------------------------------------------------------
  // Executes Matlab DPI
  //--------------------------------------------------------------------
  virtual task execute(direction_e direction = Tx,
                       PPDU_frame  ppdu,
                       rf_gpio_t   rf_gpio = `GPIO_WIDTH'd27,
                       bit         agcBypass = 0);

    bit [3:0]   modemconf;
    bit [1:0]   controlChannel;
    bit [31:0]  rdata;
    int         user;
    string      fname;
    int         fhandle;

    // check input data to prevent unknown crashes
    if (rf_gpio == 'h0) begin
      `uvm_warning(get_type_name(), $sformatf("Setting rf_gpio = 0 will cause a Matlab crash!"))
    end

    //get register values
    rdata = m_regmodel.get_mirrored_reg_value("MDMCONF");
    modemconf = rdata[3:0]; //CHBW
    rdata = m_regmodel.get_mirrored_reg_value("RWNXMACSTATICCONFIG");
    controlChannel = rdata[1:0]; //PSSELECT

    if (direction == Tx)
      set_txcore_only_v(1);
    else
      set_txcore_only_v(0);

    // store frame locally
    golden_frame = new();
    golden_frame.copy(ppdu);

    `uvm_info(get_type_name(),
    $sformatf("Matlab configuration (direction = %s)", direction.name()), UVM_LOW)

    if (!use_preset_files) begin
      // create defSTA and test case files
      get_PPDU_params(golden_frame, direction);

      // Remove old patterns
      if (station_file_defined == 0)
        cleanMatlabWorkDir();
      // and write new ones
      if (station_file_defined == 0) begin
        write_STAparam(direction, agcBypass, modemconf, controlChannel);
        write_BSSparam();
      end

      write_testcase(direction,agcBypass);

      get_PPDU_payload(golden_frame);
      if (is_ndp_active() == 0)
        write_payload();
    end
    else begin
      `uvm_info(get_type_name(),
      $sformatf("Matlab will be re-run with preset SysParam and Payload files"),UVM_LOW)
      // check if payload file exists
      fname = {get_sysparam_dir_name(),`PAYLOAD_NAME, `PAYLOAD_EXT};
      fhandle = $fopen(fname, "r");
      if (fhandle == 0) begin
        use_matlab_payload = 1;
        `uvm_info(get_type_name(),"Payload file does not exist, matlab will generate payload for this frame", UVM_LOW)
      end
      else begin
        use_matlab_payload = 0;
      end
      $fclose(fhandle);
    end

    `uvm_info(get_type_name(),
    $sformatf("Executing Matlab (revision %0d)",getRevision_v()), UVM_LOW)

    if (use_preset_files) begin
      set_STAs_v({get_sysparam_dir_name(),`DEFSTA_NAME,`DEFSTA_EXT},     //defSTAs
                 {get_sysparam_dir_name(),`DEFBSS_NAME,`DEFBSS_EXT});    //defBSS
      exe_case_v({get_sysparam_dir_name(),`TESTCASE_NAME,`TESTCASE_EXT}, //test case
                 (use_matlab_payload) ? "" : {get_sysparam_dir_name(),`PAYLOAD_NAME, `PAYLOAD_EXT}); //payload files
    end
    else if (is_ndp_active()) begin
      set_STAs_v({get_sysparam_dir_name(),`DEFSTA_NAME,`DEFSTA_EXT},    //defSTAs
                 {get_sysparam_dir_name(),`DEFBSS_NAME,`DEFBSS_EXT});   //defBSS
      exe_case_v({get_sysparam_dir_name(),`NDPTESTCASE_NAME,`TESTCASE_EXT},//NDP test case
                 ""); // no payload file in case of NDP frame
    end
    else if (is_mumimo_active()) begin
      // determine user index
      if (golden_frame.ppdu_format == VHT)
        user = golden_frame.preamble_header.mu_mimo_userid;
      else if (golden_frame.ppdu_format == HE_MU)
        user = find_he_mu_user(golden_frame.preamble_header.mu_mimo_userid);

      set_STAs_v({get_sysparam_dir_name(),`DEFSTA_NAME,`DEFSTA_EXT},        //defSTAs
                 {get_sysparam_dir_name(),`DEFBSS_NAME,`DEFBSS_EXT});       //defBSS
      exe_case_v({get_sysparam_dir_name(),`TESTCASE_NAME,`TESTCASE_EXT},    //test case
                 {get_sysparam_dir_name(),get_phyPayload_file_name(user)}); //payload files
    end
    else begin
      set_STAs_v({get_sysparam_dir_name(),`DEFSTA_NAME,`DEFSTA_EXT},     //defSTAs
                 {get_sysparam_dir_name(),`DEFBSS_NAME,`DEFBSS_EXT});    //defBSS
      exe_case_v({get_sysparam_dir_name(),`TESTCASE_NAME,`TESTCASE_EXT}, //test case
                 {get_sysparam_dir_name(),get_phyPayload_file_name(0)}); //payload files
    end

    // Get data from Matlab
    if (direction == Tx) begin
      setup_tx_data();
      if (is_ndp_active()) begin
        setup_bf_data(direction, agcBypass);
      end
    end
    else begin// Rx
      setup_rx_data(rf_gpio, agcBypass, modemconf);
      if (is_ndp_active()) begin
        setup_bf_data(direction, agcBypass);
      end
    end

    // when NDP is executed defSTAs.txt must stay same for next frame,
    // else generate defSTAs.txt
    if (is_ndp_active() && sig_error_injection == 0)
      station_file_defined = 1;
    else
      station_file_defined = 0;

  endtask : execute

//--------------------------------------------------------------------
// This function reads Matlab outputs to generate RX FrontEnd outputs and
// RX configuration parameters
//--------------------------------------------------------------------
  virtual function void setup_rx_data(rf_gpio_t rf_gpio,
                                      bit       agcBypass = 0,
                                      bit [3:0] modemconf = 4'b100);

    int        max_agc_data;      // max value in for loops when agc is disabled
    int        data_size;         // returned Matlab array size
    int        RFdata_size;       // returned Matlab array size
    int        mu_mimo_idx;
    bit [31:0] values[];
    bit [31:0] data_read_re[];
    bit [31:0] data_read_im[];
    bit [31:0] data_read_rssi[];
    bit [31:0] data_read_ant[];
    string     param;
    int        stbc;

    bit [31:0] karst_gain_idx[];
    bit [31:0] karst_matlab_cmd[];  // remnant of old code, unused, DPI code still needs it

    karst_gain_idx = new[2];
    karst_matlab_cmd = new[1];
    karst_matlab_cmd[0] = 32'hFFFFFFFF;
    karst_gain_idx[0] = {26'd0, rf_gpio[5:0]};
    karst_gain_idx[1] = {26'd0, rf_gpio[5:0]};

    // Matlab Rx Vector Dump
    if (golden_frame.ppdu_format inside {HT_MF,VHT}) begin
      // overwrite some of the params
      if (is_mumimo_active()) begin
        mu_mimo_idx = golden_frame.preamble_header.mu_mimo_userid;

        data_size = getDataSize_v("RXVECTOR", "PSDU_LENGTH");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "PSDU_LENGTH", "REAL");
        golden_frame.preamble_header.user_header[mu_mimo_idx].ht_length_f = values[0];

        data_size = getDataSize_v("RXVECTOR", "NUM_STS");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "NUM_STS", "REAL");
        golden_frame.preamble_header.user_header[mu_mimo_idx].num_sts_f = values[0]-1;

        data_size = getDataSize_v("RXVECTOR", "L_LENGTH");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "L_LENGTH", "REAL");
        golden_frame.preamble_header.leg_length = values[0];
      end
      else begin
        param = (golden_frame.ppdu_format == VHT) ? "PSDU_LENGTH" : "LENGTH";

        data_size = getDataSize_v("RXVECTOR", param);
        values = new[data_size];
        getData_v(values, "RXVECTOR", param, "REAL");
        golden_frame.preamble_header.user_header[0].ht_length_f = values[0];

        data_size = getDataSize_v("RXVECTOR","STBC");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "STBC", "REAL");
        stbc = values[0];

        data_size = getDataSize_v("RXVECTOR", "NUM_STS");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "NUM_STS", "REAL");
        golden_frame.preamble_header.user_header[0].num_sts_f = values[0]/(2**stbc)-1;

        data_size = getDataSize_v("RXVECTOR", "L_LENGTH");
        values = new[data_size];
        getData_v(values, "RXVECTOR", "L_LENGTH", "REAL");
        golden_frame.preamble_header.leg_length = values[0];
      end
    end
    else if (golden_frame.ppdu_format == HE_SU) begin
      data_size = getDataSize_v("RXVECTOR","STBC");
      values = new[data_size];
      getData_v(values, "RXVECTOR", "STBC", "REAL");
      stbc = values[0];

      data_size = getDataSize_v("RXVECTOR", "NUM_STS");
      values = new[data_size];
      getData_v(values, "RXVECTOR", "NUM_STS", "REAL");
      golden_frame.preamble_header.user_header_he[0].nss_f = values[0]/(2**stbc)-1;
    end
    else if (golden_frame.ppdu_format == HE_MU && is_mumimo_active()) begin
      data_size = getDataSize_v("RXVECTOR", "PSDU_LENGTH");
      values = new[data_size];
      getData_v(values, "RXVECTOR", "PSDU_LENGTH", "REAL");
      golden_frame.preamble_header.user_header_he[golden_frame.preamble_header.mu_mimo_userid].he_length_f = values[0];
    end

    // when AGC is bypassed antenna set can't be updated, so it is set to
    // 0 because in RxVector collected on MAC-PHY interface will be 0
    if ((`AGC_ON == 0) || (agcBypass == 1)) begin
      golden_frame.preamble_header.antenna_set = 0;
    end

    if ((`AGC_ON == 1) && (agcBypass == 0)) begin
      data_size    = getDataSize_v("AGC", "dsp_rxADC");
      //getBlockList_v("AGC");
      // Initialize ADC data
      data_read_re   = new[data_size];
      data_read_im   = new[data_size];
      data_read_ant  = new[data_size];
      getData_v(data_read_re,  "AGC", "dsp_rxADC", "REAL");
      getData_v(data_read_im,  "AGC", "dsp_rxADC", "IMAG");
      getData_v(data_read_ant, "AGC", "dsp_rxADC", "ANT");

      // Initialize RF data
      data_read_rssi = new[data_size];
      `uvm_info(get_type_name(), $sformatf("[setup_rx_data] :: SetGAIN : hash idx = %1d",karst_gain_idx[0]), UVM_DEBUG)
      RFdata_size = setGain_v(data_read_re,data_read_im,data_read_rssi,0,karst_gain_idx,karst_matlab_cmd);

      // Initialize RF data
      data_read_re   = new[RFdata_size];
      data_read_im   = new[RFdata_size];
      RFDataI        = new[RFdata_size];
      RFDataQ        = new[RFdata_size];
      data_read_rssi = new[RFdata_size];

      RFdata_size = setGain_v(data_read_re,data_read_im,data_read_rssi,int'('d16),karst_gain_idx,karst_matlab_cmd);
      for (int i=0; i<RFdata_size; i++) begin
        RFDataI[i] = data_read_re[i];
        RFDataQ[i] = data_read_im[i];
      end

      foreach (RFDataI[i])
        `uvm_info(get_type_name(), $sformatf("[setup_rx_data] :: RFDataI[%0d]=0x%x RFDataQ[%0d]=0x%x", i, RFDataI[i], i, RFDataQ[i]), UVM_DEBUG)

      // ADC extraction
      RFframe_re  = new[RFdata_size];
      RFframe_im  = new[RFdata_size];

      for (int j=0; j < `ANTENNA_NR; j++) begin
        for (int i=0; i<(RFdata_size/`RW_NX_DERIV_NRX) ; i++) begin
          RFframe_re[i][j] = RFDataI[i+j*(RFdata_size/(`RW_NX_DERIV_NRX))];
          RFframe_im[i][j] = RFDataQ[i+j*(RFdata_size/(`RW_NX_DERIV_NRX))];
        end
      end

    end


    ////////////////////////////
    // RXFRONTEND dump
    ////////////////////////////
    if ((`AGC_ON == 0) || (agcBypass == 1)) // AGC BYPASSED
    begin
      //getBlockList_v("RXFRONTEND");
      // RXFRONTEND dump
      `ifdef RW_NX_DERIV_PATH1
        if (`RW_NX_DERIV_NRX>=2) begin
          max_agc_data = 2;
        end else begin
          max_agc_data = 1;
        end
      `else
        max_agc_data = 1;
      `endif

      if (golden_frame.ppdu_format != NON_HT || golden_frame.preamble_header.leg_rate > 3) begin
        data_size    = getDataSize_v("RXFRONTEND", "rxFEoutSync20");
        data_read_re = new[data_size];
        data_read_im = new[data_size];
        rxFEout20Re  = new[data_size];
        rxFEout20Im  = new[data_size];
        getComplexData_v(data_read_re,data_read_im, "RXFRONTEND", "rxFEoutSync20");
        for (int i=0; i<data_size; i++) begin
          rxFEout20Re[i] = data_read_re[i];
          rxFEout20Im[i] = data_read_im[i];
        end

        rxFEout20_re = new[data_size/`RW_NX_DERIV_NRX];
        rxFEout20_im = new[data_size/`RW_NX_DERIV_NRX];

        for (int j=0; j<max_agc_data; j++) begin
          for (int i=0; i<(data_size/`RW_NX_DERIV_NRX); i++) begin
            rxFEout20_re[i][j] = rxFEout20Re[i+j*(data_size/(`RW_NX_DERIV_NRX))];
            rxFEout20_im[i][j] = rxFEout20Im[i+j*(data_size/(`RW_NX_DERIV_NRX))];
          end
        end
      end
      else begin
        data_size     = getDataSize_v("RXFRONTEND", "rxFEoutSyncDSSS");
        data_read_re  = new[data_size];
        data_read_im  = new[data_size];
        rxFEout20DSSSRe = new[data_size];
        rxFEout20DSSSIm = new[data_size];
        getComplexData_v(data_read_re,data_read_im, "RXFRONTEND", "rxFEoutSyncDSSS");
        for (int i=0; i<data_size; i++)
        begin
          rxFEout20DSSSRe[i] = data_read_re[i];
          rxFEout20DSSSIm[i] = data_read_im[i];
        end
      end

      if (   (RxChannelBW >= 40) && (modemconf >= 'd1)
          && (golden_frame.ppdu_format != NON_HT || golden_frame.preamble_header.leg_rate > 3)) begin
        data_size     = getDataSize_v("RXFRONTEND", "rxFEoutSync20s");
        data_read_re  = new[data_size];
        data_read_im  = new[data_size];
        rxFEout20SRe  = new[data_size];
        rxFEout20SIm  = new[data_size];
        getComplexData_v(data_read_re,data_read_im, "RXFRONTEND", "rxFEoutSync20s");
        for (int i=0; i<data_size; i++) begin
          rxFEout20SRe[i] = data_read_re[i];
          rxFEout20SIm[i] = data_read_im[i];
        end

        rxFEout20S_re = new[data_size/`RW_NX_DERIV_NRX];
        rxFEout20S_im = new[data_size/`RW_NX_DERIV_NRX];

        for (int j=0; j<max_agc_data; j++) begin
          for (int i=0; i<(data_size/`RW_NX_DERIV_NRX); i++) begin
            rxFEout20S_re[i][j] = rxFEout20SRe[i+j*(data_size/(`RW_NX_DERIV_NRX))];
            rxFEout20S_im[i][j] = rxFEout20SIm[i+j*(data_size/(`RW_NX_DERIV_NRX))];
          end
        end

        data_size    = getDataSize_v("RXFRONTEND", "rxFEoutSync40");
        data_read_re = new[data_size];
        data_read_im = new[data_size];
        rxFEout40Re  = new[data_size];
        rxFEout40Im  = new[data_size];
        getComplexData_v(data_read_re,data_read_im, "RXFRONTEND", "rxFEoutSync40");
        for (int i=0; i<data_size; i++) begin
          rxFEout40Re[i] = data_read_re[i];
          rxFEout40Im[i] = data_read_im[i];
        end


        rxFEout40_re = new[data_size/`RW_NX_DERIV_NRX];
        rxFEout40_im = new[data_size/`RW_NX_DERIV_NRX];

        for (int j=0; j<max_agc_data; j++) begin
          for (int i=0; i<(data_size/`RW_NX_DERIV_NRX); i++) begin
            rxFEout40_re[i][j] = rxFEout40Re[i+j*(data_size/(`RW_NX_DERIV_NRX))];
            rxFEout40_im[i][j] = rxFEout40Im[i+j*(data_size/(`RW_NX_DERIV_NRX))];
          end
        end
      end

      if (   (RxChannelBW == 80) && (modemconf >= 'd2)
          && (golden_frame.ppdu_format != NON_HT || golden_frame.preamble_header.leg_rate > 3))
      begin
        data_size    = getDataSize_v("RXFRONTEND", "rxFEoutSync80");
        data_read_re = new[data_size];
        data_read_im = new[data_size];
        rxFEout80Re  = new[data_size];
        rxFEout80Im  = new[data_size];
        getComplexData_v(data_read_re,data_read_im, "RXFRONTEND", "rxFEoutSync80");
        for (int i=0;i<data_size; i++) begin
          rxFEout80Re[i] = data_read_re[i];
          rxFEout80Im[i] = data_read_im[i];
        end

        rxFEout80_re = new[data_size/`RW_NX_DERIV_NRX];
        rxFEout80_im = new[data_size/`RW_NX_DERIV_NRX];

        for (int j=0; j<max_agc_data; j++) begin
          for (int i=0; i<(data_size/`RW_NX_DERIV_NRX); i++) begin
            rxFEout80_re[i][j] = rxFEout80Re[i+j*(data_size/(`RW_NX_DERIV_NRX))];
            rxFEout80_im[i][j] = rxFEout80Im[i+j*(data_size/(`RW_NX_DERIV_NRX))];
          end
        end

      end

      //get noise variance
      data_size = getDataSize_v("RXPARAMETERS", "sigma_dB");
      values = new[data_size];
      getData_v(values, "RXPARAMETERS", "sigma_dB", "REAL");
      noise_variance = values[0];
    end//if AGC bypassed

    // setting RXPARAMETERS
    set_rxparams();

  endfunction: setup_rx_data

//-----------------------------------------------------------------
// This function creates a TX Frame by reading Matlab outputs
// and generate both input patterns and outputs reference patterns
//-----------------------------------------------------------------
  virtual function void setup_tx_data();
    int data_size;        // returned Matlab array size
    int fhandle;

    bit signed [`DACWIDTH-1:0]  DAC_ref_re_out[];
    bit signed [`DACWIDTH-1:0]  DAC_ref_im_out[];

    bit [31:0] data_read_re[];
    bit [31:0] data_read_im[];
    bit [31:0] data_read_index[];
    bit [31:0] data_read_nsymb[];
    bit [31:0] data_read_indsymb[];

    // clear existing data
    TxframeOut_re.delete();
    TxframeOut_im.delete();
    // SIG values reset
    l_sig      = 0;
    ht_sig     = 0;
    he_siga_su = 0;
    he_siga_tb = 0;
    he_siga_mu = 0;
    he_sigb    = 0;

    // Tx Encoder
    //getBlockList_v("TXENCODER");

    data_size    = getDataSize_v("TXENCODER", "L_SIG_input_encoder");
    data_read_re = new[data_size];
    getData_v(data_read_re, "TXENCODER", "L_SIG_input_encoder", "REAL");
    for (int i=0; i<data_size; i++)
      l_sig[i] = data_read_re[i];
    if (data_size)
      `uvm_info(get_type_name(),$sformatf("L-SIG: %p", l_sig),UVM_HIGH)

    data_size    = getDataSize_v("TXENCODER", "HT_SIG_input_encoder");
    data_read_re = new[data_size];
    getData_v(data_read_re, "TXENCODER", "HT_SIG_input_encoder", "REAL");
    for (int i=0; i<data_size; i++)
      ht_sig[i] = data_read_re[i];
    if (data_size)
      `uvm_info(get_type_name(),$sformatf("HT-SIG: %p", ht_sig),UVM_HIGH)

    data_size    = getDataSize_v("TXENCODER", "HE_SIGA_input_encoder");
    data_read_re = new[data_size];
    getData_v(data_read_re, "TXENCODER", "HE_SIGA_input_encoder", "REAL");
    for (int i=0; i<data_size; i++) begin
      case (golden_frame.ppdu_format)
        HE_SU,HE_EXT_SU: he_siga_su[i] = data_read_re[i];
        HE_TB:           he_siga_tb[i] = data_read_re[i];
        HE_MU:           he_siga_mu[i] = data_read_re[i];
      endcase
    end
    if (data_size) begin
      case (golden_frame.ppdu_format)
        HE_SU,HE_EXT_SU: `uvm_info(get_type_name(),$sformatf("HE-SIGA: %p", he_siga_su),UVM_HIGH)
        HE_TB:           `uvm_info(get_type_name(),$sformatf("HE-SIGA: %p", he_siga_tb),UVM_HIGH)
        HE_MU:           `uvm_info(get_type_name(),$sformatf("HE-SIGA: %p", he_siga_mu),UVM_HIGH)
      endcase
    end


    data_size    = getDataSize_v("TXENCODER", "HE_SIGB_input_encoder");
    data_read_re = new[data_size];
    getData_v(data_read_re, "TXENCODER", "HE_SIGB_input_encoder", "REAL");
    for (int i=0; i<data_size; i++)
      he_sigb[i] = data_read_re[i];
    if (data_size)
      `uvm_info(get_type_name(),$sformatf("HE-SIGB: %p", he_sigb),UVM_HIGH)

    // DAC
    data_size = getDataSize_v("TXFRONTEND", "txDAC");

    DAC_ref_re_out   = new[data_size];
    DAC_ref_im_out   = new[data_size];
    data_read_re     = new[data_size];
    data_read_im     = new[data_size];

    getComplexData_v(data_read_re,data_read_im, "TXFRONTEND", "txDAC");

    for (int i=0; i<data_size; i++) begin
      DAC_ref_re_out[i] = data_read_re[i];
      DAC_ref_im_out[i] = data_read_im[i];
    end

    // Tx CORE
    TxCoreOut.delete();

    //getBlockList_v("TXCORE");
    data_size = getDataSize_v("TXCORE", "txcore");

    TxCoreOut    = new[data_size];
    data_read_re = new[data_size];
    data_read_im = new[data_size];


    getData_v(data_read_re, "TXCORE", "txcore", "REAL");
    getData_v(data_read_im, "TXCORE", "txcore", "IMAG");

    for (int i=0; i<data_size; i++) begin
      TxCoreOut[i].enable_f = 1;
      TxCoreOut[i].re_f = data_read_re[i];
      TxCoreOut[i].im_f = data_read_im[i];
    end

    //TXMAPPER
    TxMapOut.delete();

`ifdef DEBUG_SAMPLES
    fhandle = $fopen("tx_mapper_ref_samples.txt","w");
`endif

    //getBlockList_v("TXMAPPER");
    data_size = getDataSize_v("TXMAPPER", "txmap_out");

    TxMapOut = new[data_size];
    data_read_re = new[data_size];
    data_read_im = new[data_size];
    data_read_index = new[data_size];
    data_read_nsymb = new[data_size];
    data_read_indsymb = new[data_size];

    getData_v(data_read_re,    "TXMAPPER", "txmap_out", "REAL");
    getData_v(data_read_im,    "TXMAPPER", "txmap_out", "IMAG");
    getData_v(data_read_index, "TXMAPPER", "txmap_out", "INDSC");
    getData_v(data_read_nsymb, "TXMAPPER", "txmap_out", "NSymb");
    getData_v(data_read_indsymb, "TXMAPPER", "txmap_out", "INDSYMB");

    // fill mapper reference data structure
    for (int i=0; i<data_size; i++) begin
      TxMapOut[i].re_f  = data_read_re[i];
      TxMapOut[i].im_f  = data_read_im[i];
      TxMapOut[i].index_f = data_read_index[i];
      TxMapOut[i].symb_idx_f = data_read_indsymb[i];
`ifdef DEBUG_SAMPLES
      $fwrite(fhandle,"%s\n",$sformatf("%s",TXMAP2string(TxMapOut[i])));
`endif
    end

`ifdef DEBUG_SAMPLES
    $fclose(fhandle);
`endif
    ////////////////////////////////////
    // FRAME GENERATION               //
    ////////////////////////////////////
    // DSSS-CCK
    if (golden_frame.ppdu_format == NON_HT && golden_frame.preamble_header.leg_rate <= 'd3) begin
      data_size = DAC_ref_re_out.size();
      // for DSSS, store samples in position for Tx path 0
      TxframeOut_re = new[data_size];
      TxframeOut_im = new[data_size];

      for (int i=0; i<(data_size) ; i++) begin
        TxframeOut_re[i][0] = DAC_ref_re_out[i];
        TxframeOut_im[i][0] = DAC_ref_im_out[i];
        if (nTx > 1) begin
          // If system has two antennae, the same data is expected on both!
          TxframeOut_re[i][1] = DAC_ref_re_out[i];
          TxframeOut_im[i][1] = DAC_ref_im_out[i];
        end

      end
    end else begin
      data_size = DAC_ref_re_out.size();

      TxframeOut_re = new[data_size/nTx];
      TxframeOut_im = new[data_size/nTx];

      for (int j=0; j < nTx; j++) begin
        for (int i=0; i<(data_size/nTx) ; i++) begin
          TxframeOut_re[i][j] = DAC_ref_re_out[i+j*(data_size/nTx)];
          TxframeOut_im[i][j] = DAC_ref_im_out[i+j*(data_size/nTx)];
        end // for i
      end  // for j
    end // else
  endfunction: setup_tx_data

//-------------------------------------------------------------------
// This function reads Matlab outputs to generate beamforming outputs
//-------------------------------------------------------------------
  virtual function void setup_bf_data(direction_e direction, bit agcBypass);

    int        data_size;       // returned Matlab array size
    bit [31:0] data_read_re[];
    bit [31:0] data_read_im[];

    // fetch from Matlab content of H-memory
    get_h_mem_data();

    // In case of Beamformer scenario, dump the beamforming report
    // for future use
    if (direction == Tx) begin
      for (int idx=0; idx<nBeamformingSTA; idx++) begin
        `uvm_info(get_type_name(), $sformatf("[setup_bf_data] :: Dumping BF report for STATION %0d", idx+1), UVM_DEBUG)
        // change observation
        set_observation_ax_v(idx+1);
        data_size     = getDataSize_v("BF","report");
        data_read_re  = new[data_size];
        bfr           = new[data_size];
        getData_v(data_read_re,"BF","report","REAL");
        for (int j=0;j<data_size;j=j+1) begin
           bfr[j] = data_read_re[j];
        end
        txBfrLength[idx] = data_size;
        for (int i=0; i< data_size; i=i+1) begin
          txBfrCompressedReport[idx][i] = bfr[i] & 1'b1;
        end
      end
      // set observation to default value
      set_observation_ax_v(1);

    end else begin
      //getBlockList_v("BF");
      // Report used in RX - backward compatible
      `uvm_info(get_type_name(), $sformatf("[setup_bf_data] :: Dumping BF report"), UVM_DEBUG)
      data_size     = getDataSize_v("BF","report");
      data_read_re  = new[data_size];
      bfr           = new[data_size];
      getData_v(data_read_re,"BF","report","REAL");
      for (int j=0;j<data_size;j=j+1) begin
         bfr[j] = data_read_re[j];
      end

    end

    if ((`AGC_ON == 0) || (agcBypass == 1)) begin
      //AGC BYPASSED
      //Dump BF sig_dB
      data_size = getDataSize_v("BF","sig_dB");
      data_read_re     = new[data_size];
      bfr_sigmadB      = new[data_size];

      getData_v(data_read_re,"BF","sig_dB","REAL");
      for (int j=0;j<data_size;j=j+1) begin
        bfr_sigmadB[j] = data_read_re[j];
      end

      if (!is_ndp_active() &&
          ((golden_frame.preamble_header.user_header[0].mcs_f > 7 && golden_frame.ppdu_format inside {HT_MF,HT_GF,VHT}) ||
           (golden_frame.ppdu_format == VHT && get_nss_func(golden_frame.preamble_header.user_header[0].mcs_f,
                                                            VHT,
                                                            golden_frame.preamble_header.ch_bw,
                                                            golden_frame.preamble_header.user_header[0].num_sts_f,
                                                            golden_frame.preamble_header.stbc) == 2)
          ))  begin
        //"Dump Equalyzer sigmae2
        data_size = getDataSize_v("EQUALIZER","sigmae2");
        data_read_re        = new[data_size];
        getData_v(data_read_re,"EQUALIZER","sigmae2","REAL");
        sigmae2 = data_read_re[0];
      end
      else begin
        sigmae2 = 0;
      end
    end

  endfunction : setup_bf_data

//-------------------------------------------------------------------
// This function reads Matlab to get H memory content
//-------------------------------------------------------------------
  virtual function void get_h_mem_data();
    int        data_size;       // returned Matlab array size
    bit [31:0] data_read_re[];
    bit [31:0] data_read_im[];
    bit [31:0] index_data[];

    // Dump BF HFFT
    data_size = getDataSize_v("BF","HFFT");
    data_read_re  = new[data_size];
    data_read_im  = new[data_size];
    index_data    = new[data_size];
    hmem_ref_data = new[data_size];

    getComplexData_v(data_read_re,data_read_im,"BF","HFFT");
    getData_v(index_data, "BF", "HFFT", "INDSC");
    for (int j=0;j<data_size;j++) begin
      hmem_ref_data[j].re_f    = data_read_re[j];
      hmem_ref_data[j].im_f    = data_read_im[j];
      hmem_ref_data[j].index_f = index_data[j];
    end
  endfunction : get_h_mem_data

//--------------------------------------------------------------------
// Copies reference data (TXCORE samples) to caller
//--------------------------------------------------------------------
  virtual function void get_txcore_data(ref TXCORE_data_s fe_data[]);

    if (TxCoreOut.size() > 0) begin
      fe_data = new[TxCoreOut.size()](TxCoreOut);
    end else begin
      `uvm_error(get_type_name(), $sformatf("[get_txcore_data] :: No data to copy - run task execute() first!"))
    end
  endfunction : get_txcore_data

//--------------------------------------------------------------------
// Copies reference data (TXMAPPER samples) to caller
//--------------------------------------------------------------------
  virtual function void get_txmapper_data(ref TXMAP_data_s map_data[]);

    if (TxMapOut.size() > 0) begin
      map_data = new[TxMapOut.size()](TxMapOut);
    end else begin
      `uvm_error(get_type_name(), $sformatf("[get_txmapper_data] :: No data to copy - run task execute() first!"))
    end
  endfunction : get_txmapper_data

//--------------------------------------------------------------------
// get soft bits referent data, compressed or un-compressed
//--------------------------------------------------------------------
  function soft_bits_array get_soft_bits(bit compressed);
    int        size;
    bit [31:0] values[];

    if (compressed) begin
      //getBlockList_v("RXSBCOMPRESS");
      size = getDataSize_v("RXSBCOMPRESS", "SBCOMPRESS_SoftBit_withINDSC");
      get_soft_bits = new[size];
      values = new[size];
      getData_v(values, "RXSBCOMPRESS", "SBCOMPRESS_SoftBit_withINDSC", "REAL");
      foreach (values[i]) get_soft_bits[i].real_comp_f = values[i];
      getData_v(values, "RXSBCOMPRESS", "SBCOMPRESS_SoftBit_withINDSC", "NSymb");
      foreach (values[i]) get_soft_bits[i].symb_f = values[i];
      getData_v(values, "RXSBCOMPRESS", "SBCOMPRESS_SoftBit_withINDSC", "INDSYMB");
      foreach (values[i]) get_soft_bits[i].indsymb_f = values[i];
      getData_v(values, "RXSBCOMPRESS", "SBCOMPRESS_SoftBit_withINDSC", "INDSC");
      foreach (values[i]) get_soft_bits[i].indsc_f = values[i];
    end//compressed
    else begin
      //getBlockList_v("RXDEMAP");
      size = getDataSize_v("RXDEMAP", "DEMAP_SoftBit_withINDSC");
      get_soft_bits = new[size];
      values = new[size];
      getData_v(values, "RXDEMAP", "DEMAP_SoftBit_withINDSC", "REAL");
      foreach (values[i]) get_soft_bits[i].real_f = values[i];
      getData_v(values, "RXDEMAP", "DEMAP_SoftBit_withINDSC", "NSymb");
      foreach (values[i]) get_soft_bits[i].symb_f = values[i];
      getData_v(values, "RXDEMAP", "DEMAP_SoftBit_withINDSC", "INDSYMB");
      foreach (values[i]) get_soft_bits[i].indsymb_f = values[i];
      getData_v(values, "RXDEMAP", "DEMAP_SoftBit_withINDSC", "INDSC");
      foreach (values[i]) get_soft_bits[i].indsc_f = values[i];
    end

  endfunction : get_soft_bits

//--------------------------------------------------------------------
// get DCM referent data
//--------------------------------------------------------------------
  function dcm_data_array get_dcm_input_samples();
    int         size;
    bit [31:0]  values[];
    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "DCMCOMBINER_LLRIn");
    get_dcm_input_samples = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLRIn", "REAL");
    foreach (values[i]) get_dcm_input_samples[i].real_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLRIn", "STREAM");
    foreach (values[i]) get_dcm_input_samples[i].stream_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLRIn", "SYMB");
    foreach (values[i]) get_dcm_input_samples[i].symb_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLRIn", "BIT");
    foreach (values[i]) get_dcm_input_samples[i].bit_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLRIn", "SEG");
    foreach (values[i]) get_dcm_input_samples[i].seg_f = values[i];

  endfunction

//--------------------------------------------------------------------
// get DCM referent data
//--------------------------------------------------------------------
  function dcm_data_array get_dcm_output_samples();
    int         size;
    bit [31:0]  values[];
    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "DCMCOMBINER_LLROut");
    get_dcm_output_samples = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLROut", "REAL");
    foreach (values[i]) get_dcm_output_samples[i].real_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLROut", "STREAM");
    foreach (values[i]) get_dcm_output_samples[i].stream_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLROut", "SYMB");
    foreach (values[i]) get_dcm_output_samples[i].symb_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLROut", "BIT");
    foreach (values[i]) get_dcm_output_samples[i].bit_f = values[i];
    getData_v(values, "RXBPBF", "DCMCOMBINER_LLROut", "SEG");
    foreach (values[i]) get_dcm_output_samples[i].seg_f = values[i];

  endfunction

//--------------------------------------------------------------------
// get de-inter referent data
//--------------------------------------------------------------------
  function soft_bits_array get_deint_soft_bits();
    int        size;
    bit [31:0] values[];

    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "DEINTORDETM_LLROut");
    get_deint_soft_bits = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "DEINTORDETM_LLROut", "REAL");
    foreach (values[i]) get_deint_soft_bits[i].real_comp_f = values[i];
    getData_v(values, "RXBPBF", "DEINTORDETM_LLROut", "STREAM");
    foreach (values[i]) get_deint_soft_bits[i].stream_f = values[i];
    getData_v(values, "RXBPBF", "DEINTORDETM_LLROut", "BIT");
    foreach (values[i]) get_deint_soft_bits[i].bit_f = values[i];
    getData_v(values, "RXBPBF", "DEINTORDETM_LLROut", "SEG");
    foreach (values[i]) get_deint_soft_bits[i].seg_f = values[i];

  endfunction : get_deint_soft_bits

//--------------------------------------------------------------------
// get Viterbi referent data
//--------------------------------------------------------------------
  function viterbi_array get_viterbi_samples();
    int         size;
    bit [31:0]  values[];
    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "FECDECODER_ViterbiIn");
    get_viterbi_samples = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "FECDECODER_ViterbiIn", "REAL");
    foreach (values[i]) get_viterbi_samples[i].real_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_ViterbiIn", "INDSYMB");
    foreach (values[i]) get_viterbi_samples[i].indsymb_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_ViterbiIn", "RXFIELD");
    foreach (values[i]) get_viterbi_samples[i].rxfield_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_ViterbiIn", "BCC_ES");
    foreach (values[i]) get_viterbi_samples[i].bcc_es_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_ViterbiIn", "ContentChanIdx");
    foreach (values[i]) get_viterbi_samples[i].contentchanidx_f = values[i];

  endfunction
//--------------------------------------------------------------------
// get LDPC referent data
// Mapping of RXFIELD:
// L-STF        1
// L-LTF        2
// HT-GF-LTF    3
// HT-LTF1      4
// L-SIG        5
// RL-SIG       6
// HT-SIG       7
// VHT-SIGA     8
// VHT-SIGB     9
// HE-SIGA      10
// HE-SIGB      11
// HT-STF       12
// VHT-STF      13
// HE-STF       14
// HT-LTF       15
// VHT-LTF      16
// HE-LTF       17
// L-Data       18
// HT-Data      19
// VHT-Data     20
// HE-Data      21
//--------------------------------------------------------------------
  function ldpc_array get_ldpc_samples();
    int         size;
    bit [31:0]  values[];

    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "FECDECODER_LLRIn");
    get_ldpc_samples = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "FECDECODER_LLRIn", "REAL");
    foreach (values[i]) get_ldpc_samples[i].real_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_LLRIn", "INDSYMB");
    foreach (values[i]) get_ldpc_samples[i].indsymb_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_LLRIn", "RXFIELD");
    foreach (values[i]) get_ldpc_samples[i].rxfield_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_LLRIn", "BCC_ES");
    foreach (values[i]) get_ldpc_samples[i].bcc_es_f = values[i];

  endfunction

//--------------------------------------------------------------------
// get LDPC data samples
//--------------------------------------------------------------------
  function ldpc_data_array get_ldpc_data_samples();
    int         size;
    bit [31:0]  values[];

    //getBlockList_v("RXBPBF");
    size = getDataSize_v("RXBPBF", "FECDECODER_Bit1Out");
    get_ldpc_data_samples = new[size];
    values = new[size];
    getData_v(values, "RXBPBF", "FECDECODER_Bit1Out", "REAL");
    foreach (values[i]) get_ldpc_data_samples[i].real_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_Bit1Out", "INDSYMB");
    foreach (values[i]) get_ldpc_data_samples[i].indsymb_f = values[i];
    getData_v(values, "RXBPBF", "FECDECODER_Bit1Out", "RXFIELD");
    foreach (values[i]) get_ldpc_data_samples[i].rxfield_f = values[i];

  endfunction

//--------------------------------------------------------------------
// set Rx paramters for TXRx block interface signals
//--------------------------------------------------------------------
  virtual function void set_rxparams();
    int        size;
    bit [31:0] values[];
    ru_type_e  ru_type;
    int        offset;

    //---------------------------------------------------------------
    //getBlockList_v("RXPARAMETERS");
    //---------------------------------------------------------------

    size = getDataSize_v("RXPARAMETERS","NSymb");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "NSymb", "REAL");
    rxparams.nsymb_f       = values[size-1];

    size = getDataSize_v("RXPARAMETERS","TPE");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "TPE", "REAL");
    rxparams.tpe_f        = values[size-1]/4; // values from Matlab:0-4-8-12-16

    // from matlab but not part of interface signals
    size = getDataSize_v("RXPARAMETERS","NSD");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "NSD", "REAL");
    rxparams.nsd_f         = values[size-1];

    size = getDataSize_v("RXPARAMETERS","NSS");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "NSS", "REAL");
    rxparams.nss_f         = values[size-1];

    size = getDataSize_v("RXPARAMETERS","NBPSC");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "NBPSC", "REAL");
    rxparams.nbpsc0_f      = values[size-1];

    // TODO: NBPSC1
    //~ size = getDataSize_v("RXPARAMETERS","NBPSC");
    //~ values = new[size];
    //~ getData_v(values, "RXPARAMETERS", "NBPSC", "REAL");
    //~ rxparams.nbpsc1_f       = values[size-1];

    size = getDataSize_v("RXPARAMETERS","STBC");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "STBC", "REAL");
    rxparams.stbc_f        = values[size-1];

    size = getDataSize_v("RXPARAMETERS","M_MA");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "M_MA", "REAL");
    rxparams.midamble_f    = (values[size-1] == 20) ? 1'b1 : 1'b0;

    size = getDataSize_v("RXPARAMETERS","N_MA");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "N_MA", "REAL");
    rxparams.nma_f         = values[size-1];

    size = getDataSize_v("RXPARAMETERS","sigb_compression");
    values = new[size];
    getData_v(values, "RXPARAMETERS", "sigb_compression", "REAL");
    rxparams.sig_b_compression_f = values[size-1];

    //---------------------------------------------------------------
    //getBlockList_v("RXVECTOR");
    //---------------------------------------------------------------

    // paramters that are part of interface signals
    size = getDataSize_v("RXVECTOR","CH_BANDWIDTH");
    values = new[size];
    getData_v(values, "RXVECTOR", "CH_BANDWIDTH", "REAL");
    rxparams.cbw_f = values[size-1];

    size = getDataSize_v("RXVECTOR", "FORMAT");
    values = new[size];
    getData_v(values, "RXVECTOR", "FORMAT", "REAL");
    rxparams.format_mod_f = values[size-1];

    size = getDataSize_v("RXVECTOR", "GI_TYPE");
    values = new[size];
    getData_v(values, "RXVECTOR", "GI_TYPE", "REAL");
    rxparams.gi_type_f  = (values[size-1] == 32'd400)  ? 2'd0 : // 0.4us
                          (values[size-1] == 32'd800)  ? 2'd1 : // 0.8us
                          (values[size-1] == 32'd1600) ? 2'd2 : // 1.6us
                          (values[size-1] == 32'd3200) ? 2'd3 : // 3.2us
                                                         2'd1 ; // NON_HT and NON_HT_DUP_OFDM = 0.8us

    size = getDataSize_v("RXVECTOR", "HE_LTF_TYPE");
    values = new[size];
    getData_v(values, "RXVECTOR", "HE_LTF_TYPE", "REAL");
    // map values for HW
    rxparams.he_ltf_type_f = (values[size-1] == 1) ? 0 : (values[size-1]/2);

    size = getDataSize_v("RXVECTOR", "NUM_EXTEN_SS");
    values = new[size];
    getData_v(values, "RXVECTOR", "NUM_EXTEN_SS", "REAL");
    rxparams.ness_f        = values[size-1];

    size = getDataSize_v("RXVECTOR", "NUM_STS");
    values = new[size];
    getData_v(values, "RXVECTOR", "NUM_STS", "REAL");
    if (size && rxparams.format_mod_f >= VHT)
      rxparams.nsts_f = values[size-1]-1;
    else if (rxparams.format_mod_f inside {HT_MF,HT_GF})
      rxparams.nsts_f = (rxparams.stbc_f) ? (rxparams.nss_f + rxparams.stbc_f)-1 : (rxparams.nss_f-1);
    else
      rxparams.nsts_f = 0;

    size = getDataSize_v("RXVECTOR", "DOPPLER");
    values = new[size];
    getData_v(values, "RXVECTOR", "DOPPLER", "REAL");
    rxparams.doppler_f = values[size-1];

    size = getDataSize_v("RXVECTOR", "DCM");
    values = new[size];
    getData_v(values, "RXVECTOR", "DCM", "REAL");
    rxparams.dcm_f = values[size-1];

    size = getDataSize_v("RXVECTOR", "MCS_SIG_B");
    values = new[size];
    getData_v(values, "RXVECTOR", "MCS_SIG_B", "REAL");
    rxparams.mcs_sigb_f = values[size-1];

    size = getDataSize_v("RXVECTOR", "DCM_SIG_B");
    values = new[size];
    getData_v(values, "RXVECTOR", "DCM_SIG_B", "REAL");
    rxparams.dcm_sigb_f = values[size-1];

    // NDP in VHT
    rxparams.vht_ndp_f = (rxparams.format_mod_f == VHT) ? is_ndp_active() : 0;

    if (rxparams.format_mod_f == HE_MU) begin
      get_block_field_value(values, "RXDECODER", "HE_SIGA_output_decoder");
      for (int i=0; i<values.size(); i++)
        he_siga_mu[i] = values[i][0];

      // NUM of HE-LTF fields
      // RLT needs notation like this:
      // 0 - 1x HE-LTF
      // 1 - 2x HE-LTF
      // 3 - 4x HE-LTF
      // 5 - 6x HE-LTF
      // 7 - 8x HE-LTF
      //                       when DOPPLER = 1 midamble periodicity is present
      rxparams.num_he_ltf_f  = (he_siga_mu.doppler_f)
                               ? (he_siga_mu.num_he_ltf_midamble_periodicity_f[1:0] != 0) ? he_siga_mu.num_he_ltf_midamble_periodicity_f[1:0]*2 - 1
                                                                                          : 0
                               : (he_siga_mu.num_he_ltf_midamble_periodicity_f      != 0) ? he_siga_mu.num_he_ltf_midamble_periodicity_f*2 - 1
                                                                                          : 0;
      // NUM SYMBOLS IN SIGB
      size = getDataSize_v("RXVECTOR", "NSYMB_SIG_B");
      values = new[size];
      getData_v(values, "RXVECTOR", "NSYMB_SIG_B", "REAL");
      rxparams.he_sigb_f     = values[size-1];
      `uvm_info(get_type_name(), $sformatf("HE_SIGA: %p",he_siga_mu), UVM_LOW)
    end
    else begin
      // NUM of HE-LTF fields
      if (rxparams.format_mod_f == HE_SU) begin
        case(rxparams.nsts_f)
          0   : rxparams.num_he_ltf_f = 0;
          1   : rxparams.num_he_ltf_f = 1;
          2,3 : rxparams.num_he_ltf_f = 3;
          4,5 : rxparams.num_he_ltf_f = 5;
          6   : rxparams.num_he_ltf_f = 7;
        endcase
      end
      else begin
        rxparams.num_he_ltf_f  = 0;
        rxparams.he_sigb_f     = 0;
      end
    end

    // RLSIG
    get_block_field_value(values, "RXPSDU", "DET_HE");
    rxparams.rlsig_f      = values[0];

    size = getDataSize_v("RXVECTOR", "FEC_CODING");
    values = new[size];
    getData_v(values, "RXVECTOR", "FEC_CODING", "REAL");
    rxparams.fec_f        = values[size-1];

    size = getDataSize_v("RXVECTOR", "SMOOTHING");
    values = new[size];
    getData_v(values, "RXVECTOR", "SMOOTHING", "REAL");
    // TODO: Get this parameter, when Matlab will be updated
    // until then force to 1
    rxparams.smoothing_f  = 1;

    size = getDataSize_v("RXVECTOR", "L_DATARATE");
    values = new[size];
    getData_v(values, "RXVECTOR", "L_DATARATE", "REAL");
    // If LSIG is sent at 6Mbps datarate set to 1
    rxparams.lsig6m_f     =  (values[size-1] == 4'hB) ? 1 : 0;

    rxparams.htndp_f      = (rxparams.format_mod_f inside {HT_MF,HT_GF}) ? is_ndp_active() : 1'b0;

    // This is used for forcing the RatioNoiseSignal in RTL
    size = getDataSize_v("FINETDFO","ratio_noise_signal");
    values = new[size];
    getData_v(values,"FINETDFO","ratio_noise_signal","REAL");
    rxparams.RatioNoiseSignal = values[size-1];
    size = getDataSize_v("FINETDFO","nbits_right_shift");
    values = new[size];
    getData_v(values,"FINETDFO","nbits_right_shift","REAL");
    rxparams.RatioShift = values[size-1];

     // Get FDOPreamb value
    size = getDataSize_v("FDOFFSET", "FDOPreamb");
    values = new[size];
    getData_v(values,"FDOFFSET","FDOPreamb","REAL");
    rxparams.FDCpeSlope = values[size-1];

    if (rxparams.format_mod_f == HE_MU) begin
      case(he_siga_mu.sigb_mcs_f)
        0:    rxparams.nbpsc_he_sigb_f = 0;
        1,2:  rxparams.nbpsc_he_sigb_f = 1;
        3,4:  rxparams.nbpsc_he_sigb_f = 2;
        5:    rxparams.nbpsc_he_sigb_f = 3;
        default: `uvm_error(get_type_name(), "Invalid parameter for MCS_SIG_B")
      endcase

      // RU type decoding
      // 0 : RU26
      // 1 : RU52
      // 2 : RU106
      // 3 : RU242

      ru_type = get_ru_type_from_ru_allocation(golden_frame.preamble_header.ru_allocation[7:0],
                                               golden_frame.preamble_header.user_header_he[golden_frame.preamble_header.mu_mimo_userid].dut_location_f);
      `uvm_info(get_type_name(), $sformatf("The RU_TYPE is = %s", ru_type.name()), UVM_LOW)

      // In case the primary channel is different than 0, offset should be added
      // for correct indexing
      if (    rxparams.cbw_f == 3'b001
          &&  primary_channel == 1
          &&  rxparams.format_mod_f == HE_MU) begin

        case (ru_type)
          RU26  : offset = 9;
          RU52  : offset = 4;
          RU106 : offset = 2;
          RU242 : offset = 1;
          RU484 : offset = 0;
          default : offset = 0;
        endcase

      end
      else if ( rxparams.cbw_f == 3'b010
            &&  rxparams.format_mod_f == HE_MU) begin
        if (primary_channel == 1) begin
          case (ru_type)
            RU26  : offset = 9;
            RU52  : offset = 4;
            RU106 : offset = 2;
            RU242 : offset = 1;
            RU484 : offset = 0;
            default : offset = 0;
          endcase
        end
        else if (primary_channel == 2) begin
          case (ru_type)
            RU26  : offset = 19;
            RU52  : offset = 8;
            RU106 : offset = 4;
            RU242 : offset = 2;
            RU484 : offset = 1;
            default : offset = 0;
          endcase
        end
        else if (primary_channel == 3) begin
          case (ru_type)
            RU26  : offset = 28;
            RU52  : offset = 12;
            RU106 : offset = 6;
            RU242 : offset = 2;
            RU484 : offset = 1;
            default : offset = 0;
          endcase
        end
      end
      else begin
        offset = 0;
      end

      // Set the RU_INDEX
      rxparams.ruindex_f = get_ru_index(golden_frame.preamble_header.ru_allocation[7:0],
                                        golden_frame.preamble_header.user_header_he[golden_frame.preamble_header.mu_mimo_userid].dut_location_f) + offset;

      rxparams.rutype_f = int'(ru_type);

      // Set in rxparams DUT index
      rxparams.dut_location_f = golden_frame.preamble_header.user_header_he[0].dut_location_f;

    end

    //getBlockList_v("TXPARAMETERS");
    size = getDataSize_v("TXPARAMETERS", "NSymbInit");
    values = new[size];
    getData_v(values,"TXPARAMETERS","NSymbInit","REAL");
    foreach(rxparams.nsym_init_f[i])
      rxparams.nsym_init_f[i] = 0;
    foreach(values[i])
      rxparams.nsym_init_f[i] = values[i];

    `uvm_info(get_type_name(),$sformatf("RXPARAMETERS: %p",rxparams), UVM_LOW)
  endfunction : set_rxparams

//--------------------------------------------------------------------
// get FFT in interface signals
//--------------------------------------------------------------------
  function fft_data_array get_fft_data_in();
    int           size;
    bit [31:0]    values[];
    bit [31:0]    fft_size[];
    rxfield_e     rxfield_fft[];
    FFT_data_s    fft_skip[];
    int           fft_skip_idx;
    int           fhandle;

    //getBlockList_v("RXFFT");
    size = getDataSize_v("RXFFT", "fft_in");
    get_fft_data_in = new[size];
    values = new[size];
    fft_size = new[size];
    rxfield_fft = new[size];
    getData_v(values, "RXFFT", "fft_in", "REAL");
    foreach (values[i]) get_fft_data_in[i].re_f = values[i];
    getData_v(values, "RXFFT", "fft_in", "IMAG");
    foreach (values[i]) get_fft_data_in[i].im_f = values[i];
    getData_v(values, "RXFFT", "fft_in", "NSymb");
    foreach (values[i]) get_fft_data_in[i].nsymb_f = values[i];
    getData_v(values, "RXFFT", "fft_in", "INDSYMB");
    foreach (values[i]) get_fft_data_in[i].symb_idx_f = values[i];
    getData_v(values, "RXFFT", "fft_in", "INDSC");
    getData_v(fft_size, "RXFFT", "fft_in", "NFFT");
    foreach (values[i]) begin
      // index range for FFT in should be positive numbers so offset is
      // added in relative to FFT size (64,128,256,512)
      get_fft_data_in[i].index_f    = values[i][15:0] + (fft_size[i]/2);
      get_fft_data_in[i].fft_size_f = fft_size[i];
    end
    // fill RXFIELDS
    getData_v(values, "RXFFT", "fft_in", "RXFIELD_FFT");
    foreach (values[i]) rxfield_fft[i] = rxfield_e'(values[i]);
    foreach (values[i]) get_fft_data_in[i].rxfield_f = rxfield_e'(values[i]);

    // overwrite DATA symbols with skip dumps
    size = getDataSize_v("RXFFT", "fft_in_skip");

    // GET these data only when FFT_skip exists
    if (size > 0) begin

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_in_original.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\tFFT_SIZE\tRXFIELD\n"));
      foreach (get_fft_data_in[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\t%5d\t\t%s\n",
        get_fft_data_in[i].re_f,
        get_fft_data_in[i].im_f,
        get_fft_data_in[i].symb_idx_f,
        get_fft_data_in[i].index_f,
        get_fft_data_in[i].nsymb_f,
        get_fft_data_in[i].fft_size_f,
        rxfield_fft[i].name()));

      $fclose(fhandle);
`endif
      fft_skip = new[size];
      values = new[size];
      fft_size = new[size];
      getData_v(values, "RXFFT", "fft_in_skip", "REAL");
      foreach (values[i]) fft_skip[i].re_f = values[i];
      getData_v(values, "RXFFT", "fft_in_skip", "IMAG");
      foreach (values[i]) fft_skip[i].im_f = values[i];
      getData_v(values, "RXFFT", "fft_in_skip", "NSymb");
      foreach (values[i]) fft_skip[i].nsymb_f = values[i];
      getData_v(values, "RXFFT", "fft_in_skip", "INDSYMB");
      foreach (values[i]) fft_skip[i].symb_idx_f = values[i];
      getData_v(values, "RXFFT", "fft_in_skip", "INDSC");
      getData_v(fft_size, "RXFFT", "fft_in_skip", "NFFT");
      foreach (values[i]) begin
        // index range for FFT in should be positive numbers so offset is
        // added in relative to FFT size (64,128,256,512)
        fft_skip[i].index_f    = values[i][15:0] + (fft_size[i]/2);
        fft_skip[i].fft_size_f = fft_size[i];
      end

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_in_skipped.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\tFFT_SIZE\n"));
      foreach (fft_skip[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\t%5d\n",
        fft_skip[i].re_f,
        fft_skip[i].im_f,
        fft_skip[i].symb_idx_f,
        fft_skip[i].index_f,
        fft_skip[i].nsymb_f,
        fft_skip[i].fft_size_f));
      $fclose(fhandle);
`endif

      // find data symbols to overwrite
      fft_skip_idx = 0;
      foreach (rxfield_fft[i]) begin
        if ((rxfield_fft[i] inside {L_DATA,HT_DATA,VHT_DATA,HE_DATA})  && (fft_skip_idx < size)) begin
          get_fft_data_in[i].re_f = fft_skip[fft_skip_idx].re_f;
          get_fft_data_in[i].im_f = fft_skip[fft_skip_idx].im_f;
          fft_skip_idx++;
        end
        // reduce size when skip part is appended
        else if (fft_skip_idx >= size)begin
          get_fft_data_in = new[i](get_fft_data_in);
          fft_skip_idx++;
          break;
        end
      end

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_in_combined.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\tFFT_SIZE\tRXFIELD\n"));
      foreach (get_fft_data_in[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\t%5d\t\t%s\n",
        get_fft_data_in[i].re_f,
        get_fft_data_in[i].im_f,
        get_fft_data_in[i].symb_idx_f,
        get_fft_data_in[i].index_f,
        get_fft_data_in[i].nsymb_f,
        get_fft_data_in[i].fft_size_f,
        rxfield_fft[i].name()));

      $fclose(fhandle);
`endif
    end // if FFT skip

  endfunction : get_fft_data_in

//--------------------------------------------------------------------
// get FFT out interface signals
//--------------------------------------------------------------------
  function fft_data_array get_fft_data_out();
    int           size;
    bit [31:0]    values[];
    rxfield_e     rxfield_fft[];
    FFT_data_s    fft_skip[];
    int           fft_skip_idx;
    int           fhandle;

    //getBlockList_v("RXFFT");
    size = getDataSize_v("RXFFT", "fft_out");
    get_fft_data_out = new[size];
    values = new[size];
    rxfield_fft = new[size];
    getData_v(values, "RXFFT", "fft_out", "REAL");
    foreach (values[i]) get_fft_data_out[i].re_f = values[i];
    getData_v(values, "RXFFT", "fft_out", "IMAG");
    foreach (values[i]) get_fft_data_out[i].im_f = values[i];
    getData_v(values, "RXFFT", "fft_out", "NSymb");
    foreach (values[i]) get_fft_data_out[i].nsymb_f = values[i];
    getData_v(values, "RXFFT", "fft_out", "INDSYMB");
    foreach (values[i]) get_fft_data_out[i].symb_idx_f = values[i];
    getData_v(values, "RXFFT", "fft_out", "INDSC");
    foreach (values[i]) get_fft_data_out[i].index_f = values[i];
    // fill RXFIELDS
    getData_v(values, "RXFFT", "fft_out", "RXFIELD_FFT");
    foreach (values[i]) rxfield_fft[i] = rxfield_e'(values[i]);
    foreach (values[i]) get_fft_data_out[i].rxfield_f = rxfield_e'(values[i]);

    // overwrite DATA symbols with skip dumps
    size = getDataSize_v("RXFFT", "fft_out_skip");

    // Get the parameters only when FFT SKIP exists
    if (size > 0) begin

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_out_original.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\tRXFIELD\n"));
      foreach (get_fft_data_out[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\t%s\n",
        get_fft_data_out[i].re_f,
        get_fft_data_out[i].im_f,
        get_fft_data_out[i].symb_idx_f,
        get_fft_data_out[i].index_f,
        get_fft_data_out[i].nsymb_f,
        rxfield_fft[i].name()));
      $fclose(fhandle);
`endif

      fft_skip = new[size];
      values = new[size];
      getData_v(values, "RXFFT", "fft_out_skip", "REAL");
      foreach (values[i]) fft_skip[i].re_f = values[i];
      getData_v(values, "RXFFT", "fft_out_skip", "IMAG");
      foreach (values[i]) fft_skip[i].im_f = values[i];
      getData_v(values, "RXFFT", "fft_out_skip", "NSymb");
      foreach (values[i]) fft_skip[i].nsymb_f = values[i];
      getData_v(values, "RXFFT", "fft_out_skip", "INDSYMB");
      foreach (values[i]) fft_skip[i].symb_idx_f = values[i];
      getData_v(values, "RXFFT", "fft_out_skip", "INDSC");
      foreach (values[i]) fft_skip[i].index_f = values[i];

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_out_skipped.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\n"));
      foreach (fft_skip[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\n",
        fft_skip[i].re_f,
        fft_skip[i].im_f,
        fft_skip[i].symb_idx_f,
        fft_skip[i].index_f,
        fft_skip[i].nsymb_f));
      $fclose(fhandle);
`endif

      // find data symbols to overwrite
      fft_skip_idx = 0;
      foreach (rxfield_fft[i]) begin
        if ((rxfield_fft[i] inside {L_DATA,HT_DATA,VHT_DATA,HE_DATA}) && (fft_skip_idx < size)) begin
          get_fft_data_out[i].re_f = fft_skip[fft_skip_idx].re_f;
          get_fft_data_out[i].im_f = fft_skip[fft_skip_idx].im_f;
          fft_skip_idx++;
        end
        // reduce size when skip part is appended
        else if (fft_skip_idx >= size)begin
          get_fft_data_out = new[i](get_fft_data_out);
          fft_skip_idx++;
          break;
        end
      end

`ifdef DEBUG_SAMPLES
      fhandle = $fopen("fft_out_combined.txt","w");
      $fwrite(fhandle, $sformatf("#REAL\tIMAG\tINDSYMB\tINDSC\tNSYMB\tRXFIELD\n"));
      foreach (get_fft_data_out[i])
        $fwrite(fhandle, $sformatf("%5d\t%5d\t%5d\t%5d\t%5d\t%s\n",
        get_fft_data_out[i].re_f,
        get_fft_data_out[i].im_f,
        get_fft_data_out[i].symb_idx_f,
        get_fft_data_out[i].index_f,
        get_fft_data_out[i].nsymb_f,
        rxfield_fft[i].name()));

      $fclose(fhandle);
`endif
    end // fft_skip

  endfunction : get_fft_data_out

//--------------------------------------------------------------------
// Copies Rx stream that is expected on MAC-PHY interface, contained of
// RxVector1 - Payload bytes
// NOTE: rxvector will not be returned since Matlab doesn't provide
// dump of rxvector byte stream (it is field by field)
//--------------------------------------------------------------------
  virtual function void get_rx_stream(ref bit [31:0] rxvector1[],
                                      ref bit [31:0] payload[]);

    int        size;
    int        byte_cnt;
    bit [7:0]  invert;
    bit [31:0] payload_bits[];
    bit [31:0] payload_dec[];
    bit [31:0] data[];

    // clear data
    rxvector1.delete();
    payload.delete();
    //getBlockList_v("RXPSDU");
    //-------------------------------------------------------------------------
    // get list of error codes
    //-------------------------------------------------------------------------
    size = getDataSize_v("RXPSDU", "fcsOK");
    data = new[size];
    getData_v(data, "RXPSDU", "fcsOK", "REAL");
    fcsOK = data[0];
    size = getDataSize_v("RXPSDU", "lsigErrorcode");
    data = new[size];
    getData_v(data, "RXPSDU", "lsigErrorcode", "REAL");
    lsigErrorcode = data[0];
    size = getDataSize_v("RXPSDU", "htsigErrorcode");
    data = new[size];
    getData_v(data, "RXPSDU", "htsigErrorcode", "REAL");
    htsigErrorcode = data[0];size = getDataSize_v("RXPSDU", "hesigaErrorcode");
    data = new[size];
    getData_v(data, "RXPSDU", "hesigaErrorcode", "REAL");
    hesigaErrorcode = data[0];
    size = getDataSize_v("RXPSDU", "hesigbErrorcode");
    data = new[size];
    getData_v(data, "RXPSDU", "hesigbErrorcode", "REAL");
    hesigbErrorcode = data[0];
    size = getDataSize_v("RXPSDU", "vhtsigbErrorcode");
    data = new[size];
    getData_v(data, "RXPSDU", "vhtsigbErrorcode", "REAL");
    vhtsigbErrorcode = data[0];

    //-------------------------------------------------------------------------

    // get Rx payload data
    if (golden_frame.kind == NDP) begin
      `uvm_info(get_type_name(),$sformatf("[get_rx_stream] No data in NDP frame"),UVM_LOW)
    end
    else begin
      size = getDataSize_v("RXPSDU", "rx_psdu_dec_with_fcs");
      payload_dec = new[size];
      payload = new[size];
      getData_v(payload_dec, "RXPSDU", "rx_psdu_dec_with_fcs", "REAL");
      // Matlab generates inverted bits
      for (int i=0; i<payload_dec.size(); i++) begin
        invert[7] = payload_dec[i][0];
        invert[6] = payload_dec[i][1];
        invert[5] = payload_dec[i][2];
        invert[4] = payload_dec[i][3];
        invert[3] = payload_dec[i][4];
        invert[2] = payload_dec[i][5];
        invert[1] = payload_dec[i][6];
        invert[0] = payload_dec[i][7];
        payload[i]  = invert;
      end
    end

  endfunction : get_rx_stream

endclass : mdm_data_model_ver2

`endif //MDM_DATA_MODEL_VER2_SV
