//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for CRM
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __CRM_REG_BLOCK_SV__
`define __CRM_REG_BLOCK_SV__

//--------------------------------------------------------------------
// CLKRST_CNTL
//--------------------------------------------------------------------
class CLKRST_CNTL extends uvm_reg;
    `uvm_object_utils(CLKRST_CNTL)
    rand uvm_reg_field MACWTCLK_RATIO_SEL;
    rand uvm_reg_field MACCORECLK_FREQ_SEL;
    rand uvm_reg_field FECLK_FREQ_SEL;
    rand uvm_reg_field PLFCLK_SEL;

    //---build------------------------------------------------------------
    virtual function void build();
        MACWTCLK_RATIO_SEL = uvm_reg_field::type_id::create("MACWTCLK_RATIO_SEL");
        MACCORECLK_FREQ_SEL = uvm_reg_field::type_id::create("MACCORECLK_FREQ_SEL");
        FECLK_FREQ_SEL = uvm_reg_field::type_id::create("FECLK_FREQ_SEL");
        PLFCLK_SEL = uvm_reg_field::type_id::create("PLFCLK_SEL");

        MACWTCLK_RATIO_SEL.configure(this, 2, 12, "RW", 1, `WEP_2_BB_CLK_RATIO, 1, 1, 1);
        MACCORECLK_FREQ_SEL.configure(this, 4, 8, "RW", 1, `MACCORECLK_FREQ_SEL_RST, 1, 1, 1);
        FECLK_FREQ_SEL.configure(this, 2, 4, "RW", 1, `FECLK_FREQ_SEL_RST, 1, 1, 1);
        PLFCLK_SEL.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_CLKRST_CNTL_wr_cg";
        MACWTCLK_RATIO_SEL_wr : coverpoint MACWTCLK_RATIO_SEL.value[1:0];
        MACCORECLK_FREQ_SEL_wr : coverpoint MACCORECLK_FREQ_SEL.value[3:0];
        FECLK_FREQ_SEL_wr : coverpoint FECLK_FREQ_SEL.value[1:0];
        PLFCLK_SEL_wr : coverpoint PLFCLK_SEL.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_CLKRST_CNTL_rd_cg";
        MACWTCLK_RATIO_SEL_rd : coverpoint MACWTCLK_RATIO_SEL.value[1:0];
        MACCORECLK_FREQ_SEL_rd : coverpoint MACCORECLK_FREQ_SEL.value[3:0];
        FECLK_FREQ_SEL_rd : coverpoint FECLK_FREQ_SEL.value[1:0];
        PLFCLK_SEL_rd : coverpoint PLFCLK_SEL.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CLKRST_CNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CLKRST_STAT
//--------------------------------------------------------------------
class CLKRST_STAT extends uvm_reg;
    `uvm_object_utils(CLKRST_STAT)
    rand uvm_reg_field MMC_LOCK;

    //---build------------------------------------------------------------
    virtual function void build();
        MMC_LOCK = uvm_reg_field::type_id::create("MMC_LOCK");

        MMC_LOCK.configure(this, 7, 4, "RO", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_CLKRST_STAT_rd_cg";
        MMC_LOCK_rd : coverpoint MMC_LOCK.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CLKRST_STAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CLKGATEPHYFCTRL0
//--------------------------------------------------------------------
class CLKGATEPHYFCTRL0 extends uvm_reg;
    `uvm_object_utils(CLKGATEPHYFCTRL0)
    rand uvm_reg_field PHYTXCLKFORCE;
    rand uvm_reg_field BDTXCLKFORCE;
    rand uvm_reg_field AGCMEMCLKFORCE;
    rand uvm_reg_field AGCCLKFORCE;
    rand uvm_reg_field RCCLKFORCE;
    rand uvm_reg_field FECLKFORCE;
    rand uvm_reg_field FDOCLKFORCE;
    rand uvm_reg_field EQUCLKFORCE;
    rand uvm_reg_field PHYSVDCLKFORCE;
    rand uvm_reg_field TDCOMPCLKFORCE;
    rand uvm_reg_field TDFOESTCLKFORCE;
    rand uvm_reg_field TBECLKFORCE;
    rand uvm_reg_field FFT1MEMCLKFORCE;
    rand uvm_reg_field FFT1CLKFORCE;
    rand uvm_reg_field FFT0MEMCLKFORCE;
    rand uvm_reg_field FFT0CLKFORCE;
    rand uvm_reg_field CHESTCLKFORCE;
    rand uvm_reg_field HMEMCLKFORCE;
    rand uvm_reg_field INTLVMEMCLKFORCE;
    rand uvm_reg_field VTB1CLKFORCE;
    rand uvm_reg_field VTB0CLKFORCE;
    rand uvm_reg_field BDRXCLKFORCE;

    //---build------------------------------------------------------------
    virtual function void build();
        PHYTXCLKFORCE = uvm_reg_field::type_id::create("PHYTXCLKFORCE");
        BDTXCLKFORCE = uvm_reg_field::type_id::create("BDTXCLKFORCE");
        AGCMEMCLKFORCE = uvm_reg_field::type_id::create("AGCMEMCLKFORCE");
        AGCCLKFORCE = uvm_reg_field::type_id::create("AGCCLKFORCE");
        RCCLKFORCE = uvm_reg_field::type_id::create("RCCLKFORCE");
        FECLKFORCE = uvm_reg_field::type_id::create("FECLKFORCE");
        FDOCLKFORCE = uvm_reg_field::type_id::create("FDOCLKFORCE");
        EQUCLKFORCE = uvm_reg_field::type_id::create("EQUCLKFORCE");
        PHYSVDCLKFORCE = uvm_reg_field::type_id::create("PHYSVDCLKFORCE");
        TDCOMPCLKFORCE = uvm_reg_field::type_id::create("TDCOMPCLKFORCE");
        TDFOESTCLKFORCE = uvm_reg_field::type_id::create("TDFOESTCLKFORCE");
        TBECLKFORCE = uvm_reg_field::type_id::create("TBECLKFORCE");
        FFT1MEMCLKFORCE = uvm_reg_field::type_id::create("FFT1MEMCLKFORCE");
        FFT1CLKFORCE = uvm_reg_field::type_id::create("FFT1CLKFORCE");
        FFT0MEMCLKFORCE = uvm_reg_field::type_id::create("FFT0MEMCLKFORCE");
        FFT0CLKFORCE = uvm_reg_field::type_id::create("FFT0CLKFORCE");
        CHESTCLKFORCE = uvm_reg_field::type_id::create("CHESTCLKFORCE");
        HMEMCLKFORCE = uvm_reg_field::type_id::create("HMEMCLKFORCE");
        INTLVMEMCLKFORCE = uvm_reg_field::type_id::create("INTLVMEMCLKFORCE");
        VTB1CLKFORCE = uvm_reg_field::type_id::create("VTB1CLKFORCE");
        VTB0CLKFORCE = uvm_reg_field::type_id::create("VTB0CLKFORCE");
        BDRXCLKFORCE = uvm_reg_field::type_id::create("BDRXCLKFORCE");

        PHYTXCLKFORCE.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        BDTXCLKFORCE.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        AGCMEMCLKFORCE.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        AGCCLKFORCE.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        RCCLKFORCE.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        FECLKFORCE.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        FDOCLKFORCE.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        EQUCLKFORCE.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        PHYSVDCLKFORCE.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        TDCOMPCLKFORCE.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        TDFOESTCLKFORCE.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        TBECLKFORCE.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        FFT1MEMCLKFORCE.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        FFT1CLKFORCE.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        FFT0MEMCLKFORCE.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        FFT0CLKFORCE.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        CHESTCLKFORCE.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        HMEMCLKFORCE.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        INTLVMEMCLKFORCE.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        VTB1CLKFORCE.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        VTB0CLKFORCE.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        BDRXCLKFORCE.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_CLKGATEPHYFCTRL0_wr_cg";
        PHYTXCLKFORCE_wr : coverpoint PHYTXCLKFORCE.value[0:0];
        BDTXCLKFORCE_wr : coverpoint BDTXCLKFORCE.value[0:0];
        AGCMEMCLKFORCE_wr : coverpoint AGCMEMCLKFORCE.value[0:0];
        AGCCLKFORCE_wr : coverpoint AGCCLKFORCE.value[0:0];
        RCCLKFORCE_wr : coverpoint RCCLKFORCE.value[0:0];
        FECLKFORCE_wr : coverpoint FECLKFORCE.value[0:0];
        FDOCLKFORCE_wr : coverpoint FDOCLKFORCE.value[0:0];
        EQUCLKFORCE_wr : coverpoint EQUCLKFORCE.value[0:0];
        PHYSVDCLKFORCE_wr : coverpoint PHYSVDCLKFORCE.value[0:0];
        TDCOMPCLKFORCE_wr : coverpoint TDCOMPCLKFORCE.value[0:0];
        TDFOESTCLKFORCE_wr : coverpoint TDFOESTCLKFORCE.value[0:0];
        TBECLKFORCE_wr : coverpoint TBECLKFORCE.value[0:0];
        FFT1MEMCLKFORCE_wr : coverpoint FFT1MEMCLKFORCE.value[0:0];
        FFT1CLKFORCE_wr : coverpoint FFT1CLKFORCE.value[0:0];
        FFT0MEMCLKFORCE_wr : coverpoint FFT0MEMCLKFORCE.value[0:0];
        FFT0CLKFORCE_wr : coverpoint FFT0CLKFORCE.value[0:0];
        CHESTCLKFORCE_wr : coverpoint CHESTCLKFORCE.value[0:0];
        HMEMCLKFORCE_wr : coverpoint HMEMCLKFORCE.value[0:0];
        INTLVMEMCLKFORCE_wr : coverpoint INTLVMEMCLKFORCE.value[0:0];
        VTB1CLKFORCE_wr : coverpoint VTB1CLKFORCE.value[0:0];
        VTB0CLKFORCE_wr : coverpoint VTB0CLKFORCE.value[0:0];
        BDRXCLKFORCE_wr : coverpoint BDRXCLKFORCE.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_CLKGATEPHYFCTRL0_rd_cg";
        PHYTXCLKFORCE_rd : coverpoint PHYTXCLKFORCE.value[0:0];
        BDTXCLKFORCE_rd : coverpoint BDTXCLKFORCE.value[0:0];
        AGCMEMCLKFORCE_rd : coverpoint AGCMEMCLKFORCE.value[0:0];
        AGCCLKFORCE_rd : coverpoint AGCCLKFORCE.value[0:0];
        RCCLKFORCE_rd : coverpoint RCCLKFORCE.value[0:0];
        FECLKFORCE_rd : coverpoint FECLKFORCE.value[0:0];
        FDOCLKFORCE_rd : coverpoint FDOCLKFORCE.value[0:0];
        EQUCLKFORCE_rd : coverpoint EQUCLKFORCE.value[0:0];
        PHYSVDCLKFORCE_rd : coverpoint PHYSVDCLKFORCE.value[0:0];
        TDCOMPCLKFORCE_rd : coverpoint TDCOMPCLKFORCE.value[0:0];
        TDFOESTCLKFORCE_rd : coverpoint TDFOESTCLKFORCE.value[0:0];
        TBECLKFORCE_rd : coverpoint TBECLKFORCE.value[0:0];
        FFT1MEMCLKFORCE_rd : coverpoint FFT1MEMCLKFORCE.value[0:0];
        FFT1CLKFORCE_rd : coverpoint FFT1CLKFORCE.value[0:0];
        FFT0MEMCLKFORCE_rd : coverpoint FFT0MEMCLKFORCE.value[0:0];
        FFT0CLKFORCE_rd : coverpoint FFT0CLKFORCE.value[0:0];
        CHESTCLKFORCE_rd : coverpoint CHESTCLKFORCE.value[0:0];
        HMEMCLKFORCE_rd : coverpoint HMEMCLKFORCE.value[0:0];
        INTLVMEMCLKFORCE_rd : coverpoint INTLVMEMCLKFORCE.value[0:0];
        VTB1CLKFORCE_rd : coverpoint VTB1CLKFORCE.value[0:0];
        VTB0CLKFORCE_rd : coverpoint VTB0CLKFORCE.value[0:0];
        BDRXCLKFORCE_rd : coverpoint BDRXCLKFORCE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CLKGATEPHYFCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CLKGATEPHYFCTRL1
//--------------------------------------------------------------------
class CLKGATEPHYFCTRL1 extends uvm_reg;
    `uvm_object_utils(CLKGATEPHYFCTRL1)
    rand uvm_reg_field RADARTIMCLKFORCE;
    rand uvm_reg_field MDMBTXCLKFORCE;
    rand uvm_reg_field MDMBRXCLKFORCE;
    rand uvm_reg_field LDPCENCCLKFORCE;
    rand uvm_reg_field LDPCDECCLKFORCE;

    //---build------------------------------------------------------------
    virtual function void build();
        RADARTIMCLKFORCE = uvm_reg_field::type_id::create("RADARTIMCLKFORCE");
        MDMBTXCLKFORCE = uvm_reg_field::type_id::create("MDMBTXCLKFORCE");
        MDMBRXCLKFORCE = uvm_reg_field::type_id::create("MDMBRXCLKFORCE");
        LDPCENCCLKFORCE = uvm_reg_field::type_id::create("LDPCENCCLKFORCE");
        LDPCDECCLKFORCE = uvm_reg_field::type_id::create("LDPCDECCLKFORCE");

        RADARTIMCLKFORCE.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        MDMBTXCLKFORCE.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        MDMBRXCLKFORCE.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        LDPCENCCLKFORCE.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        LDPCDECCLKFORCE.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_CLKGATEPHYFCTRL1_wr_cg";
        RADARTIMCLKFORCE_wr : coverpoint RADARTIMCLKFORCE.value[0:0];
        MDMBTXCLKFORCE_wr : coverpoint MDMBTXCLKFORCE.value[0:0];
        MDMBRXCLKFORCE_wr : coverpoint MDMBRXCLKFORCE.value[0:0];
        LDPCENCCLKFORCE_wr : coverpoint LDPCENCCLKFORCE.value[0:0];
        LDPCDECCLKFORCE_wr : coverpoint LDPCDECCLKFORCE.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_CLKGATEPHYFCTRL1_rd_cg";
        RADARTIMCLKFORCE_rd : coverpoint RADARTIMCLKFORCE.value[0:0];
        MDMBTXCLKFORCE_rd : coverpoint MDMBTXCLKFORCE.value[0:0];
        MDMBRXCLKFORCE_rd : coverpoint MDMBRXCLKFORCE.value[0:0];
        LDPCENCCLKFORCE_rd : coverpoint LDPCENCCLKFORCE.value[0:0];
        LDPCDECCLKFORCE_rd : coverpoint LDPCDECCLKFORCE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CLKGATEPHYFCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RSTCTRL
//--------------------------------------------------------------------
class RSTCTRL extends uvm_reg;
    `uvm_object_utils(RSTCTRL)
    rand uvm_reg_field RCSWRESET;
    rand uvm_reg_field AGCSWRESET;
    rand uvm_reg_field PHYSWRESET;

    //---build------------------------------------------------------------
    virtual function void build();
        RCSWRESET = uvm_reg_field::type_id::create("RCSWRESET");
        AGCSWRESET = uvm_reg_field::type_id::create("AGCSWRESET");
        PHYSWRESET = uvm_reg_field::type_id::create("PHYSWRESET");

        RCSWRESET.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        AGCSWRESET.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        PHYSWRESET.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_RSTCTRL_wr_cg";
        RCSWRESET_wr : coverpoint RCSWRESET.value[0:0];
        AGCSWRESET_wr : coverpoint AGCSWRESET.value[0:0];
        PHYSWRESET_wr : coverpoint PHYSWRESET.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_RSTCTRL_rd_cg";
        RCSWRESET_rd : coverpoint RCSWRESET.value[0:0];
        AGCSWRESET_rd : coverpoint AGCSWRESET.value[0:0];
        PHYSWRESET_rd : coverpoint PHYSWRESET.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RSTCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DYNCFGMMC_CNTL
//--------------------------------------------------------------------
class DYNCFGMMC_CNTL extends uvm_reg;
    `uvm_object_utils(DYNCFGMMC_CNTL)
    rand uvm_reg_field DYNCFGMMC_DONE;
    rand uvm_reg_field FMETRE_DONE;
    rand uvm_reg_field FMETRE_START;
    rand uvm_reg_field DYNCFGMMC_START;

    //---build------------------------------------------------------------
    virtual function void build();
        DYNCFGMMC_DONE = uvm_reg_field::type_id::create("DYNCFGMMC_DONE");
        FMETRE_DONE = uvm_reg_field::type_id::create("FMETRE_DONE");
        FMETRE_START = uvm_reg_field::type_id::create("FMETRE_START");
        DYNCFGMMC_START = uvm_reg_field::type_id::create("DYNCFGMMC_START");

        DYNCFGMMC_DONE.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        FMETRE_DONE.configure(this, 1, 30, "RO", 1, 'b0, 1, 1, 1);
        FMETRE_START.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        DYNCFGMMC_START.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_CNTL_wr_cg";
        FMETRE_START_wr : coverpoint FMETRE_START.value[0:0];
        DYNCFGMMC_START_wr : coverpoint DYNCFGMMC_START.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_CNTL_rd_cg";
        DYNCFGMMC_DONE_rd : coverpoint DYNCFGMMC_DONE.value[0:0];
        FMETRE_DONE_rd : coverpoint FMETRE_DONE.value[0:0];
        FMETRE_START_rd : coverpoint FMETRE_START.value[0:0];
        DYNCFGMMC_START_rd : coverpoint DYNCFGMMC_START.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DYNCFGMMC_CNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DYNCFGMMC_ADDR
//--------------------------------------------------------------------
class DYNCFGMMC_ADDR extends uvm_reg;
    `uvm_object_utils(DYNCFGMMC_ADDR)
    rand uvm_reg_field DYNCFGMMC_WE;
    rand uvm_reg_field DYNCFGMMC_SEL;
    rand uvm_reg_field DYNCFGMMC_ADDR;

    //---build------------------------------------------------------------
    virtual function void build();
        DYNCFGMMC_WE = uvm_reg_field::type_id::create("DYNCFGMMC_WE");
        DYNCFGMMC_SEL = uvm_reg_field::type_id::create("DYNCFGMMC_SEL");
        DYNCFGMMC_ADDR = uvm_reg_field::type_id::create("DYNCFGMMC_ADDR");

        DYNCFGMMC_WE.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        DYNCFGMMC_SEL.configure(this, 4, 16, "RW", 1, 'b000, 1, 1, 1);
        DYNCFGMMC_ADDR.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_ADDR_wr_cg";
        DYNCFGMMC_WE_wr : coverpoint DYNCFGMMC_WE.value[0:0];
        DYNCFGMMC_SEL_wr : coverpoint DYNCFGMMC_SEL.value[3:0];
        DYNCFGMMC_ADDR_wr : coverpoint DYNCFGMMC_ADDR.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_ADDR_rd_cg";
        DYNCFGMMC_WE_rd : coverpoint DYNCFGMMC_WE.value[0:0];
        DYNCFGMMC_SEL_rd : coverpoint DYNCFGMMC_SEL.value[3:0];
        DYNCFGMMC_ADDR_rd : coverpoint DYNCFGMMC_ADDR.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DYNCFGMMC_ADDR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DYNCFGMMC_DATA
//--------------------------------------------------------------------
class DYNCFGMMC_DATA extends uvm_reg;
    `uvm_object_utils(DYNCFGMMC_DATA)
    rand uvm_reg_field DYNCFGMMC_RDATA;
    rand uvm_reg_field DYNCFGMMC_WDATA;

    //---build------------------------------------------------------------
    virtual function void build();
        DYNCFGMMC_RDATA = uvm_reg_field::type_id::create("DYNCFGMMC_RDATA");
        DYNCFGMMC_WDATA = uvm_reg_field::type_id::create("DYNCFGMMC_WDATA");

        DYNCFGMMC_RDATA.configure(this, 16, 16, "RO", 1, 'b000000000000000, 1, 1, 1);
        DYNCFGMMC_WDATA.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_DATA_wr_cg";
        DYNCFGMMC_WDATA_wr : coverpoint DYNCFGMMC_WDATA.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_DYNCFGMMC_DATA_rd_cg";
        DYNCFGMMC_RDATA_rd : coverpoint DYNCFGMMC_RDATA.value[15:0];
        DYNCFGMMC_WDATA_rd : coverpoint DYNCFGMMC_WDATA.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DYNCFGMMC_DATA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_REF44
//--------------------------------------------------------------------
class FMETRE_REF44 extends uvm_reg;
    `uvm_object_utils(FMETRE_REF44)
    rand uvm_reg_field FMETRE_REF44;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_REF44 = uvm_reg_field::type_id::create("FMETRE_REF44");

        FMETRE_REF44.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_REF44_rd_cg";
        FMETRE_REF44_rd : coverpoint FMETRE_REF44.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_REF44");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_REF30
//--------------------------------------------------------------------
class FMETRE_REF30 extends uvm_reg;
    `uvm_object_utils(FMETRE_REF30)
    rand uvm_reg_field FMETRE_REF30;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_REF30 = uvm_reg_field::type_id::create("FMETRE_REF30");

        FMETRE_REF30.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_REF30_rd_cg";
        FMETRE_REF30_rd : coverpoint FMETRE_REF30.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_REF30");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_REF60
//--------------------------------------------------------------------
class FMETRE_REF60 extends uvm_reg;
    `uvm_object_utils(FMETRE_REF60)
    rand uvm_reg_field FMETRE_REF60;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_REF60 = uvm_reg_field::type_id::create("FMETRE_REF60");

        FMETRE_REF60.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_REF60_rd_cg";
        FMETRE_REF60_rd : coverpoint FMETRE_REF60.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_REF60");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_REF40
//--------------------------------------------------------------------
class FMETRE_REF40 extends uvm_reg;
    `uvm_object_utils(FMETRE_REF40)
    rand uvm_reg_field FMETRE_REF40;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_REF40 = uvm_reg_field::type_id::create("FMETRE_REF40");

        FMETRE_REF40.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_REF40_rd_cg";
        FMETRE_REF40_rd : coverpoint FMETRE_REF40.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_REF40");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_REF80
//--------------------------------------------------------------------
class FMETRE_REF80 extends uvm_reg;
    `uvm_object_utils(FMETRE_REF80)
    rand uvm_reg_field FMETRE_REF80;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_REF80 = uvm_reg_field::type_id::create("FMETRE_REF80");

        FMETRE_REF80.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_REF80_rd_cg";
        FMETRE_REF80_rd : coverpoint FMETRE_REF80.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_REF80");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_FE
//--------------------------------------------------------------------
class FMETRE_FE extends uvm_reg;
    `uvm_object_utils(FMETRE_FE)
    rand uvm_reg_field FMETRE_FE;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_FE = uvm_reg_field::type_id::create("FMETRE_FE");

        FMETRE_FE.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_FE_rd_cg";
        FMETRE_FE_rd : coverpoint FMETRE_FE.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_FE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_BD
//--------------------------------------------------------------------
class FMETRE_BD extends uvm_reg;
    `uvm_object_utils(FMETRE_BD)
    rand uvm_reg_field FMETRE_BD;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_BD = uvm_reg_field::type_id::create("FMETRE_BD");

        FMETRE_BD.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_BD_rd_cg";
        FMETRE_BD_rd : coverpoint FMETRE_BD.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_BD");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_PHY
//--------------------------------------------------------------------
class FMETRE_PHY extends uvm_reg;
    `uvm_object_utils(FMETRE_PHY)
    rand uvm_reg_field FMETRE_PHY;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_PHY = uvm_reg_field::type_id::create("FMETRE_PHY");

        FMETRE_PHY.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_PHY_rd_cg";
        FMETRE_PHY_rd : coverpoint FMETRE_PHY.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_PHY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_MPIF
//--------------------------------------------------------------------
class FMETRE_MPIF extends uvm_reg;
    `uvm_object_utils(FMETRE_MPIF)
    rand uvm_reg_field FMETRE_MPIF;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_MPIF = uvm_reg_field::type_id::create("FMETRE_MPIF");

        FMETRE_MPIF.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_MPIF_rd_cg";
        FMETRE_MPIF_rd : coverpoint FMETRE_MPIF.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_MPIF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_LA
//--------------------------------------------------------------------
class FMETRE_LA extends uvm_reg;
    `uvm_object_utils(FMETRE_LA)
    rand uvm_reg_field FMETRE_LA;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_LA = uvm_reg_field::type_id::create("FMETRE_LA");

        FMETRE_LA.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_LA_rd_cg";
        FMETRE_LA_rd : coverpoint FMETRE_LA.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_LA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_MACCORE
//--------------------------------------------------------------------
class FMETRE_MACCORE extends uvm_reg;
    `uvm_object_utils(FMETRE_MACCORE)
    rand uvm_reg_field FMETRE_MACCORE;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_MACCORE = uvm_reg_field::type_id::create("FMETRE_MACCORE");

        FMETRE_MACCORE.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_MACCORE_rd_cg";
        FMETRE_MACCORE_rd : coverpoint FMETRE_MACCORE.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_MACCORE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_MACWT
//--------------------------------------------------------------------
class FMETRE_MACWT extends uvm_reg;
    `uvm_object_utils(FMETRE_MACWT)
    rand uvm_reg_field FMETRE_MACWT;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_MACWT = uvm_reg_field::type_id::create("FMETRE_MACWT");

        FMETRE_MACWT.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_MACWT_rd_cg";
        FMETRE_MACWT_rd : coverpoint FMETRE_MACWT.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_MACWT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FMETRE_PLF
//--------------------------------------------------------------------
class FMETRE_PLF extends uvm_reg;
    `uvm_object_utils(FMETRE_PLF)
    rand uvm_reg_field FMETRE_PLF;

    //---build------------------------------------------------------------
    virtual function void build();
        FMETRE_PLF = uvm_reg_field::type_id::create("FMETRE_PLF");

        FMETRE_PLF.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_FMETRE_PLF_rd_cg";
        FMETRE_PLF_rd : coverpoint FMETRE_PLF.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FMETRE_PLF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LA_SAMPLING_FREQ
//--------------------------------------------------------------------
class LA_SAMPLING_FREQ extends uvm_reg;
    `uvm_object_utils(LA_SAMPLING_FREQ)
    rand uvm_reg_field LA_SAMPLING_FREQ;

    //---build------------------------------------------------------------
    virtual function void build();
        LA_SAMPLING_FREQ = uvm_reg_field::type_id::create("LA_SAMPLING_FREQ");

        LA_SAMPLING_FREQ.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="CRM_LA_SAMPLING_FREQ_wr_cg";
        LA_SAMPLING_FREQ_wr : coverpoint LA_SAMPLING_FREQ.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="CRM_LA_SAMPLING_FREQ_rd_cg";
        LA_SAMPLING_FREQ_rd : coverpoint LA_SAMPLING_FREQ.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LA_SAMPLING_FREQ");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class CRM_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(CRM_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins CLKRST_CNTL              = {'h8};
        bins CLKRST_STAT              = {'hC};
        bins CLKGATEPHYFCTRL0              = {'h10};
        bins CLKGATEPHYFCTRL1              = {'h14};
        bins RSTCTRL              = {'h18};
        bins DYNCFGMMC_CNTL              = {'h300};
        bins DYNCFGMMC_ADDR              = {'h304};
        bins DYNCFGMMC_DATA              = {'h308};
        bins FMETRE_REF44              = {'h310};
        bins FMETRE_REF30              = {'h314};
        bins FMETRE_REF60              = {'h318};
        bins FMETRE_REF40              = {'h31C};
        bins FMETRE_REF80              = {'h320};
        bins FMETRE_FE              = {'h324};
        bins FMETRE_BD              = {'h328};
        bins FMETRE_PHY              = {'h32C};
        bins FMETRE_MPIF              = {'h330};
        bins FMETRE_LA              = {'h334};
        bins FMETRE_MACCORE              = {'h338};
        bins FMETRE_MACWT              = {'h33C};
        bins FMETRE_PLF              = {'h340};
        bins LA_SAMPLING_FREQ              = {'h6C};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "CRM_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: CRM_reg_access_wrapper

//-------------------------------------------------------------------
// CRM_register_block
//--------------------------------------------------------------------
class CRM_register_block extends uvm_reg_block;
    `uvm_object_utils(CRM_register_block)

    rand CLKRST_CNTL CLKRST_CNTL_reg;
    rand CLKRST_STAT CLKRST_STAT_reg;
    rand CLKGATEPHYFCTRL0 CLKGATEPHYFCTRL0_reg;
    rand CLKGATEPHYFCTRL1 CLKGATEPHYFCTRL1_reg;
    rand RSTCTRL RSTCTRL_reg;
    rand DYNCFGMMC_CNTL DYNCFGMMC_CNTL_reg;
    rand DYNCFGMMC_ADDR DYNCFGMMC_ADDR_reg;
    rand DYNCFGMMC_DATA DYNCFGMMC_DATA_reg;
    rand FMETRE_REF44 FMETRE_REF44_reg;
    rand FMETRE_REF30 FMETRE_REF30_reg;
    rand FMETRE_REF60 FMETRE_REF60_reg;
    rand FMETRE_REF40 FMETRE_REF40_reg;
    rand FMETRE_REF80 FMETRE_REF80_reg;
    rand FMETRE_FE FMETRE_FE_reg;
    rand FMETRE_BD FMETRE_BD_reg;
    rand FMETRE_PHY FMETRE_PHY_reg;
    rand FMETRE_MPIF FMETRE_MPIF_reg;
    rand FMETRE_LA FMETRE_LA_reg;
    rand FMETRE_MACCORE FMETRE_MACCORE_reg;
    rand FMETRE_MACWT FMETRE_MACWT_reg;
    rand FMETRE_PLF FMETRE_PLF_reg;
    rand LA_SAMPLING_FREQ LA_SAMPLING_FREQ_reg;

    uvm_reg_map CRM_register_map; // Block map
    CRM_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "CRM_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = CRM_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        CLKRST_CNTL_reg = CLKRST_CNTL::type_id::create("CLKRST_CNTL");
        CLKRST_CNTL_reg.configure(this);
        CLKRST_CNTL_reg.build();

        CLKRST_STAT_reg = CLKRST_STAT::type_id::create("CLKRST_STAT");
        CLKRST_STAT_reg.configure(this);
        CLKRST_STAT_reg.build();

        CLKGATEPHYFCTRL0_reg = CLKGATEPHYFCTRL0::type_id::create("CLKGATEPHYFCTRL0");
        CLKGATEPHYFCTRL0_reg.configure(this);
        CLKGATEPHYFCTRL0_reg.build();

        CLKGATEPHYFCTRL1_reg = CLKGATEPHYFCTRL1::type_id::create("CLKGATEPHYFCTRL1");
        CLKGATEPHYFCTRL1_reg.configure(this);
        CLKGATEPHYFCTRL1_reg.build();

        RSTCTRL_reg = RSTCTRL::type_id::create("RSTCTRL");
        RSTCTRL_reg.configure(this);
        RSTCTRL_reg.build();

        DYNCFGMMC_CNTL_reg = DYNCFGMMC_CNTL::type_id::create("DYNCFGMMC_CNTL");
        DYNCFGMMC_CNTL_reg.configure(this);
        DYNCFGMMC_CNTL_reg.build();

        DYNCFGMMC_ADDR_reg = DYNCFGMMC_ADDR::type_id::create("DYNCFGMMC_ADDR");
        DYNCFGMMC_ADDR_reg.configure(this);
        DYNCFGMMC_ADDR_reg.build();

        DYNCFGMMC_DATA_reg = DYNCFGMMC_DATA::type_id::create("DYNCFGMMC_DATA");
        DYNCFGMMC_DATA_reg.configure(this);
        DYNCFGMMC_DATA_reg.build();

        FMETRE_REF44_reg = FMETRE_REF44::type_id::create("FMETRE_REF44");
        FMETRE_REF44_reg.configure(this);
        FMETRE_REF44_reg.build();

        FMETRE_REF30_reg = FMETRE_REF30::type_id::create("FMETRE_REF30");
        FMETRE_REF30_reg.configure(this);
        FMETRE_REF30_reg.build();

        FMETRE_REF60_reg = FMETRE_REF60::type_id::create("FMETRE_REF60");
        FMETRE_REF60_reg.configure(this);
        FMETRE_REF60_reg.build();

        FMETRE_REF40_reg = FMETRE_REF40::type_id::create("FMETRE_REF40");
        FMETRE_REF40_reg.configure(this);
        FMETRE_REF40_reg.build();

        FMETRE_REF80_reg = FMETRE_REF80::type_id::create("FMETRE_REF80");
        FMETRE_REF80_reg.configure(this);
        FMETRE_REF80_reg.build();

        FMETRE_FE_reg = FMETRE_FE::type_id::create("FMETRE_FE");
        FMETRE_FE_reg.configure(this);
        FMETRE_FE_reg.build();

        FMETRE_BD_reg = FMETRE_BD::type_id::create("FMETRE_BD");
        FMETRE_BD_reg.configure(this);
        FMETRE_BD_reg.build();

        FMETRE_PHY_reg = FMETRE_PHY::type_id::create("FMETRE_PHY");
        FMETRE_PHY_reg.configure(this);
        FMETRE_PHY_reg.build();

        FMETRE_MPIF_reg = FMETRE_MPIF::type_id::create("FMETRE_MPIF");
        FMETRE_MPIF_reg.configure(this);
        FMETRE_MPIF_reg.build();

        FMETRE_LA_reg = FMETRE_LA::type_id::create("FMETRE_LA");
        FMETRE_LA_reg.configure(this);
        FMETRE_LA_reg.build();

        FMETRE_MACCORE_reg = FMETRE_MACCORE::type_id::create("FMETRE_MACCORE");
        FMETRE_MACCORE_reg.configure(this);
        FMETRE_MACCORE_reg.build();

        FMETRE_MACWT_reg = FMETRE_MACWT::type_id::create("FMETRE_MACWT");
        FMETRE_MACWT_reg.configure(this);
        FMETRE_MACWT_reg.build();

        FMETRE_PLF_reg = FMETRE_PLF::type_id::create("FMETRE_PLF");
        FMETRE_PLF_reg.configure(this);
        FMETRE_PLF_reg.build();

        LA_SAMPLING_FREQ_reg = LA_SAMPLING_FREQ::type_id::create("LA_SAMPLING_FREQ");
        LA_SAMPLING_FREQ_reg.configure(this);
        LA_SAMPLING_FREQ_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        CRM_register_map = create_map("CRM_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        CRM_register_map.add_reg(CLKRST_CNTL_reg, 'h8, "RW");
        CRM_register_map.add_reg(CLKRST_STAT_reg, 'hC, "RO");
        CRM_register_map.add_reg(CLKGATEPHYFCTRL0_reg, 'h10, "RW");
        CRM_register_map.add_reg(CLKGATEPHYFCTRL1_reg, 'h14, "RW");
        CRM_register_map.add_reg(RSTCTRL_reg, 'h18, "RW");
        CRM_register_map.add_reg(DYNCFGMMC_CNTL_reg, 'h300, "RW");
        CRM_register_map.add_reg(DYNCFGMMC_ADDR_reg, 'h304, "RW");
        CRM_register_map.add_reg(DYNCFGMMC_DATA_reg, 'h308, "RW");
        CRM_register_map.add_reg(FMETRE_REF44_reg, 'h310, "RO");
        CRM_register_map.add_reg(FMETRE_REF30_reg, 'h314, "RO");
        CRM_register_map.add_reg(FMETRE_REF60_reg, 'h318, "RO");
        CRM_register_map.add_reg(FMETRE_REF40_reg, 'h31C, "RO");
        CRM_register_map.add_reg(FMETRE_REF80_reg, 'h320, "RO");
        CRM_register_map.add_reg(FMETRE_FE_reg, 'h324, "RO");
        CRM_register_map.add_reg(FMETRE_BD_reg, 'h328, "RO");
        CRM_register_map.add_reg(FMETRE_PHY_reg, 'h32C, "RO");
        CRM_register_map.add_reg(FMETRE_MPIF_reg, 'h330, "RO");
        CRM_register_map.add_reg(FMETRE_LA_reg, 'h334, "RO");
        CRM_register_map.add_reg(FMETRE_MACCORE_reg, 'h338, "RO");
        CRM_register_map.add_reg(FMETRE_MACWT_reg, 'h33C, "RO");
        CRM_register_map.add_reg(FMETRE_PLF_reg, 'h340, "RO");
        CRM_register_map.add_reg(LA_SAMPLING_FREQ_reg, 'h6C, "RW");

        // Lock the register model and build the map
        lock_model();
        CRM_register_map.set_check_on_read();
    endfunction

endclass
`endif // __CRM_REG_BLOCK_SV__
